-- MySQL Workbench Forward Engineering

SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='TRADITIONAL,ALLOW_INVALID_DATES';

-- -----------------------------------------------------
-- Schema mydb
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Schema mydb
-- -----------------------------------------------------
CREATE SCHEMA IF NOT EXISTS `mydb` DEFAULT CHARACTER SET utf8 ;
USE `mydb` ;

-- -----------------------------------------------------
-- Table `mydb`.`MediaObjects`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`MediaObjects` (
  `imdb_id` VARCHAR(9) NOT NULL,
  `title_german` VARCHAR(255) NOT NULL,
  `title_original` VARCHAR(255) NOT NULL,
  `year` INT NULL,
  `rating` FLOAT(2,1) NULL,
  `summary` TEXT NULL,
  `tagline` TEXT NULL,
  `update` DATETIME NULL,
  PRIMARY KEY (`imdb_id`),
  UNIQUE INDEX `imdbID_UNIQUE` (`imdb_id` ASC))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`MovieCollections`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`MovieCollections` (
  `title_german` VARCHAR(255) NOT NULL,
  `title_original` VARCHAR(255) NOT NULL,
  `collection_id` INT NOT NULL,
  PRIMARY KEY (`collection_id`),
  UNIQUE INDEX `collection_id_UNIQUE` (`collection_id` ASC))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`Movies`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`Movies` (
  `imdb_id` VARCHAR(9) NOT NULL,
  `collection_id` INT NULL,
  `youtube_trailer` VARCHAR(14) NULL,
  `fsk` INT NULL,
  UNIQUE INDEX `imdbID_UNIQUE` (`imdb_id` ASC),
  INDEX `collection_id_idx` (`collection_id` ASC),
  CONSTRAINT `imdb_id`
    FOREIGN KEY (`imdb_id`)
    REFERENCES `mydb`.`MediaObjects` (`imdb_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `collection_id`
    FOREIGN KEY (`collection_id`)
    REFERENCES `mydb`.`MovieCollections` (`collection_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`Series`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`Series` (
  `imdb_id` VARCHAR(9) NOT NULL,
  `finished` TINYINT(1) NULL,
  `tvdb_id` VARCHAR(10) NULL,
  UNIQUE INDEX `imdb_id_UNIQUE` (`imdb_id` ASC),
  CONSTRAINT `imdb_id`
    FOREIGN KEY (`imdb_id`)
    REFERENCES `mydb`.`MediaObjects` (`imdb_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`Seasons`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`Seasons` (
  `imdb_id` VARCHAR(9) NOT NULL,
  `season_nr` INT NOT NULL,
  `fsk` INT NULL,
  `comment` VARCHAR(255) NULL,
  UNIQUE INDEX `imdb_id_UNIQUE` (`imdb_id` ASC),
  PRIMARY KEY (`season_nr`),
  UNIQUE INDEX `season_nr_UNIQUE` (`season_nr` ASC),
  CONSTRAINT `imdb_id`
    FOREIGN KEY (`imdb_id`)
    REFERENCES `mydb`.`MediaObjects` (`imdb_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`Episodes`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`Episodes` (
  `imdb_id` VARCHAR(9) NOT NULL,
  `season_nr` INT NOT NULL,
  `source` VARCHAR(45) NULL,
  `name` VARCHAR(255) NULL,
  UNIQUE INDEX `imdbID_UNIQUE` (`imdb_id` ASC),
  INDEX `season_nr_idx` (`season_nr` ASC),
  CONSTRAINT `imdb_id`
    FOREIGN KEY (`imdb_id`)
    REFERENCES `mydb`.`MediaObjects` (`imdb_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `season_nr`
    FOREIGN KEY (`season_nr`)
    REFERENCES `mydb`.`Seasons` (`season_nr`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`Persons`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`Persons` (
  `person_id` VARCHAR(9) NOT NULL,
  `name` VARCHAR(255) NULL,
  `birthday` DATE NULL,
  `deathday` DATE NULL,
  `gender` ENUM('male', 'female') NULL,
  PRIMARY KEY (`person_id`),
  UNIQUE INDEX `actor_id_UNIQUE` (`person_id` ASC))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`MediaObjectPersons`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`MediaObjectPersons` (
  `imdb_id` VARCHAR(9) NULL,
  `actor_id` VARCHAR(9) NULL,
  `role` VARCHAR(255) NULL,
  `role_id???` VARCHAR(9) NULL,
  `Typ` ENUM('actor', 'director', 'author') NULL,
  `MediaObjectPersonscol` VARCHAR(45) NULL,
  INDEX `imdb_id_idx` (`imdb_id` ASC),
  INDEX `actor_id_idx` (`actor_id` ASC),
  CONSTRAINT `imdb_id`
    FOREIGN KEY (`imdb_id`)
    REFERENCES `mydb`.`MediaObjects` (`imdb_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `actor_id`
    FOREIGN KEY (`actor_id`)
    REFERENCES `mydb`.`Persons` (`person_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`Genres`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`Genres` (
  `genre_id` INT NOT NULL,
  `name_german` VARCHAR(45) NULL,
  `name_english` VARCHAR(45) NULL,
  PRIMARY KEY (`genre_id`),
  UNIQUE INDEX `genre_id_UNIQUE` (`genre_id` ASC))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`MediaObjectGenre`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`MediaObjectGenre` (
  `genre_id` INT NOT NULL,
  `imdb_id` VARCHAR(9) NOT NULL,
  INDEX `imdb_id_idx` (`imdb_id` ASC),
  INDEX `genre_id_idx` (`genre_id` ASC),
  CONSTRAINT `imdb_id`
    FOREIGN KEY (`imdb_id`)
    REFERENCES `mydb`.`MediaObjects` (`imdb_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `genre_id`
    FOREIGN KEY (`genre_id`)
    REFERENCES `mydb`.`Genres` (`genre_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`Files`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`Files` (
  `file_id` INT NOT NULL,
  `imdb_id` VARCHAR(9) NOT NULL,
  `size` BIGINT(20) NULL,
  `checksum` VARCHAR(32) NULL,
  `dimensions` VARCHAR(45) NULL,
  `video_container` VARCHAR(255) NULL,
  `video_codec` VARCHAR(255) NULL,
  `hdr` VARCHAR(255) NULL,
  `bitdepth` VARCHAR(255) NULL,
  `duration` INT NULL,
  `overall_bitrate` INT NULL,
  `resolution` VARCHAR(255) NULL,
  `width` INT NULL,
  `height` INT NULL,
  `hdd` VARCHAR(255) NULL,
  `encoding_mode` VARCHAR(45) NULL,
  `encoding_quality` FLOAT(6,1) NULL,
  `status` TINYINT(1) NULL,
  `comment` VARCHAR(255) NULL,
  `cut` VARCHAR(255) NULL,
  `added` DATETIME NULL,
  `update` DATETIME NULL,
  PRIMARY KEY (`file_id`),
  UNIQUE INDEX `file_id_UNIQUE` (`file_id` ASC),
  INDEX `imdb_id_idx` (`imdb_id` ASC),
  CONSTRAINT `imdb_id`
    FOREIGN KEY (`imdb_id`)
    REFERENCES `mydb`.`MediaObjects` (`imdb_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`Views`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`Views` (
  `imdb_id` VARCHAR(9) NOT NULL,
  `file_id` INT NOT NULL,
  `date` DATETIME NOT NULL,
  INDEX `fk_Views_1_idx` (`file_id` ASC),
  CONSTRAINT `imdb_id`
    FOREIGN KEY ()
    REFERENCES `mydb`.`MediaObjects` ()
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_Views_1`
    FOREIGN KEY (`file_id`)
    REFERENCES `mydb`.`Files` (`file_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`AudioTracks`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`AudioTracks` (
  `file_id` INT NOT NULL,
  `language` VARCHAR(3) NULL,
  `codec` VARCHAR(255) NULL,
  `bitrate` INT NULL,
  `channels` INT NULL,
  INDEX `imdb_id_idx` (`file_id` ASC),
  CONSTRAINT `file_id`
    FOREIGN KEY (`file_id`)
    REFERENCES `mydb`.`Files` (`file_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`Countries`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`Countries` (
  `country_id` INT NOT NULL,
  `name_german` VARCHAR(45) NULL,
  `name_english` VARCHAR(45) NULL,
  PRIMARY KEY (`country_id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`MediaObjectsCountries`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`MediaObjectsCountries` (
  `imdb_id` VARCHAR(9) NOT NULL,
  `country_id` INT NOT NULL,
  INDEX `fk_MediaObjects_has_Countries_Countries1_idx` (`country_id` ASC),
  INDEX `fk_MediaObjects_has_Countries_MediaObjects1_idx` (`imdb_id` ASC),
  CONSTRAINT `fk_MediaObjects_has_Countries_MediaObjects1`
    FOREIGN KEY (`imdb_id`)
    REFERENCES `mydb`.`MediaObjects` (`imdb_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_MediaObjects_has_Countries_Countries1`
    FOREIGN KEY (`country_id`)
    REFERENCES `mydb`.`Countries` (`country_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`AccessKey`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`AccessKey` (
  `AccessKey` VARCHAR(10) NOT NULL,
  `Kommentar` VARCHAR(255) NULL,
  `Debug` TINYINT(1) NULL,
  `FileInfo` TINYINT(1) NULL,
  `ViewWatchStatstic` TINYINT(1) NULL,
  `UpdateWatchStatstic` TINYINT(1) NULL,
  `WebApp` TINYINT(1) NULL,
  PRIMARY KEY (`AccessKey`),
  UNIQUE INDEX `AccessKey_UNIQUE` (`AccessKey` ASC))
ENGINE = InnoDB;


SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;
