-- MySQL Workbench Forward Engineering

SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='TRADITIONAL,ALLOW_INVALID_DATES';

-- -----------------------------------------------------
-- Schema MediaDB2
-- -----------------------------------------------------
DROP SCHEMA IF EXISTS `MediaDB2` ;

-- -----------------------------------------------------
-- Schema MediaDB2
-- -----------------------------------------------------
CREATE SCHEMA IF NOT EXISTS `MediaDB2` DEFAULT CHARACTER SET utf8 ;
SHOW WARNINGS;
USE `MediaDB2` ;

-- -----------------------------------------------------
-- Table `MediaDB2`.`MediaObjects`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `MediaDB2`.`MediaObjects` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `MediaDB2`.`MediaObjects` (
  `imdb_id` VARCHAR(9) NOT NULL COMMENT 'IMDB ID',
  `title_german` VARCHAR(255) NOT NULL COMMENT 'Deutscher Titel',
  `title_original` VARCHAR(255) NOT NULL COMMENT 'Original Titel',
  `year` INT NULL COMMENT 'Erscheinungsjahr',
  `rating` FLOAT(2,1) NULL COMMENT 'Bewertung',
  `summary` TEXT NULL COMMENT 'Zusammenfassung',
  `last_update` DATETIME NULL COMMENT 'Letzte Aktualisierung',
  `type` ENUM('series', 'episode', 'movie') NOT NULL COMMENT 'Typ',
  PRIMARY KEY (`imdb_id`),
  UNIQUE INDEX `imdbID_UNIQUE` (`imdb_id` ASC))
ENGINE = InnoDB;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `MediaDB2`.`MovieCollections`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `MediaDB2`.`MovieCollections` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `MediaDB2`.`MovieCollections` (
  `title_german` VARCHAR(255) NOT NULL COMMENT 'Deutscher Kollektionsname',
  `title_original` VARCHAR(255) NOT NULL COMMENT 'Originaler Kollektionsname',
  `collection_id` INT NOT NULL,
  PRIMARY KEY (`collection_id`),
  UNIQUE INDEX `collection_id_UNIQUE` (`collection_id` ASC))
ENGINE = InnoDB;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `MediaDB2`.`Movies`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `MediaDB2`.`Movies` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `MediaDB2`.`Movies` (
  `imdb_id` VARCHAR(9) NOT NULL,
  `collection_id` INT NULL COMMENT 'Kollektion',
  `youtube_trailer` VARCHAR(14) NULL COMMENT 'Youtube Trailer',
  `fsk` INT NULL COMMENT 'Altersfreigabe (FSK)',
  `tagline` TEXT NULL COMMENT 'Slogan',
  UNIQUE INDEX `imdbID_UNIQUE` (`imdb_id` ASC),
  INDEX `collection_id_idx` (`collection_id` ASC),
  CONSTRAINT `imdb_id_MediaObj_Movie`
    FOREIGN KEY (`imdb_id`)
    REFERENCES `MediaDB2`.`MediaObjects` (`imdb_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `collection_id`
    FOREIGN KEY (`collection_id`)
    REFERENCES `MediaDB2`.`MovieCollections` (`collection_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `MediaDB2`.`Series`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `MediaDB2`.`Series` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `MediaDB2`.`Series` (
  `imdb_id` VARCHAR(9) NOT NULL,
  `finished` TINYINT(1) NULL COMMENT 'Abgeschlossen',
  `tvdb_id` VARCHAR(10) NULL COMMENT 'TVDB ID',
  UNIQUE INDEX `imdb_id_UNIQUE` (`imdb_id` ASC),
  CONSTRAINT `imdb_id_MediaObj_Series`
    FOREIGN KEY (`imdb_id`)
    REFERENCES `MediaDB2`.`MediaObjects` (`imdb_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `MediaDB2`.`Episodes`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `MediaDB2`.`Episodes` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `MediaDB2`.`Episodes` (
  `imdb_id` VARCHAR(9) NOT NULL,
  `series_imdb_id` VARCHAR(9) NOT NULL,
  `season_nr` INT NOT NULL COMMENT 'Staffel',
  ` episode_nr` INT NOT NULL COMMENT 'Episode',
  `fsk` INT NULL COMMENT 'Altersfreigabe',
  `comment` VARCHAR(255) NULL COMMENT 'Kommentar',
  UNIQUE INDEX `imdbID_UNIQUE` (`imdb_id` ASC),
  INDEX `series_imdb_id_MediaObj_Episodes_idx` (`series_imdb_id` ASC),
  CONSTRAINT `imdb_id_MediaObj_Episodes`
    FOREIGN KEY (`imdb_id`)
    REFERENCES `MediaDB2`.`MediaObjects` (`imdb_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `series_imdb_id_MediaObj_Episodes`
    FOREIGN KEY (`series_imdb_id`)
    REFERENCES `MediaDB2`.`MediaObjects` (`imdb_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `MediaDB2`.`Persons`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `MediaDB2`.`Persons` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `MediaDB2`.`Persons` (
  `person_id` VARCHAR(9) NOT NULL,
  `name` VARCHAR(255) NULL COMMENT 'Name',
  `birthday` DATE NULL COMMENT 'Geburstag',
  `deathday` DATE NULL COMMENT 'Todestag',
  `gender` ENUM('male', 'female') NULL COMMENT 'Geschlecht',
  PRIMARY KEY (`person_id`),
  UNIQUE INDEX `actor_id_UNIQUE` (`person_id` ASC))
ENGINE = InnoDB;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `MediaDB2`.`MediaObjectPersons`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `MediaDB2`.`MediaObjectPersons` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `MediaDB2`.`MediaObjectPersons` (
  `imdb_id` VARCHAR(9) NOT NULL,
  `actor_id` VARCHAR(9) NOT NULL,
  `role_id` VARCHAR(9) NULL,
  `role` VARCHAR(255) NULL COMMENT 'Rolle',
  `type` ENUM('actor', 'director', 'writer') NOT NULL COMMENT 'Typ',
  INDEX `imdb_id_idx` (`imdb_id` ASC),
  INDEX `actor_id_idx` (`actor_id` ASC),
  CONSTRAINT `imdb_id_MediaObj_Persons`
    FOREIGN KEY (`imdb_id`)
    REFERENCES `MediaDB2`.`MediaObjects` (`imdb_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `actor_id`
    FOREIGN KEY (`actor_id`)
    REFERENCES `MediaDB2`.`Persons` (`person_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `MediaDB2`.`Genres`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `MediaDB2`.`Genres` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `MediaDB2`.`Genres` (
  `genre_id` INT NOT NULL,
  `name_german` VARCHAR(45) NULL COMMENT 'Genre (DE)',
  `name_english` VARCHAR(45) NULL COMMENT 'Genre (EN)',
  PRIMARY KEY (`genre_id`),
  UNIQUE INDEX `genre_id_UNIQUE` (`genre_id` ASC))
ENGINE = InnoDB;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `MediaDB2`.`MediaObjectGenre`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `MediaDB2`.`MediaObjectGenre` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `MediaDB2`.`MediaObjectGenre` (
  `genre_id` INT NOT NULL,
  `imdb_id` VARCHAR(9) NOT NULL,
  INDEX `imdb_id_idx` (`imdb_id` ASC),
  INDEX `genre_id_idx` (`genre_id` ASC),
  CONSTRAINT `imdb_id_MediaObj_MOGenre`
    FOREIGN KEY (`imdb_id`)
    REFERENCES `MediaDB2`.`MediaObjects` (`imdb_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `genre_id`
    FOREIGN KEY (`genre_id`)
    REFERENCES `MediaDB2`.`Genres` (`genre_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `MediaDB2`.`Files`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `MediaDB2`.`Files` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `MediaDB2`.`Files` (
  `file_id` INT NOT NULL AUTO_INCREMENT,
  `imdb_id` VARCHAR(9) NOT NULL,
  `size` BIGINT(20) NULL COMMENT 'Größe',
  `checksum` VARCHAR(32) NULL COMMENT 'MD5-Summe',
  `dimensions` VARCHAR(45) NULL COMMENT 'Dimension',
  `source` VARCHAR(45) NULL COMMENT 'Quelle',
  `video_container` VARCHAR(255) NULL COMMENT 'Videokontainer',
  `video_codec` VARCHAR(255) NULL COMMENT 'Videocodec',
  `hdr` VARCHAR(255) NULL COMMENT 'HDR',
  `bitdepth` INT NULL COMMENT 'Bittiefe',
  `duration` INT NULL COMMENT 'Laufzeit',
  `overall_bitrate` INT NULL COMMENT 'Gesamtbitrate',
  `resolution` VARCHAR(255) NULL COMMENT 'Auflösung',
  `width` INT NULL COMMENT 'Bildbreite',
  `height` INT NULL COMMENT 'Bildhöhe',
  `fps` FLOAT(6,3) NULL COMMENT 'Bildwiederholrate',
  `hdd` VARCHAR(255) NULL COMMENT 'Festplatte',
  `encoding_mode` VARCHAR(45) NULL COMMENT 'Encoding Modus',
  `encoding_quality` FLOAT(6,1) NULL COMMENT 'Encoding Qualität',
  `status` TINYINT(1) NULL COMMENT 'Status',
  `comment` VARCHAR(255) NULL COMMENT 'Kommentar',
  `cut` VARCHAR(255) NULL COMMENT 'Schnitt',
  `added` DATETIME NULL COMMENT 'Hinzugefügt',
  `last_checked` DATETIME NULL COMMENT 'Letzte Überprüfung',
  PRIMARY KEY (`file_id`),
  UNIQUE INDEX `file_id_UNIQUE` (`file_id` ASC),
  INDEX `imdb_id_idx` (`imdb_id` ASC),
  CONSTRAINT `imdb_id_MediaObj_Files`
    FOREIGN KEY (`imdb_id`)
    REFERENCES `MediaDB2`.`MediaObjects` (`imdb_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `MediaDB2`.`ViewGroups`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `MediaDB2`.`ViewGroups` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `MediaDB2`.`ViewGroups` (
  `ViewGroupID` INT NOT NULL AUTO_INCREMENT,
  `Name` VARCHAR(45) NULL,
  PRIMARY KEY (`ViewGroupID`))
ENGINE = InnoDB;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `MediaDB2`.`Views`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `MediaDB2`.`Views` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `MediaDB2`.`Views` (
  `imdb_id` VARCHAR(9) NOT NULL COMMENT 'IMDB ID',
  `file_id` INT NULL COMMENT 'Datei ID',
  `ViewGroupID` INT NOT NULL,
  `date` DATETIME NOT NULL COMMENT 'Gesehen am',
  INDEX `fk_Views_1_idx` (`file_id` ASC),
  INDEX `imdb_id_MediaObj_Views_idx` (`imdb_id` ASC),
  INDEX `fk_Views_ViewGroups1_idx` (`ViewGroupID` ASC),
  CONSTRAINT `imdb_id_MediaObj_Views`
    FOREIGN KEY (`imdb_id`)
    REFERENCES `MediaDB2`.`MediaObjects` (`imdb_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_Views_1`
    FOREIGN KEY (`file_id`)
    REFERENCES `MediaDB2`.`Files` (`file_id`)
    ON DELETE SET NULL
    ON UPDATE SET NULL,
  CONSTRAINT `fk_Views_ViewGroups1`
    FOREIGN KEY (`ViewGroupID`)
    REFERENCES `MediaDB2`.`ViewGroups` (`ViewGroupID`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `MediaDB2`.`AudioTracks`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `MediaDB2`.`AudioTracks` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `MediaDB2`.`AudioTracks` (
  `file_id` INT NOT NULL,
  `language` VARCHAR(3) NULL COMMENT 'Sprache',
  `codec` VARCHAR(255) NULL COMMENT 'Codec',
  `bitrate` INT NULL COMMENT 'Audio Bitrate',
  `channels` INT NULL COMMENT 'Audiokanäle',
  INDEX `imdb_id_idx` (`file_id` ASC),
  CONSTRAINT `file_id`
    FOREIGN KEY (`file_id`)
    REFERENCES `MediaDB2`.`Files` (`file_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `MediaDB2`.`Countries`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `MediaDB2`.`Countries` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `MediaDB2`.`Countries` (
  `country_id` INT NOT NULL,
  `name_german` VARCHAR(45) NULL COMMENT 'Drehland (DE)',
  `name_english` VARCHAR(45) NULL COMMENT 'Drehland (EN)',
  PRIMARY KEY (`country_id`))
ENGINE = InnoDB;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `MediaDB2`.`MediaObjectsCountries`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `MediaDB2`.`MediaObjectsCountries` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `MediaDB2`.`MediaObjectsCountries` (
  `imdb_id` VARCHAR(9) NOT NULL,
  `country_id` INT NOT NULL,
  INDEX `fk_MediaObjects_has_Countries_Countries1_idx` (`country_id` ASC),
  INDEX `fk_MediaObjects_has_Countries_MediaObjects1_idx` (`imdb_id` ASC),
  CONSTRAINT `fk_MediaObjects_has_Countries_MediaObjects1`
    FOREIGN KEY (`imdb_id`)
    REFERENCES `MediaDB2`.`MediaObjects` (`imdb_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_MediaObjects_has_Countries_Countries1`
    FOREIGN KEY (`country_id`)
    REFERENCES `MediaDB2`.`Countries` (`country_id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `MediaDB2`.`AccessKey`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `MediaDB2`.`AccessKey` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `MediaDB2`.`AccessKey` (
  `AccessKey` VARCHAR(10) NOT NULL,
  `ViewGroupID` INT NOT NULL,
  `Kommentar` VARCHAR(255) NULL,
  `Debug` TINYINT(1) NULL,
  `FileInfo` TINYINT(1) NULL,
  `ViewWatchStatstic` TINYINT(1) NULL,
  `UpdateWatchStatstic` TINYINT(1) NULL,
  `WebApp` TINYINT(1) NULL,
  PRIMARY KEY (`AccessKey`),
  UNIQUE INDEX `AccessKey_UNIQUE` (`AccessKey` ASC),
  INDEX `fk_AccessKey_ViewGroups1_idx` (`ViewGroupID` ASC),
  CONSTRAINT `fk_AccessKey_ViewGroups1`
    FOREIGN KEY (`ViewGroupID`)
    REFERENCES `MediaDB2`.`ViewGroups` (`ViewGroupID`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;

SHOW WARNINGS;

SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;
