package com.example.markus.mediadbviewer;

import android.app.ListFragment;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.ArrayAdapter;
import android.widget.RelativeLayout;
import android.widget.Spinner;
import android.widget.TextView;

import java.util.ArrayList;

public class MovieListFragment extends ListFragment {

    private boolean initialized = false;
    private ArrayList<MediaObject> movieList = new ArrayList<MediaObject>();

    private void updateMovieListView (MovieQueryFactory movieQueryFactory, ListView listView) {

        // notwendige Spalten für ListView können zentral hier geändert werden
        movieQueryFactory.addColumns(new String[]{"name", "year", "rating", "imdbID", "3d", "checked", "views", "duration"});
        JSONParser parser = new JSONParser();
        try {
            parser.execute(new String[]{movieQueryFactory.getUrl()}).get();
        } catch (Exception e) {

        }
        this.movieList = parser.getMediaList();
        getActivity().setTitle("Filme (" + String.valueOf(this.movieList.size()) + ")");

        MovieArrayAdapter movieArrayAdapter = new MovieArrayAdapter(getActivity(), this.movieList);
        listView.setAdapter(movieArrayAdapter);

    }

    public void initializeFragment(ListView movieListView) {

        // Initialisiere ListView mit allen Filmen
        MovieQueryFactory factory = new MovieQueryFactory();
        factory.setOrder("name", "ASC");
        this.updateMovieListView(factory, movieListView);

        MainActivity activity = (MainActivity) this.getActivity(); //hole MainActivity

        //// initialisiere Filter Drawer
        // befülle Spinner für Sortierrichtung
        final Spinner directionSpinner = (Spinner) activity.findViewById(R.id.movieDirectionSpinner);
        ArrayAdapter<CharSequence> directionSpinnerAdapter = ArrayAdapter.createFromResource(activity, R.array.directionSpinner, R.layout.spinner_layout);
        directionSpinnerAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        directionSpinner.setAdapter(directionSpinnerAdapter);

        // befülle Spinner für Sortierkategorie
        final Spinner categorySpinner = (Spinner) activity.findViewById(R.id.movieCategorySpinner);
        ArrayAdapter<CharSequence> categorySpinnerAdapter = ArrayAdapter.createFromResource(activity, R.array.categorySpinner, R.layout.spinner_layout);
        categorySpinnerAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        categorySpinner.setAdapter(categorySpinnerAdapter);

        // befülle Spinner für 3D
        final Spinner dimensionsSpinner = (Spinner) activity.findViewById(R.id.movieDimensionsSpinner);
        ArrayAdapter<CharSequence> dimensionsSpinnerAdapter = ArrayAdapter.createFromResource(activity, R.array.dimensionsSpinner, R.layout.spinner_layout);
        dimensionsSpinnerAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        dimensionsSpinner.setAdapter(dimensionsSpinnerAdapter);

        // befülle Spinner für Genre
        final Spinner genreSpinner = (Spinner) activity.findViewById(R.id.movieGenreSpinner);
        ArrayAdapter<CharSequence> genreSpinnerAdapter = ArrayAdapter.createFromResource(activity, R.array.genreSpinner, R.layout.spinner_layout);
        genreSpinnerAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        genreSpinner.setAdapter(genreSpinnerAdapter);

        // befülle Spinner für Sprache
        final Spinner languageSpinner = (Spinner) activity.findViewById(R.id.movieLanguageSpinner);
        ArrayAdapter<CharSequence> languageSpinnerAdapter = ArrayAdapter.createFromResource(activity, R.array.languageSpiiner, R.layout.spinner_layout);
        languageSpinnerAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        languageSpinner.setAdapter(languageSpinnerAdapter);

        // befülle Acodecger Spinner
        final Spinner acodecgerSpinner = (Spinner) activity.findViewById(R.id.movieAcodecgerSpinner);
        ArrayAdapter<CharSequence> acodecgerSpinnerAdapter = ArrayAdapter.createFromResource(activity, R.array.acodecSpinner, R.layout.spinner_layout);
        acodecgerSpinnerAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        acodecgerSpinner.setAdapter(acodecgerSpinnerAdapter);

        // befülle Acodeceng Spinner
        final Spinner acodecengSpinner = (Spinner) activity.findViewById(R.id.movieAcodecengSpinner);
        ArrayAdapter<CharSequence> acodecengSpinnerAdapter = ArrayAdapter.createFromResource(activity, R.array.acodecSpinner, R.layout.spinner_layout);
        acodecengSpinnerAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        acodecengSpinner.setAdapter(acodecengSpinnerAdapter);

        // befülle vcodec Spinner
        final Spinner vcodecSpinner = (Spinner) activity.findViewById(R.id.movieVcodecSpinner);
        ArrayAdapter<CharSequence> vcodecSpinnerAdapter = ArrayAdapter.createFromResource(activity, R.array.vcodecSpinner, R.layout.spinner_layout);
        vcodecSpinnerAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        vcodecSpinner.setAdapter(vcodecSpinnerAdapter);

        // befülle resolution Spinner
        final Spinner resolutionSpinner = (Spinner) activity.findViewById(R.id.movieResolutionSpinner);
        ArrayAdapter<CharSequence> resolutionSpinnerAdapter = ArrayAdapter.createFromResource(activity, R.array.resolutionSpinner, R.layout.spinner_layout);
        resolutionSpinnerAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        resolutionSpinner.setAdapter(resolutionSpinnerAdapter);

        // befülle channelsger Spinner
        final Spinner channelsgerSpinner = (Spinner) activity.findViewById(R.id.movieChannelsgerSpinner);
        ArrayAdapter<CharSequence> channelsgerSpinnerAdapter = ArrayAdapter.createFromResource(activity, R.array.channelsSpinner, R.layout.spinner_layout);
        channelsgerSpinnerAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        channelsgerSpinner.setAdapter(channelsgerSpinnerAdapter);

        // befülle channelseng Spinner
        final Spinner channelsengSpinner = (Spinner) activity.findViewById(R.id.movieChannelsengSpinner);
        ArrayAdapter<CharSequence> channelsengSpinnerAdapter = ArrayAdapter.createFromResource(activity, R.array.channelsSpinner, R.layout.spinner_layout);
        channelsengSpinnerAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        channelsengSpinner.setAdapter(channelsengSpinnerAdapter);

        // befülle hdd Spinner
        final Spinner hddSpinner = (Spinner) activity.findViewById(R.id.movieHddSpinner);
        ArrayAdapter<CharSequence> hddSpinnerAdapter = ArrayAdapter.createFromResource(activity, R.array.hddSpinner, R.layout.spinner_layout);
        hddSpinnerAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        hddSpinner.setAdapter(hddSpinnerAdapter);

        // befülle checked Spinner
        final Spinner checkedSpinner = (Spinner) activity.findViewById(R.id.movieCheckedSpinner);
        ArrayAdapter<CharSequence> checkedSpinnerAdapter = ArrayAdapter.createFromResource(activity, R.array.checkedSpinner, R.layout.spinner_layout);
        checkedSpinnerAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        checkedSpinner.setAdapter(checkedSpinnerAdapter);

        // initialisiere YearFilter
        final TextView yearHeader = (TextView) activity.findViewById(R.id.movieYearFilterHeader);
        final RelativeLayout yearContent = (RelativeLayout) activity.findViewById(R.id.movieYearFilterContent);
        final int yearHeight = yearContent.getHeight();

        yearHeader.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                if (yearContent.getVisibility() == RelativeLayout.INVISIBLE) {
                    yearHeader.setText(R.string.yearFilterHeaderShown);
                    yearContent.getLayoutParams().height = RelativeLayout.LayoutParams.WRAP_CONTENT;
                    yearContent.setVisibility(RelativeLayout.VISIBLE);
                    yearContent.invalidate(); // für Android 5 notwendig
                    yearContent.requestLayout(); // für Android 5 notwendig
                } else {
                    yearContent.setVisibility(RelativeLayout.INVISIBLE);
                    yearHeader.setText(R.string.movieYearFilterHeaderHidden);
                    yearContent.getLayoutParams().height = 0;
                    yearContent.invalidate(); // für Android 5 notwendig
                    yearContent.requestLayout(); // für Android 5 notwendig
                }

            }
        });

    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        View fragment = inflater.inflate(R.layout.list_fragment, container, false); //wendet layout an
        final ListView movieListView =  (ListView) fragment.findViewById(android.R.id.list); //hole Referenz auf ListView

        // sonst springt listView jedes mal auf default zurück, nachdem ein Film ausgewählt wurde
        // verhindet, dass Filtereinstellungen im Drawer verloren gehen
        if (!initialized) {
            this.initializeFragment(movieListView);
            this.initialized = true;
        }
        MainActivity activity = (MainActivity) this.getActivity(); //hole MainActivity

        final EditText searchField = (EditText) activity.findViewById(R.id.movieSearchField);
        final EditText actorSearchField = (EditText) activity.findViewById(R.id.movieActorSearchField);
        final Spinner categorySpinner = (Spinner) activity.findViewById(R.id.movieCategorySpinner);
        final Spinner directionSpinner = (Spinner) activity.findViewById(R.id.movieDirectionSpinner);
        final Spinner dimensionsSpinner = (Spinner) activity.findViewById(R.id.movieDimensionsSpinner);
        final Spinner genreSpinner = (Spinner) activity.findViewById(R.id.movieGenreSpinner);
        final Spinner languageSpinner = (Spinner) activity.findViewById(R.id.movieLanguageSpinner);
        final Spinner acodecgerSpinner = (Spinner) activity.findViewById(R.id.movieAcodecgerSpinner);
        final Spinner acodecengSpinner = (Spinner) activity.findViewById(R.id.movieAcodecengSpinner);
        final Spinner vcodecSpinner = (Spinner) activity.findViewById(R.id.movieVcodecSpinner);
        final Spinner resolutionSpinner = (Spinner) activity.findViewById(R.id.movieResolutionSpinner);
        final Spinner channelsgerSpinner = (Spinner) activity.findViewById(R.id.movieChannelsgerSpinner);
        final Spinner channelsengSpinner = (Spinner) activity.findViewById(R.id.movieChannelsengSpinner);
        final Spinner hddSpinner = (Spinner) activity.findViewById(R.id.movieHddSpinner);
        final Spinner checkedSpinner = (Spinner) activity.findViewById(R.id.movieCheckedSpinner);
        final EditText yearAbsoluteField = (EditText) activity.findViewById(R.id.movieYearAbsoluteField);
        final EditText yearLowerBoundField = (EditText) activity.findViewById(R.id.movieYearLowerBoundField);
        final EditText yearUpperBoundField = (EditText) activity.findViewById(R.id.movieYearUpperBoundField);

        final MovieArrayAdapter movieArrayAdapter = new MovieArrayAdapter(getActivity(), this.movieList);
        movieListView.setAdapter(movieArrayAdapter);

        // Filter Funktionalität
        Button sortButton = (Button) activity.findViewById(R.id.movieFilterButton);
        sortButton.setOnClickListener(new Button.OnClickListener() {
            @Override
            public void onClick(View v) {

                // Schließe Tastatur nach Eingabe
                InputMethodManager imm = (InputMethodManager) getActivity().getSystemService(Context.INPUT_METHOD_SERVICE);
                imm.hideSoftInputFromWindow(v.getWindowToken(), 0);

                // MovieQueryFactory für gesamte Filterung und Sortierung
                MovieQueryFactory movieFactory = new MovieQueryFactory();

                // Suchinhalt verarbeiten
                String searchExpression = searchField.getText().toString();
                if (searchExpression.length() > 0) {
                    movieFactory.addConditions(new String[]{"Suche=" + searchExpression.replace(" ", "%20")});
                }

                // Schauspielersuche verarbeiten
                String actorSearchExpression = actorSearchField.getText().toString();
                if (actorSearchExpression.length() > 0) {
                    movieFactory.addConditions(new String[]{"Schauspieler=" + actorSearchExpression.replace(" ", "%20")});
                }

                // Prüfe Sortierung
                String category = (String) categorySpinner.getSelectedItem();
                String direction = (String) directionSpinner.getSelectedItem();
                // ersetzte direction durch richtigen Begriff
                if (direction.equals("ab")) {
                    direction = "DESC";
                } else if (direction.equals("auf")) {
                    direction = "ASC";
                }
                // ersetze Kategorie durch richtigen Spaltennamen und füge zur Factory hinzu
                if (category.equals("Name")) {
                    movieFactory.setOrder("name", direction);
                } else if (category.equals("Jahr")) {
                    movieFactory.setOrder("year", direction);
                } else if (category.equals("Laufzeit")) {
                    movieFactory.setOrder("duration", direction);
                } else if (category.equals("Rating")) {
                    movieFactory.setOrder("rating", direction);
                } else if (category.equals("Hinzugefügt")) {
                    movieFactory.setOrder("added", direction);
                } else if (category.equals("Größe")) {
                    movieFactory.setOrder("size", direction);
                } else if (category.equals("Views")) {
                    movieFactory.setOrder("views", direction);
                } else if (category.equals("Gesehen")) {
                    movieFactory.setOrder("lastView", direction);
                } else {
                    Log.d("DEBUG", "MovieListFragment: category unknown " + category);
                }

                // Prüfe 3D Spinner
                String dimensions = (String) dimensionsSpinner.getSelectedItem();

                if (dimensions.equals("3D")) {
                    movieFactory.addConditions(new String[]{"3d=1"});
                } else if (dimensions.equals("nicht 3D")) {
                    movieFactory.addConditions(new String[]{"3d=0"});
                }

                // Prüfe Genre Spinner
                String genre = (String) genreSpinner.getSelectedItem();

                if (!genre.equals("beliebig")) {
                    movieFactory.addConditions(new String[]{"Genre=" + genre});
                }

                // Prüfe Sprach Spinner
                String language = (String) languageSpinner.getSelectedItem();

                if (language.equals("Englisch")) {
                    movieFactory.addConditions(new String[]{"Englisch=1"});
                } else if (language.equals("nur Deutsch")) {
                    movieFactory.addConditions(new String[]{"Englisch=0"});
                }

                // Prüfe Acodecger Spinner
                String acodecger = (String) acodecgerSpinner.getSelectedItem();

                if (!acodecger.equals("beliebig")) {
                    movieFactory.addConditions(new String[]{"acodecger=" + acodecger});
                }

                // Prüfe Acodeceng Spinner
                String acodeceng = (String) acodecengSpinner.getSelectedItem();

                if (!acodeceng.equals("beliebig")) {
                    movieFactory.addConditions(new String[]{"acodeceng=" + acodeceng});
                }

                // Prüfe vcodec Spinner
                String vcodec = (String) vcodecSpinner.getSelectedItem();

                if (!vcodec.equals("beliebig")) {
                    movieFactory.addConditions(new String[]{"vcodec=" + vcodec});
                }

                // Prüfe resolutionSpinner
                String resolution = (String) resolutionSpinner.getSelectedItem();

                if (!resolution.equals("beliebig")) {
                    movieFactory.addConditions(new String[]{"resolution=" + resolution});
                }

                // Prüfe channelsgerSpinner
                String channelsger = (String) channelsgerSpinner.getSelectedItem();

                if (!channelsger.equals("beliebig")) {
                    movieFactory.addConditions(new String[]{"channelsger=" + channelsger});
                }

                // Prüfe channelsengSpinner
                String channelseng = (String) channelsengSpinner.getSelectedItem();

                if (!channelseng.equals("beliebig")) {
                    movieFactory.addConditions(new String[]{"channelseng=" + channelseng});
                }

                // Prüfe hddSpinner
                String hdd = (String) hddSpinner.getSelectedItem();

                if (!hdd.equals("beliebig")) {
                    movieFactory.addConditions(new String[]{"hdd=" + hdd});
                }

                // Prüfe checkedSpinner
                String checked = (String) checkedSpinner.getSelectedItem();

                if (checked.equals("fehlerfrei")) {
                    movieFactory.addConditions(new String[]{"checked=1"});
                } else if (checked.equals("fehlerhaft")) {
                    movieFactory.addConditions(new String[]{"checked=0"});
                } else if (checked.equals("nicht geprüft")) {
                    movieFactory.addConditions(new String[]{"checked=NULL"});
                }

                // Prüfe Jahresfilter
                String yearAbsolute = yearAbsoluteField.getText().toString();
                String yearLowerBound = yearLowerBoundField.getText().toString();
                String yearUpperBound = yearUpperBoundField.getText().toString();

                if (yearAbsolute.length() > 0) {
                    movieFactory.addConditions(new String[]{"Jahr=" + yearAbsolute});
                } else if (yearLowerBound.length() > 0 && yearUpperBound.length() == 0) {
                    movieFactory.addConditions(new String[]{"Jahr=>" + yearLowerBound});
                } else if (yearLowerBound.length() == 0 && yearUpperBound.length() > 0) {
                    movieFactory.addConditions(new String[]{"Jahr=<" + yearUpperBound});
                } else if (yearLowerBound.length() > 0 && yearUpperBound.length() > 0) {
                    movieFactory.addConditions(new String[]{"Jahr=" + yearLowerBound + "," + yearUpperBound});
                }

                // Aktualisiere ListView
                updateMovieListView(movieFactory, movieListView);
                ((MainActivity) getActivity()).closeMovieFilter(); // schließe Filter Drawer

            }
        });

        return fragment;
    }

    @Override
    public void onPause() {

        ((MainActivity) this.getActivity()).setMovieFilterInvisible(); // deaktiviere Filter Drawer
        super.onPause();
    }

    @Override
    public void onResume() {
        super.onResume();
        ((MainActivity) getActivity()).setMovieFilterVisible(); // aktiviere Filter Drawer
        getActivity().setTitle("Filme (" + this.movieList.size() + ")");
    }

}
