package com.example.markus.mediadbviewer;

import android.app.Activity;
import android.app.FragmentManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.view.LayoutInflater;
import android.widget.ImageView;
import android.widget.TextView;

import org.w3c.dom.Text;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class MovieArrayAdapter extends ArrayAdapter<String> {

    private String coverFolder = MainActivity.rootCoverFolder + "Filme/low/";
    private final Context context;
    private ArrayList<MediaObject> movieList = new ArrayList<MediaObject>();

    public MovieArrayAdapter(Context context, List movieList) {

        super(context, -1, movieList);
        this.movieList = (ArrayList<MediaObject>) movieList;
        this.context = context;

    }

    private void setValues(ViewHolder holder, int position) {

        // setzt imdbID für ViewHolder
        holder.imdbID = this.movieList.get(position).imdbID;
        holder.dimensions = this.movieList.get(position).dimensions;

        // Setze Texte des Views
        holder.firstLine.setText(this.movieList.get(position).name + " (" + this.movieList.get(position).year + ")");
        holder.secondLine.setText("Rating:   " + this.movieList.get(position).rating);
        holder.thirdLine.setText("Laufzeit: " + this.movieList.get(position).duration/60 + " Min");

        File cover = new File(this.coverFolder + movieList.get(position).imdbID + ".jpg");
        File fallbackCover = new File(this.coverFolder + "0000000.jpg");
        Bitmap fallbackCoverBitmap = BitmapFactory.decodeFile(fallbackCover.getAbsolutePath());

        //Bearbeite Bild des Layouts
        if (cover.exists()) {
            Bitmap coverBitmap = BitmapFactory.decodeFile(cover.getAbsolutePath());
            holder.cover.setImageBitmap(coverBitmap);
        } else if (fallbackCover.exists()) {
            holder.cover.setImageBitmap(fallbackCoverBitmap);
        } else {
            holder.cover.setImageResource(R.drawable.android);
        }

        // verstecke oder aktiviere 3D Logo
        if (this.movieList.get(position).dimensions.length() == 0) {
            holder.dimensionsLogo.setImageDrawable(null);
        } else {
            holder.dimensionsLogo.setImageResource(R.drawable.logo3d);
        }

        // setze checked Bild
        if (this.movieList.get(position).checked.equals("1")) {
            holder.checkedImage.setImageResource(R.drawable.correct);
        } else if (this.movieList.get(position).checked.equals("0")) {
            holder.checkedImage.setImageResource(R.drawable.wrong);
        } else {
            holder.checkedImage.setImageDrawable(null);
        }

        // setzte view count
        holder.viewCount.setText(String.valueOf(this.movieList.get(position).views));

    }

    // iteriert über jedes Element des String-Arrays (position) ist Array-Index
    @Override
    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder holder;


        if (convertView == null) {

            LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE); //hole den LayoutInflater
            convertView = inflater.inflate(R.layout.list_element, null);//inflate Element

            // erstelle ViewHolder, setze Klassenvariablen und füge ihn dem View hinzu
            holder = new ViewHolder();
            convertView.setTag(holder);
            holder.firstLine = (TextView) convertView.findViewById(R.id.firstLine);
            holder.secondLine = (TextView) convertView.findViewById(R.id.secondLine);
            holder.thirdLine = (TextView) convertView.findViewById(R.id.thirdLine);
            holder.cover = (ImageView) convertView.findViewById(R.id.cover);
            holder.dimensionsLogo = (ImageView) convertView.findViewById(R.id.movie3dLogo);
            holder.checkedImage = (ImageView) convertView.findViewById(R.id.checkedImage);
            holder.viewCount = (TextView) convertView.findViewById(R.id.viewCount);

            // führe Funktion zum Anpassen des Views aus
            setValues(holder, position);

            // setze onClickListener ... ändert sich nie, deshalb nur beim Initialisieren
            convertView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {

                    ViewHolder holder = (ViewHolder) v.getTag();
                    FragmentManager fragmentManager = ((Activity) context).getFragmentManager();
                    MovieDetailedFragment movieDetailedFragment = new MovieDetailedFragment();
                    movieDetailedFragment.setImdbID(holder.imdbID);
                    if (holder.dimensions.length() == 0) {
                        movieDetailedFragment.setDimensions(0);
                    } else {
                        movieDetailedFragment.setDimensions(1);
                    }
                    fragmentManager.beginTransaction().replace(R.id.mainContent, movieDetailedFragment).addToBackStack("movieDetailsFragment").commit();

                }
            });


        } else {

            holder = (ViewHolder) convertView.getTag();

            setValues(holder, position);

        }

        return convertView;
    }

    private class ViewHolder {

        public TextView firstLine;
        public TextView secondLine;
        public TextView thirdLine;
        public ImageView cover;
        public ImageView dimensionsLogo;
        public ImageView checkedImage;
        public TextView viewCount;
        public String imdbID; // wird gebraucht, damit bei onClick event die imdbID ausgelesen werden kann
        public String dimensions; // wird gebraucht, damit bei onClick event die imdbID ausgelesen werden kann

    }

}
