package com.example.markus.mediadbviewer;

import android.app.Activity;
import android.app.FragmentManager;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.view.LayoutInflater;
import android.widget.ImageView;
import android.widget.TextView;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class SeriesArrayAdapter extends ArrayAdapter<String> {

    private final Context context;
    private ArrayList<MediaObject> seriesList = new ArrayList<MediaObject>();
    private String coverFolder = MainActivity.rootCoverFolder + "Serien/low/";

    public SeriesArrayAdapter (Context context, List seriesList) {

        super(context, -1, seriesList);
        this.seriesList = (ArrayList<MediaObject>) seriesList;
        this.context = context;

    }

    private void setValues(ViewHolder holder, int position) {

        // setzt imdbID für ViewHolder
        holder.series_nr = this.seriesList.get(position).series_nr;

        // Setze Texte des Views
        holder.firstLine.setText(this.seriesList.get(position).name);
        holder.secondLine.setText("Größe:    " + String.valueOf(Math.round(this.seriesList.get(position).Size/Math.pow(1024,3)*100)/100.) + " GB");
        holder.thirdLine.setText("Laufzeit: " + String.valueOf(this.seriesList.get(position).Duration/60) + " Min");

        if (new File(this.coverFolder + this.seriesList.get(position).series_nr + ".jpg").exists()) {
            holder.cover.setImageDrawable(Drawable.createFromPath(this.coverFolder + this.seriesList.get(position).series_nr + ".jpg"));
        } else {
            holder.cover.setImageResource(R.drawable.android);
            Log.d("INFO", this.coverFolder + this.seriesList.get(position).series_nr + ".jpg" + " does not exist");
        }

        // setze checked Bild
        if (this.seriesList.get(position).Checked.equals("1.0000")) {
            holder.checkedImage.setImageResource(R.drawable.correct); // alles ganz
        } else if (this.seriesList.get(position).Checked.equals("0.0000")) {
            holder.checkedImage.setImageResource(R.drawable.wrong); // alles defekt
        } else if (this.seriesList.get(position).Checked.length() == 0) {
            holder.checkedImage.setImageDrawable(null); // noch nicht geprüft
        } else {
            holder.checkedImage.setImageResource(R.drawable.yellowdot); // teilweise defekt
        }

        // setzte view count
        holder.viewCount.setText(String.valueOf(Math.round(this.seriesList.get(position).Views*100)/100.));

    }

    // iteriert über jedes Element des String-Arrays (position) ist Array-Index
    @Override
    public View getView(final int position, View convertView, ViewGroup parent) {

        ViewHolder holder;

        if (convertView == null) {

            LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE); //hole den LayoutInflater
            convertView = inflater.inflate(R.layout.list_element, null);//inflate Element

            // erstelle ViewHolder, setze Klassenvariablen und füge ihn dem View hinzu
            holder = new ViewHolder();
            convertView.setTag(holder);
            holder.firstLine = (TextView) convertView.findViewById(R.id.firstLine);
            holder.secondLine = (TextView) convertView.findViewById(R.id.secondLine);
            holder.thirdLine = (TextView) convertView.findViewById(R.id.thirdLine);
            holder.viewCount = (TextView) convertView.findViewById(R.id.viewCount);
            holder.cover = (ImageView) convertView.findViewById(R.id.cover);
            holder.checkedImage = (ImageView) convertView.findViewById(R.id.checkedImage);

            // führe Funktion zum Anpassen des Views aus
            setValues(holder, position);

            // setze onClickListener ... ändert sich nie, deshalb nur beim Initialisieren
            convertView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {

                    ViewHolder holder = (ViewHolder) v.getTag();
                    FragmentManager fragmentManager = ((Activity) context).getFragmentManager();
                    SeasonListFragment seasonListFragment = new SeasonListFragment();
                    seasonListFragment.setSeries_nr(holder.series_nr);
                    fragmentManager.beginTransaction().replace(R.id.mainContent, seasonListFragment).addToBackStack("seasonFragment").commit();

                }
            });


        } else {

            holder = (ViewHolder) convertView.getTag();

            setValues(holder, position);

        }

        return convertView;
    }

    private class ViewHolder {

        public TextView firstLine;
        public TextView secondLine;
        public TextView thirdLine;
        public TextView viewCount;
        public ImageView checkedImage;
        public ImageView cover;
        public int series_nr;

    }

}
