package com.example.markus.mediadbviewer;

import android.util.Log;

import java.util.Arrays;

public class MovieQueryFactory {

    private String url=""; // finale URL
    private String rootURL = "http://mediadb.ivaya.de/api.php"; // später aus Einstellungen
    private String apiKey = "0123456789"; // später aus Einstellungen

    private String[] validColumns = new String[]{"imdbID", "name", "year", "size", "md5", "3d", "vcodec", "duration", "totalbitrate", "resolution",
            "width", "height", "acodecger", "abitrateger", "channelsger", "acodeceng", "abitrateeng", "channelseng", "hdd", "rating",
            "checked", "views", "comment", "added", "lastView", "Genre", "Schauspieler"};
    private String[] validConditions = new String[]{"Anzahl", "imdbID", "Suche", "3d", "Genre", "Schauspieler"};
    private String[] validGenres = new String[]{"Action", "Adventure", "Animation", "Biography", "Comedy", "Crime", "Documentary", "Drama", "Family",
            "Fantasy", "History", "Horror", "Music", "Musical", "Mystery", "Romance", "Sci-Fi", "Short", "Sport", "Thriller", "War", "Western"};
    private String[] validDirections = new String[]{"ASC", "DESC", "asc", "desc", "Asc", "Desc"};

    private String columns = "";
    private String conditions = "";
    private String order = "";

    public MovieQueryFactory() {

        this.url += this.rootURL;
        this.url += "?key=";
        this.url += this.apiKey;
        this.url += "&action=GetDataList";
        this.url += "&Tabelle=Filme";

    }

    // prüft Spalten und füge sie hinzu
    public void addColumns(String[] columns) {

        for (String column : columns) {
            if (Arrays.asList(this.validColumns).contains(column)) {
                if (this.columns.length() == 0) {
                    this.columns += column;
                } else {
                    this.columns += ",";
                    this.columns += column;
                }
            } else {
                Log.d("DEBUG", "MovieQueryFactory: unknown column " + column);
            }
        }

    }

    // füge Bedingungen zu Abfrage hinzu
    // werden wie folgt angegeben: imdbID=1234567
    public void addConditions(String[] conditions) {


        for (String condition : conditions) {
            /*
            if (Arrays.asList(this.validConditions).contains(condition.split("=")[0])) {
                if (condition.split("=").length == 2) {
                    if (condition.split("=")[0]=="3d") {
                        if ((Integer.valueOf(condition.split("=")[1]) != 1) && (Integer.valueOf(condition.split("=")[1]) != 1)) {
                            Log.d("DEBUG", "MovieQueryFactory: wrong value " + condition.split("=")[1] + "for 3d filter");
                        } else {
                            this.conditions += "&" + condition;
                        }
                    } else {
                        this.conditions += "&" + condition;
                    }
                } else {
                    Log.d("DEBUG", "MovieQueryFactory: no value assigned to condition " + condition);
                }
            } else {
                Log.d("DEBUG", "MovieQueryFactory: unknown condition " + condition);
            }
            */
            this.conditions += "&" + condition;
        }

    }

    // füge Sortierung zur Abfrage hinzu
    public void setOrder(String column, String direction) {

        if (this.order.length() == 0) {
            if (Arrays.asList(this.validColumns).contains(column)) {
                if (Arrays.asList(this.validDirections).contains(direction)) {
                    this.order += "&Sortierung=" + column + "%20" + direction;
                } else {
                    Log.d("DEBUG", "MovieQueryFactory: invalid direction '" + direction + "'for ordering ");
                }
            } else {
                Log.d("DEBUG", "MovieQueryFactory: invalid column " + column + " for ordering");
            }
        } else {
            Log.d("DEBUG", "MovieQueryFactory: order clause already set - ignoring " + column + " " + direction);
        }
    }

    // erstelle URL
    public String getUrl () {

        // füge Spalten zur URL hinzu
        if (this.columns.length() != 0) {
            this.url += "&Spalten=";
            this.url += this.columns;
        }

        // füge Bedingungen zur URL hinzu
        if (this.conditions.length() != 0) {
            this.url += this.conditions;
        }

        // füge Sortierung zur URL hinzu
        if (this.order.length() != 0) {
            this.url += this.order;
        }

        Log.d("INFO", "MovieQueryFactory: build URL " + url);

        return this.url;

    }


}
