package com.example.markus.mediadbviewer;

import android.app.ListFragment;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.RelativeLayout;

import java.io.File;
import java.util.ArrayList;

public class EpisodeListFragment extends ListFragment {

    private String coverFolder = MainActivity.rootCoverFolder + "Staffeln/high/";
    private ArrayList<MediaObject> episodeList = new ArrayList<MediaObject>();
    private int season_nr;

    public void setSeason_nr(int season_nr) {
        this.season_nr = season_nr;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        View fragment = inflater.inflate(R.layout.episode_list_fragment, container, false); //wendet layout an
        final ListView episodeListView = (ListView) fragment.findViewById(android.R.id.list); //hole Referenz auf ListView

        // setze Cover vor ListView
        ImageView cover = (ImageView) fragment.findViewById(R.id.seasonCover);
        if (new File(this.coverFolder + this.season_nr + ".jpg").exists()) {
            cover.setImageDrawable(Drawable.createFromPath(this.coverFolder + this.season_nr + ".jpg"));
        } else {
            cover.setImageResource(R.drawable.android);
        }

        // hole Daten für episodeListView
        SeriesQueryFactory episodeQueryFactory = new SeriesQueryFactory("Episoden");
        updateEpisodeListView(episodeQueryFactory, episodeListView);

        return fragment;

    }

    private void updateEpisodeListView (SeriesQueryFactory episodeQueryFactory, ListView listView) {

        // notwendige Spalten für ListView können zentral hier geändert werden
        episodeQueryFactory.addColumns(new String[]{"episodenumber", "name", "series_nr", "season_nr", "checked"});
        episodeQueryFactory.addConditions(new String[]{"season_nr=" + this.season_nr});
        JSONParser parser = new JSONParser();
        try {
            parser.execute(new String[]{episodeQueryFactory.getUrl()}).get();
        } catch (Exception e) {

        }
        this.episodeList = parser.getMediaList();

        // setzen des ArrayAdapters
        EpisodeArrayAdapter episodeArrayAdapter = new EpisodeArrayAdapter(getActivity(), this.episodeList);
        listView.setAdapter(episodeArrayAdapter);

    }

    @Override
    public void onResume() {
        super.onResume();
        getActivity().setTitle("Episoden (" + this.episodeList.size() + ")");
    }
}
