package com.example.markus.mediadbviewer;

import android.app.Fragment;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import java.lang.Math;

import java.io.File;


public class MovieDetailedFragment extends Fragment {

    private String coverFolder = MainActivity.rootCoverFolder + "Filme/high/";
    private String imdbID;
    private String title;
    private int dimensions;

    public void setImdbID(String imdbID) {

        this.imdbID = imdbID;

    }

    public void setDimensions(int dimensions) {

        this.dimensions = dimensions;

    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        View fragment = inflater.inflate(R.layout.detailed_fragment, container, false); //wendet layout an

        // diese Werte werden in dieser Reihenfolge in die Tabelle eingetragen
        String[] values = new String[]{"name", "imdbID", "3d", "year", "size", "duration", "width", "height", "vcodec", "totalbitrate",
                "resolution", "acodecger", "abitrateger", "channelsger", "acodeceng", "abitrateeng", "channelseng", "hdd", "rating", "checked",
                "views", "comment", "added", "lastView", "Genre", "Schauspieler", "md5"};

        // erstelle Link mit MovieQuerryFactory
        MovieQueryFactory movieQueryFactory = new MovieQueryFactory();
        movieQueryFactory.addColumns(values);
        movieQueryFactory.addConditions(new String[]{"imdbID=" + this.imdbID, "3d=" + String.valueOf(this.dimensions)});

        // hole Informationen
        JSONParser parser = new JSONParser();
        try {
            parser.execute(new String[]{movieQueryFactory.getUrl()}).get();
        } catch (Exception e) {

        }
        MediaObject movie = parser.getMediaList().get(0);

        // setze Titel
        this.title = movie.name;

        // tausche Default Cover aus

        ImageView cover = (ImageView) fragment.findViewById(R.id.detailedCover);

        if (new File(this.coverFolder + this.imdbID + ".jpg").exists()) {
            cover.setImageDrawable(Drawable.createFromPath(this.coverFolder + this.imdbID + ".jpg"));
        } else if (new File(this.coverFolder + "0000000.jpg").exists()) {
            cover.setImageDrawable(Drawable.createFromPath(this.coverFolder + "0000000.jpg"));
        } else {
            cover.setImageResource(R.drawable.android);
        }

        // erstelle Tabelle / Titel
        TableLayout table = (TableLayout) fragment.findViewById(R.id.movieTable); // hole Tabellenreferenz
        TableRow row;
        TextView firstColumn;
        TextView secondColumn;

        for (String value : values) {

            if (value.equals("name")) {
                TextView titel = (TextView) fragment.findViewById(R.id.movieTitleDetailed);
                titel.setText(movie.name);
            } else if (value.equals("3d")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("3D");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(movie.dimensions);
                table.addView(row);
            } else if (value.equals("imdbID")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("imdbID");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(movie.imdbID);
                table.addView(row);
            } else if (value.equals("year")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Jahr");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(String.valueOf(movie.year));
                table.addView(row);
            } else if (value.equals("size")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Größe");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(String.valueOf(Math.round(movie.size*100/ Math.pow(1024, 3))/100.) + " GB");
                table.addView(row);
            } else if (value.equals("duration")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Laufzeit");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(String.valueOf(movie.duration/60) + " Minuten");
                table.addView(row);
            } else if (value.equals("width")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Bildbreite");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(String.valueOf(movie.width) + " Pixel");
                table.addView(row);
            } else if (value.equals("height")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Bildhöhe");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(String.valueOf(movie.height) + " Pixel");
                table.addView(row);
            } else if (value.equals("md5")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("MD5");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(movie.md5);
                table.addView(row);
            } else if (value.equals("vcodec")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Video Container");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(movie.vcodec);
                table.addView(row);
            } else if (value.equals("totalbitrate")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Gesambitrate");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(String.valueOf(movie.totalbitrate) + " kBit/s");
                table.addView(row);
            } else if (value.equals("resolution")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Auflösung");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(movie.resolution);
                table.addView(row);
            } else if (value.equals("acodecger")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Deutscher Audiocodec");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(movie.acodecger);
                table.addView(row);
            } else if (value.equals("abitrateger")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Deutsche Audiobitrate");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(String.valueOf(movie.abitrateger) + " kBit/s");
                table.addView(row);
            } else if (value.equals("channelsger")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Deutsche Audiokanäle");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(String.valueOf(movie.channelsger));
                table.addView(row);
            } else if (value.equals("acodeceng")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Englischer Audiocodec");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(movie.acodeceng);
                table.addView(row);
            } else if (value.equals("abitrateeng")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Englische Audiobitrate");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                if (movie.abitrateeng == 0) {
                    secondColumn.setText("");
                } else {
                    secondColumn.setText(String.valueOf(movie.abitrateeng) + " kBit/s");
                }
                table.addView(row);
            } else if (value.equals("channelseng")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Englische Audiokanäle");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                if (movie.channelseng == 0) {
                    secondColumn.setText("");
                } else {
                    secondColumn.setText(String.valueOf(movie.channelseng));
                }
                table.addView(row);
            } else if (value.equals("hdd")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Festplatte");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(String.valueOf(movie.hdd));
                table.addView(row);
            } else if (value.equals("rating")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Rating");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(String.valueOf(movie.rating) + " / 10");
                table.addView(row);
            } else if (value.equals("checked")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Geprüft");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                if (movie.checked.length() == 0) {
                    secondColumn.setText("nicht geprüft");
                } else if (movie.checked.equals("0")) {
                    secondColumn.setText("fehlerhaft");
                    //secondColumn.setTextColor(ContextCompat.getColor(getActivity(), R.color.red));
                    secondColumn.setTextColor(getResources().getColor(R.color.red));
                } else if (movie.checked.equals("1")) {
                    secondColumn.setText("fehlerfrei");
                    //secondColumn.setTextColor(ContextCompat.getColor(getActivity(), R.color.green));
                    secondColumn.setTextColor(getResources().getColor(R.color.green));
                }
                table.addView(row);
            } else if (value.equals("views")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Anzahl gesehen");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(String.valueOf(movie.views));
                table.addView(row);
            } else if (value.equals("comment")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Kommentar");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(movie.comment);
                table.addView(row);
            } else if (value.equals("added")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Hinzugefügt");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(movie.added);
                table.addView(row);
            } else if (value.equals("lastView")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Gesehen");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(movie.lastView);
                table.addView(row);
            } else if (value.equals("Genre")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Genre");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                String text = "";
                boolean firstLoop = true;
                for (String genre : movie.Genre) {
                    if (!firstLoop) {
                        text += "\r\n";
                    }
                    text += genre;
                    firstLoop = false;
                }
                secondColumn.setText(text);
                table.addView(row);
            } else if (value.equals("Schauspieler")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Schauspieler");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                String text = "";
                boolean firstLoop = true;
                for (String schauspieler : movie.schauspieler) {
                    if (!firstLoop) {
                        text += "\r\n";
                    }
                    text += schauspieler;
                    firstLoop = false;
                }
                secondColumn.setText(text);
                table.addView(row);
            } else {

                Log.d("Kontrolle", value);

            }

        }

        return fragment;
    }

    @Override
    public void onResume() {
        super.onResume();
        getActivity().setTitle(this.title);
    }

}
