package com.example.markus.mediadbviewer;

import android.app.Fragment;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewManager;
import android.widget.ImageView;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import java.lang.Math;

import java.io.File;


public class EpisodeDetailedFragment extends Fragment {

    private int episodenumber;
    private int season_nr;
    private String title;

    public void setEpisodenumber (int episodenumber) {

        this.episodenumber = episodenumber;

    }

    public void setSeason_nr (int season_nr) {

        this.season_nr = season_nr;

    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        View fragment = inflater.inflate(R.layout.detailed_fragment, container, false); //wendet layout an

        // beschreiben aus welcher Tabelle welche Werte geholt werden müssen
        String[] valuesEpisode = new String[]{"episodenumber", "name", "size", "duration", "width", "height", "vcodec", "totalbitrate",
                "resolution", "acodecger", "abitrateger", "channelsger", "acodeceng", "abitrateeng", "channelseng", "hdd", "checked", "comment", "added", "md5", "views", "lsatView"};
        String[] valuesSeason = new String[]{"comment", "resolution", "sound", "source"};
        // diese Werte werden in dieser Reihenfolge in die Tabelle eingetragen (müssen alle in den vorherigen Arrays existieren!!!)
        // wenn comment bei valuesShown angegeben wird, muss es sowohl in valuesEpisode, als auch in valuesSeason angegeben werden!
        String[] valuesShown = new String[]{"name", "episodenumber", "source", "size", "duration", "width", "height", "vcodec", "totalbitrate",
                "resolution", "acodecger", "abitrateger", "channelsger", "acodeceng", "abitrateeng", "channelseng", "hdd", "checked", "views", "added", "lastView", "md5",
                "comment"};



        // hole Informationen aus Episoden-Tabelle
        SeriesQueryFactory episodeQueryFactory = new SeriesQueryFactory("Episoden");
        episodeQueryFactory.addColumns(valuesEpisode);
        episodeQueryFactory.addConditions(new String[]{"season_nr=" + this.season_nr, "episodenumber=" + this.episodenumber});
        JSONParser parser = new JSONParser();
        try {
            parser.execute(new String[]{episodeQueryFactory.getUrl()}).get();
        } catch (Exception e) {

        }
        MediaObject episode = parser.getMediaList().get(0);

        // hole Informationen aus Staffel-Tabelle
        SeriesQueryFactory seasonQueryFactory = new SeriesQueryFactory("Staffeln");
        seasonQueryFactory.addColumns(valuesSeason);
        seasonQueryFactory.addConditions(new String[]{"season_nr=" + this.season_nr});
        parser = new JSONParser();
        try {
            parser.execute(new String[]{seasonQueryFactory.getUrl()}).get();
        } catch (Exception e) {

        }
        MediaObject season = parser.getMediaList().get(0);

        // setze globale Titel-Variable
        this.title = episode.name;

        // entferne Cover vom Layout
        ImageView cover = (ImageView) fragment.findViewById(R.id.detailedCover);
        ((ViewManager) cover.getParent()).removeView(cover);

        // erstelle Tabelle / Titel
        TableLayout table = (TableLayout) fragment.findViewById(R.id.movieTable); // hole Tabellenreferenz
        TableRow row;
        TextView firstColumn;
        TextView secondColumn;

        for (String value : valuesShown) {

            if (value.equals("name")) {
                TextView titel = (TextView) fragment.findViewById(R.id.movieTitleDetailed);
                titel.setText(episode.name);
            } else if (value.equals("episodenumber")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Folge");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(String.valueOf(episode.episodenumber));
                table.addView(row);
            } else if (value.equals("source")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Quelle");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(season.source);
                table.addView(row);
            } else if (value.equals("sound")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Sound");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(season.sound);
                table.addView(row);
            } else if (value.equals("size")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Größe");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(String.valueOf(Math.round(episode.size*100/ Math.pow(1024, 3))/100.) + " GB");
                table.addView(row);
            } else if (value.equals("duration")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Laufzeit");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(String.valueOf(episode.duration/60) + " Minuten");
                table.addView(row);
            } else if (value.equals("width")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Bildbreite");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(String.valueOf(episode.width) + " Pixel");
                table.addView(row);
            } else if (value.equals("height")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Bildhöhe");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(String.valueOf(episode.height) + " Pixel");
                table.addView(row);
            } else if (value.equals("md5")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("MD5");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(episode.md5);
                table.addView(row);
            } else if (value.equals("vcodec")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Video Container");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(episode.vcodec);
                table.addView(row);
            } else if (value.equals("totalbitrate")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Gesambitrate");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(String.valueOf(episode.totalbitrate) + " kBit/s");
                table.addView(row);
            } else if (value.equals("resolution")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Auflösung");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(season.resolution);
                table.addView(row);
            } else if (value.equals("acodecger")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Deutscher Audiocodec");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(episode.acodecger);
                table.addView(row);
            } else if (value.equals("abitrateger")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Deutsche Audiobitrate");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(String.valueOf(episode.abitrateger) + " kBit/s");
                table.addView(row);
            } else if (value.equals("channelsger")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Deutsche Audiokanäle");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(String.valueOf(episode.channelsger));
                table.addView(row);
            } else if (value.equals("acodeceng")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Englischer Audiocodec");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(episode.acodeceng);
                table.addView(row);
            } else if (value.equals("abitrateeng")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Englische Audiobitrate");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                if (episode.abitrateeng == 0) {
                    secondColumn.setText("");
                } else {
                    secondColumn.setText(String.valueOf(episode.abitrateeng) + " kBit/s");
                }
                table.addView(row);
            } else if (value.equals("channelseng")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Englische Audiokanäle");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                if (episode.channelseng == 0) {
                    secondColumn.setText("");
                } else {
                    secondColumn.setText(String.valueOf(episode.channelseng));
                }
                table.addView(row);
            } else if (value.equals("hdd")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Festplatte");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(String.valueOf(episode.hdd));
                table.addView(row);
            } else if (value.equals("checked")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Geprüft");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                if (episode.checked.length() == 0) {
                    secondColumn.setText("nicht geprüft");
                } else if (episode.checked.equals("0")) {
                    secondColumn.setText("fehlerhaft");
                    //secondColumn.setTextColor(ContextCompat.getColor(getActivity(), R.color.red));
                    secondColumn.setTextColor(getResources().getColor(R.color.red));
                } else if (episode.checked.equals("1")) {
                    secondColumn.setText("fehlerfrei");
                    //secondColumn.setTextColor(ContextCompat.getColor(getActivity(), R.color.green));
                    secondColumn.setTextColor(getResources().getColor(R.color.green));
                }
                table.addView(row);
            } else if (value.equals("views")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Anzahl gesehen");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(String.valueOf(season.views));
                table.addView(row);
            } else if (value.equals("comment")) {
                // erstelle Kommentar für Episode
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Kommentar Episode");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(episode.comment);
                table.addView(row);
                // erstelle Kommentar für Staffel
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Kommentar Staffel");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(season.comment);
                table.addView(row);
            } else if (value.equals("added")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Hinzugefügt");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(episode.added);
                table.addView(row);
            } else if (value.equals("lastView")) {
                row = (TableRow) LayoutInflater.from(fragment.getContext()).inflate(R.layout.table_row_text, null); // erstelle neue Zeile
                firstColumn = (TextView) row.findViewById(R.id.firstColumnDetailed);
                firstColumn.setText("Gesehen");
                secondColumn = (TextView) row.findViewById(R.id.secondColumnDetailed);
                secondColumn.setText(season.lastView);
                table.addView(row);
            } else {

                Log.d("DEBUG", "EpisodeDetailedFragment: ignoring unknown value " + value);

            }

        }

        return fragment;
    }

    @Override
    public void onResume() {
        super.onResume();
        getActivity().setTitle(this.title);
    }

}
