package com.example.markus.mediadbviewer;

import android.app.ProgressDialog;
import android.os.AsyncTask;
import android.util.Log;
import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.FileOutputStream;
import java.util.Arrays;

class CoverDownloader extends AsyncTask<String, String, String> {

    private String coverType = "";
    private String quality = "";
    private String[] validCoverTypes = new String[]{"Filme", "Serien", "Staffeln"};
    private String[] validQualities = new String[]{"high", "low"};
    private String rootDomain = "http://mediadb.ddns.net/cover/"; // später über Einstellungen

    public CoverDownloader(String coverType, String quality) {

        if (Arrays.asList(validCoverTypes).contains(coverType)) {
            this.coverType = coverType;
        } else {
            Log.d("DEBUG","CoverDownloader: invalid cover type " + coverType);
        }

        if (Arrays.asList(validQualities).contains(quality)) {
            this.quality = quality;
        } else {
            Log.d("DEBUG","CoverDownloader: invalid quality " + quality);
        }

    }

    public void setCoverType(String coverType) {

        if (Arrays.asList(validCoverTypes).contains(coverType)) {
            this.coverType = coverType;
        } else {
            Log.d("DEBUG","CoverDownloader: invalid cover type " + coverType);
        }

    }

    public void setQuality (String quality) {

        if (Arrays.asList(validQualities).contains(quality)) {
            this.quality = quality;
        } else {
            Log.d("DEBUG","CoverDownloader: invalid quality " + quality);
        }

    }


    @Override
    protected void onPreExecute() {
        super.onPreExecute();
        //showDialog();
    }


    @Override
    protected String doInBackground(String[] keys) {

        String downloadFolder;
        String downloadUrl;

        // erstelle URL und Downloadpfad
        if (this.coverType.equals("Filme") && keys[0].length() == 7) {
            if (this.quality.equals("low")) {
                downloadFolder = MainActivity.rootCoverFolder + this.coverType + "/" + this.quality + "/";
                downloadUrl = rootDomain + this.coverType + "/" + this.quality + "/";
            } else if (this.quality.equals("high")) {
                downloadFolder = MainActivity.rootCoverFolder + this.coverType + "/" + this.quality + "/";
                downloadUrl = rootDomain + this.coverType + "/" + this.quality + "/";
            } else {
                Log.d("DEBUG", "CoverDownloader: invalid quality " + this.quality + " for cover type " + this.coverType);
                return null;
            }
        } else if (this.coverType.equals("Serien")) {
            if (this.quality.equals("low")) {
                downloadFolder = MainActivity.rootCoverFolder + this.coverType + "/" + this.quality + "/";
                downloadUrl = rootDomain + this.coverType + "/" + this.quality + "/";
            } else {
                Log.d("DEBUG", "CoverDownloader: invalid quality " + this.quality + " for cover type " + this.coverType);
                return null;
            }
        } else if (this.coverType.equals("Staffeln")) {
            if (this.quality.equals("low")) {
                downloadFolder = MainActivity.rootCoverFolder + this.coverType + "/" + this.quality + "/";
                downloadUrl = rootDomain + this.coverType + "/" + this.quality + "/";
            } else if (this.quality.equals("high")) {
                downloadFolder = MainActivity.rootCoverFolder + this.coverType + "/" + this.quality + "/";
                downloadUrl = rootDomain + this.coverType + "/" + this.quality + "/";
            } else {
                Log.d("DEBUG", "CoverDownloader: invalid quality " + this.quality + " for cover type " + this.coverType);
                return null;
            }
        } else {
            Log.d("DEBUG", "CoverDownloader: could not download for " + this.quality + " with key " + keys[0]);
            return null;
        }

        File downloadFolderFile = new File(downloadFolder);
        // erstelle downloadFolder
        if (!downloadFolderFile.exists()) {
            downloadFolderFile.mkdirs();
        }

        // lösche alle Dateien im Ordner
        File[] files = downloadFolderFile.listFiles();
        if (files != null) {
            for(File f: files) {
                f.delete();
            }
        }

        // downloade alle cover

        int count;

        for (String key : keys) {

            try {
                URL url = new URL(downloadUrl + key + ".jpg");
                URLConnection connection = url.openConnection();
                connection.connect();

                // getting file length
                int lenghtOfFile = connection.getContentLength();

                // input stream to read file - with 8k buffer
                InputStream input = new BufferedInputStream(url.openStream(), 8192);

                // Output stream to write file
                OutputStream output = new FileOutputStream(downloadFolder + key + ".jpg");

                byte data[] = new byte[1024];

                long total = 0;

                while ((count = input.read(data)) != -1) {
                    total += count;
                    // publishing the progress....
                    // After this onProgressUpdate will be called
                    // writing data to file
                    output.write(data, 0, count);
                }

                // flushing output
                output.flush();

                // closing streams
                output.close();
                input.close();

            } catch (Exception e) {
                Log.d("FehlerDownload",e.getMessage());
            }

            // ruft onProgressUpdate() auf
            //publishProgress(String.valueOf((int) ((((float) filesProcessed)/totalFiles)*100.)));
            MainActivity.progressDialog.setProgress(MainActivity.progressDialog.getProgress() + 1);
        }

        return null;
    }

    @Override
    protected void onPostExecute(String link_url) {
        if (MainActivity.progressDialog.getProgress() / MainActivity.progressDialog.getMax() > 0.99) {
            MainActivity.progressDialog.dismiss();
        }
    }

}
