package com.example.markus.mediadbviewer;

import android.app.ListFragment;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListView;

import java.util.ArrayList;

public class SeriesListFragment extends ListFragment {

    private ArrayList<MediaObject> seriesList = new ArrayList<MediaObject>();

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        View fragment = inflater.inflate(R.layout.list_fragment, container, false); //wendet layout an
        final ListView seriesListView = (ListView) fragment.findViewById(android.R.id.list); //hole Referenz auf ListView

        // hole Daten für seriesListView
        SeriesQueryFactory seriesQueryFactory = new SeriesQueryFactory("Serien");
        updateSeriesListView(seriesQueryFactory, seriesListView);


        return fragment;

    }

    private void updateSeriesListView (SeriesQueryFactory seriesQueryFactory, ListView listView) {

        // notwendige Spalten für ListView können zentral hier geändert werden
        seriesQueryFactory.addColumns(new String[]{"name", "finished", "series_nr", "Statistik"});
        seriesQueryFactory.setOrder("name", "ASC");
        JSONParser parser = new JSONParser();
        try {
            parser.execute(new String[]{seriesQueryFactory.getUrl()}).get();
        } catch (Exception e) {

        }
        this.seriesList = parser.getMediaList();

        // setzen des ArrayAdapters
        SeriesArrayAdapter seriesArrayAdapter = new SeriesArrayAdapter(getActivity(), this.seriesList);
        listView.setAdapter(seriesArrayAdapter);

    }

    @Override
    public void onResume() {
        super.onResume();
        getActivity().setTitle("Serien (" + this.seriesList.size() + ")");
    }




}
