package com.example.markus.mediadbviewer;

import android.app.ListFragment;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListView;

import java.util.ArrayList;

public class SeasonListFragment extends ListFragment {

    private ArrayList<MediaObject> seasonList = new ArrayList<MediaObject>();
    private int series_nr;

    public void setSeries_nr(int series_nr) {
        this.series_nr = series_nr;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        View fragment = inflater.inflate(R.layout.list_fragment, container, false); //wendet layout an
        final ListView seasonListView = (ListView) fragment.findViewById(android.R.id.list); //hole Referenz auf ListView

        // hole Daten für seasonListView
        SeriesQueryFactory seasonQueryFactory = new SeriesQueryFactory("Staffeln");
        updateSeasonListView(seasonQueryFactory, seasonListView);


        return fragment;

    }

    private void updateSeasonListView (SeriesQueryFactory seasonQueryFactory, ListView listView) {

        // notwendige Spalten für ListView können zentral hier geändert werden
        seasonQueryFactory.addColumns(new String[]{"season", "resolution", "sound", "source", "season_nr", "series_nr", "checked", "Statistik"});
        seasonQueryFactory.addConditions(new String[]{"series_nr=" + this.series_nr});
        seasonQueryFactory.setOrder("season", "ASC");
        JSONParser parser = new JSONParser();
        try {
            parser.execute(new String[]{seasonQueryFactory.getUrl()}).get();
        } catch (Exception e) {

        }
        this.seasonList = parser.getMediaList();

        // setzen des ArrayAdapters
        SeasonArrayAdapter seasonArrayAdapter = new SeasonArrayAdapter(getActivity(), this.seasonList);
        listView.setAdapter(seasonArrayAdapter);

    }

    @Override
    public void onResume() {
        super.onResume();
        getActivity().setTitle("Staffeln (" + this.seasonList.size() + ")");
    }

}
