package com.example.markus.mediadbviewer;

import android.app.Activity;
import android.app.FragmentManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.view.LayoutInflater;
import android.widget.ImageView;
import android.widget.PopupMenu;
import android.widget.TextView;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class SeasonArrayAdapter extends ArrayAdapter<String> {

    private final Context context;
    private ArrayList<MediaObject> seasonList = new ArrayList<MediaObject>();
    private String coverFolderSeasons = MainActivity.rootCoverFolder + "Staffeln/low/";
    private String coverFolderSeries = MainActivity.rootCoverFolder + "Serien/low/";

    public SeasonArrayAdapter (Context context, List seasonList) {

        super(context, -1, seasonList);
        this.seasonList = (ArrayList<MediaObject>) seasonList;
        this.context = context;

    }

    private void setValues(ViewHolder holder, int position) {

        // setzt season_nr für ViewHolder
        holder.season_nr = this.seasonList.get(position).season_nr;

        // Setze Texte des Views
        holder.firstLine.setText("Staffel " + this.seasonList.get(position).season + " (" + this.seasonList.get(position).resolution + ") (" + this.seasonList.get(position).sound + ") (" + this.seasonList.get(position).source + ")");
        holder.secondLine.setText("Größe:    " + String.valueOf(Math.round(this.seasonList.get(position).Size/Math.pow(1024,3)*100)/100.) + " GB");
        holder.thirdLine.setText("Laufzeit: " + String.valueOf(this.seasonList.get(position).Duration/60) + " Min");

        if (new File(this.coverFolderSeasons + this.seasonList.get(position).season_nr + ".jpg").exists()) {
            holder.cover.setImageDrawable(Drawable.createFromPath(this.coverFolderSeasons + this.seasonList.get(position).season_nr + ".jpg"));
        } else if (new File(this.coverFolderSeries + this.seasonList.get(position).series_nr + ".jpg").exists()) {
            holder.cover.setImageDrawable(Drawable.createFromPath(this.coverFolderSeries + this.seasonList.get(position).series_nr + ".jpg"));
        } else {
            holder.cover.setImageResource(R.drawable.android);
        }

        // setze checked Bild
        if (this.seasonList.get(position).Checked.equals("1.0000")) {
            holder.checkedImage.setImageResource(R.drawable.correct); // alles ganz
        } else if (this.seasonList.get(position).Checked.equals("0.0000")) {
            holder.checkedImage.setImageResource(R.drawable.wrong); // alles defekt
        } else if (this.seasonList.get(position).Checked.length() == 0) {
            holder.checkedImage.setImageDrawable(null); // noch nicht geprüft
        } else {
            holder.checkedImage.setImageResource(R.drawable.yellowdot); // teilweise defekt
        }

        // setzte view count
        holder.viewCount.setText(String.valueOf(Math.round(this.seasonList.get(position).Views*100)/100.));




    }

    // iteriert über jedes Element des String-Arrays (position) ist Array-Index
    @Override
    public View getView(final int position, View convertView, ViewGroup parent) {

        ViewHolder holder;

        if (convertView == null) {

            LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE); //hole den LayoutInflater
            convertView = inflater.inflate(R.layout.list_element, null);//inflate Element

            // erstelle ViewHolder, setze Klassenvariablen und füge ihn dem View hinzu
            holder = new ViewHolder();
            convertView.setTag(holder);
            holder.firstLine = (TextView) convertView.findViewById(R.id.firstLine);
            holder.secondLine = (TextView) convertView.findViewById(R.id.secondLine);
            holder.thirdLine = (TextView) convertView.findViewById(R.id.thirdLine);
            holder.cover = (ImageView) convertView.findViewById(R.id.cover);
            holder.checkedImage = (ImageView) convertView.findViewById(R.id.checkedImage);
            holder.viewCount = (TextView) convertView.findViewById(R.id.viewCount);

            // führe Funktion zum Anpassen des Views aus
            setValues(holder, position);

            // setze onClickListener ... ändert sich nie, deshalb nur beim Initialisieren
            convertView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {

                    ViewHolder holder = (ViewHolder) v.getTag();
                    FragmentManager fragmentManager = ((Activity) context).getFragmentManager();
                    EpisodeListFragment episodeListFragment = new EpisodeListFragment();
                    episodeListFragment.setSeason_nr(holder.season_nr);

                    fragmentManager.beginTransaction().replace(R.id.mainContent, episodeListFragment).addToBackStack("episodeListFragment").commit();

                }
            });


        } else {

            holder = (ViewHolder) convertView.getTag();

            setValues(holder, position);

        }

        return convertView;
    }

    private class ViewHolder {

        public TextView firstLine;
        public TextView secondLine;
        public TextView thirdLine;
        public ImageView cover;
        public ImageView checkedImage;
        public TextView viewCount;
        public int season_nr;

    }

}