package com.example.markus.mediadbviewer;

import java.util.ArrayList;

/**
 * Created by markus on 12.01.16.
 */
public class MediaObject {

    // allgemeine Attribute
    public String name; //Bsp.: Hangover 1
    public long  size; // immer in Byte
    public String md5; // Prüfsumme der jeweiligen Datei
    public String vcodec; //entspricht dem Container (z.B. mkv)
    public int duration; //Laufzeit in Sekunden
    public int totalbitrate; //durchschnittliche Bitrate der Datei (Audio + Video)
    public String resolution; //Werte: 1080p, 720p, SD
    public int width; //Videobreite in Pixeln
    public int height; //Videohöhe in Pixeln
    public String acodecger; //Audiocodec der deutschen Tonspur
    public int abitrateger; //Bitrate der deutschen Tonspur
    public int channelsger; //Anzahl Kanäle der deutschen Tonspur
    public String acodeceng; //Audiocodec der englischen Tonspur; Null, wenn nicht vorhanden
    public int abitrateeng; //Bitrate der englischen Tonspur; Null, wenn nicht vorhanden
    public int channelseng; //Anzahl Kanäle der englischen Tonspur; Null, wenn nicht vorhanden
    public int hdd; //Festplatte auf der sich die Datei befindet
    public String checked; //Indikator, ob der Film bereits auf Fehler überprüft wurde
    public int views; //Anzahl gesehen
    public String comment; //Kommentar
    public String added; //Datum, an dem der Filme hinzugefügt wurde
    public String lastView; //Datum, an dem der Film das letzte mal gesehen wurde

    // filmspezifische Attribute
    public ArrayList<String> Genre = new ArrayList<String>(); // Genres des Films
    public ArrayList<String> schauspieler = new ArrayList<String>(); // Schauspieler des Films
    public String imdbID; //Bsp.: 0123456 (immer 7 Zahlen)
    public int year; //Bsp.: 2015
    public String dimensions; //entspricht Spalte 3d in der Datenbank
    public double rating; //IMDB-Rating des Films

    // serienspezifische Attribute
    public int series_nr; // Primärschlüssel für Serien
    public int season; // Staffel-Nummer
    public String sound; // Ton: z.B. 2.0 oder 5.1
    public String source; // Quelle der Staffel
    public int season_nr; // Primärschlüssel für Staffeln
    public int finished; // Information, ob eine Serie abgeschlossen ist
    public int episodenumber; // Nummer einer Episode
    public double Views; // abstrakt: AVG(Episoden.views)
    public String Checked; // abstrakt: AVG(Episoden.checked)
    public long Size; // abstrakt: SUM(Episoden.size)
    public long Duration; // abstrakt; SUM(Episoden.duration)

}
