package com.example.markus.mediadbviewer;

import android.app.Dialog;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.View;
import android.view.Menu;
import android.view.MenuItem;
import android.view.Window;
import android.view.WindowManager;

import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import android.widget.*;
import android.support.v7.app.ActionBarDrawerToggle;
import android.app.ProgressDialog;
import android.app.Fragment;
import android.app.FragmentManager;

public class MainActivity extends AppCompatActivity {

    public static ProgressDialog progressDialog; // erstellt eine Fortschrittsanzeige
    public static final String rootCoverFolder = "/data/data/com.example.markus.mediadbviewer/cover/";

    // Variablen für Sidebar
    private Menu menu = null;
    ListView navigationListView;
    RelativeLayout filterLayout;
    RelativeLayout navigationLayout;
    private DrawerLayout rootDrawerLayout;
    ArrayList<NavigationbarIcon> navigationIcons = new ArrayList<NavigationbarIcon>();

    public void closeMovieFilter() {

        this.rootDrawerLayout.closeDrawer(filterLayout);

    }

    public void openMovieFilter() {

        this.rootDrawerLayout.openDrawer(filterLayout);

    }

    public void setMovieFilterVisible() {

        this.rootDrawerLayout.setDrawerLockMode(DrawerLayout.LOCK_MODE_UNLOCKED, filterLayout);
        ((MenuItem) this.menu.findItem(R.id.action_search)).setVisible(true);
    }

    public void setMovieFilterInvisible() {

        this.rootDrawerLayout.setDrawerLockMode(DrawerLayout.LOCK_MODE_LOCKED_CLOSED, filterLayout);
        // beim ersten Aufruf existiert Menu noch nicht
        if (this.menu != null) {
            ((MenuItem) this.menu.findItem(R.id.action_search)).setVisible(false);
        }
    }

    // Funktion bei Auswahl eines Sidebar-Eintrags
    private void selectItemFromDrawer(int position) {

        FragmentManager fragmentManager = getFragmentManager(); //Manager zum Verwalten der Fragmente
        // schließe alle offenen Fragmente
        for (int i=fragmentManager.getBackStackEntryCount(); i>0; i--) {
            fragmentManager.popBackStack();
        }

        // Element aus Navigation Drawer wurde ausgewählt
        if (navigationIcons.get(position).mTitle.equals("Filme")) {

            // erstelle Fragment
            MovieListFragment fragment = new MovieListFragment(); // eigenes Fragment initialisieren
            fragmentManager.beginTransaction().replace(R.id.mainContent, fragment).addToBackStack("movieListFragment").commit(); //Fragment aktivieren

        } else if (navigationIcons.get(position).mTitle.equals("Serien")) {

            // erstelle Fragment
            SeriesListFragment fragment = new SeriesListFragment(); // eigenes Fragment initialisieren
            fragmentManager.beginTransaction().replace(R.id.mainContent, fragment).addToBackStack("seriesListFragment").commit(); //Fragment aktivieren

        } else if (navigationIcons.get(position).mTitle.equals("Home")) {

            TableUpdater updater = new TableUpdater();
            try {
                updater.execute().get();
            } catch (Exception e) {

            }
            String response = updater.getResponse();
            Log.d("DEBUG", response);

        }

        navigationListView.setItemChecked(position, true); //Sidebar Eintrag als ausgewählt markieren
        setTitle(navigationIcons.get(position).mTitle); //Titel in der Leiste oben auf SidebarEintrag setzen
        rootDrawerLayout.closeDrawer(navigationLayout); // Schließen der Sidebar
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);

        // Hintergrundfarbe der Status Leiste setzen
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = getWindow();
            window.clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
            window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
            window.setStatusBarColor(getResources().getColor(R.color.material_blue_grey_800));
        }

        // aktivierer Menü-Knopf oben links in der Ecke, um in die Sidebar zu kommen
        DrawerLayout drawer = (DrawerLayout) findViewById(R.id.drawerLayout);
        ActionBarDrawerToggle toggle = new ActionBarDrawerToggle(this, drawer, toolbar, R.string.navigation_drawer_open, R.string.navigation_drawer_close);
        drawer.setDrawerListener(toggle);
        toggle.syncState();

        Fragment homeFragment = new HomeFragment();
        FragmentManager fragmentManager = getFragmentManager();
        fragmentManager.beginTransaction().replace(R.id.mainContent, homeFragment).addToBackStack("mainFragment").commit();

        navigationIcons.add(new NavigationbarIcon("Home", "Startbildschirm", R.drawable.android));
        navigationIcons.add(new NavigationbarIcon("Filme", "Übersicht aller Filme", R.drawable.android));
        navigationIcons.add(new NavigationbarIcon("Serien", "Übersicht aller Serien", R.drawable.android));
        navigationIcons.add(new NavigationbarIcon("Über", "Entwicklerinfos", R.drawable.android));

        // linkes Slidermenu
        // DrawerLayout
        rootDrawerLayout = (DrawerLayout) findViewById(R.id.drawerLayout);
        // Populate the Navigtion Drawer with options
        navigationLayout = (RelativeLayout) findViewById(R.id.drawerPane);
        navigationListView = (ListView) findViewById(R.id.navList);
        DrawerListAdapter adapter = new DrawerListAdapter(this, navigationIcons);
        navigationListView.setAdapter(adapter);

        // Drawer Item click listeners
        navigationListView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                selectItemFromDrawer(position); //führt Funktion zur Auswahl eines Sidebar-Eintrags aus
            }
        });

        // rechter Slider
        filterLayout = (RelativeLayout) findViewById(R.id.filterLayout);
        setMovieFilterInvisible(); //wird deaktiviert

    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {

        this.menu = menu;
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_main, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_search) {
            this.openMovieFilter();
        }

        return super.onOptionsItemSelected(item);
    }

    public void downloadCover(View view) {

        //hole alle imdbIDs
        MovieQueryFactory movieQueryFactory = new MovieQueryFactory();
        movieQueryFactory.addColumns(new String[]{"imdbID"});
        movieQueryFactory.setOrder("name", "ASC");
        JSONParser parser = new JSONParser();
        try {
            parser.execute(new String[]{movieQueryFactory.getUrl()}).get();
        } catch (Exception e) {

        }
        ArrayList<MediaObject> movieList = parser.getMediaList();

        // wandle ArrayList in Array um
        String[] imdbArray = new String[movieList.size()+1];
        for (int i=0; i<movieList.size(); i++) {
            imdbArray[i] = movieList.get(i).imdbID;
        }
        imdbArray[movieList.size()] = "0000000"; // füge default Cover hinzu


        //hole alle series_nrs
        parser = new JSONParser();
        SeriesQueryFactory seriesQueryFactory = new SeriesQueryFactory("Serien");
        seriesQueryFactory.addColumns(new String[]{"series_nr"});
        try {
            parser.execute(new String[]{seriesQueryFactory.getUrl()}).get();
        } catch (Exception e) {

        }
        ArrayList<MediaObject> seriesList = parser.getMediaList();

        // wandle ArrayList in Array um
        String[] series_nrArray = new String[seriesList.size()];
        for (int i=0; i<seriesList.size(); i++) {
            series_nrArray[i] = String.valueOf(seriesList.get(i).series_nr);
        }


        //hole alle season_nrs
        parser = new JSONParser();
        SeriesQueryFactory seasonQueryFactory = new SeriesQueryFactory("Staffeln");
        seriesQueryFactory.addColumns(new String[]{"season_nr"});
        try {
            parser.execute(new String[]{seasonQueryFactory.getUrl()}).get();
        } catch (Exception e) {

        }
        ArrayList<MediaObject> seasonList = parser.getMediaList();

        // wandle ArrayList in Array um
        String[] season_nrArray = new String[seasonList.size()];
        for (int i=0; i<seasonList.size(); i++) {
            season_nrArray[i] = String.valueOf(seasonList.get(i).season_nr);
        }


        Log.d("Cover", String.valueOf(imdbArray.length));
        progressDialog = new ProgressDialog(this);
        progressDialog.setMessage("Cover werden heruntergeladen! Bitte warten ...");
        progressDialog.setIndeterminate(false);
        progressDialog.setMax((imdbArray.length * 2) + series_nrArray.length + (season_nrArray.length * 2)); // Skala-Maximum = Anzahl der Cover
        progressDialog.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
        progressDialog.setCancelable(false);
        progressDialog.show();

        new CoverDownloader("Filme", "low").execute(imdbArray);
        new CoverDownloader("Filme", "high").execute(imdbArray);
        new CoverDownloader("Serien", "low").execute(series_nrArray);
        new CoverDownloader("Staffeln", "low").execute(season_nrArray);
        new CoverDownloader("Staffeln", "high").execute(season_nrArray);

    }

    @Override
    public void onBackPressed() {

        String itemToClose = getFragmentManager().getBackStackEntryAt(getFragmentManager().getBackStackEntryCount() - 1).getName();

        if (rootDrawerLayout.isDrawerOpen(navigationLayout)) {
            rootDrawerLayout.closeDrawer(navigationLayout);
        } else {
            if (itemToClose.equals("mainFragment")) {
                super.onBackPressed();
            } else if (itemToClose.equals("movieListFragment") || itemToClose.equals("seriesListFragment") || itemToClose.equals("settingsFragment") || itemToClose.equals("statisticFragment")) {
                getFragmentManager().popBackStack();
                Fragment homeFragment = new HomeFragment();
                FragmentManager fragmentManager = getFragmentManager();
                fragmentManager.beginTransaction().replace(R.id.mainContent, homeFragment).addToBackStack("mainFragment").commit();

            } else {
                getFragmentManager().popBackStack();
            }

        }


    }

}
