package com.example.markus.mediadbviewer;

import android.os.AsyncTask;
import android.util.JsonReader;
import android.util.JsonToken;
import android.util.Log;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.io.InputStreamReader;
import java.io.InputStream;
import java.util.ArrayList;

class JSONParser extends AsyncTask<String, String, String> {

    private ArrayList<MediaObject> mediaList;

    public ArrayList<MediaObject> getMediaList() {

        return this.mediaList;

    }


    @Override
    protected String doInBackground(String[] links) {

        try {

            URL url = new URL(links[0]);
            URLConnection connection = url.openConnection();
            connection.connect();
            InputStream stream = connection.getInputStream();
            InputStreamReader isReader = new InputStreamReader(stream);
            JsonReader jsonReader = new JsonReader(isReader);
            this.mediaList = readJsonStream(stream);

        } catch (Exception e) {

            Log.d("Exceptions", e.getClass().getName());

        }

        return null;
    }

    public ArrayList<MediaObject> readJsonStream(InputStream in) throws IOException {
        JsonReader reader = new JsonReader(new InputStreamReader(in, "UTF-8"));
        ArrayList<MediaObject> list = new ArrayList();
        try {
            reader.beginObject(); //startet das root Object, welches mit { beginnt
            for (int i=0; i<3; i++) { //überspringt die ersten 4 Attribute, da uninteressant
                Log.d("JSON", reader.nextName()); // nextName muss aufgerufen werden !!!
                reader.skipValue();
            }
            if (reader.nextName().equals("Antwort")) {
                reader.beginObject();
                if (reader.nextName().equals("Spalten")) {
                    reader.skipValue();
                }
            }
            list = readMessagesArray(reader);
        } catch (Exception e) {
            Log.d("JSONFehler", e.getMessage());
        } finally {
            reader.close();
        }
        return list;
    }

    public ArrayList<MediaObject> readMessagesArray(JsonReader reader) throws IOException {
        ArrayList<MediaObject> media = new ArrayList();
        if (reader.nextName().equals("Data")) {
        }
        reader.beginArray();
        while (reader.hasNext()) {
            media.add(readMessage(reader));
        }
        reader.endArray();
        reader.endObject();
        reader.endObject();
        return media;
    }

    public MediaObject readMessage(JsonReader reader) throws IOException {
        MediaObject mediaObject = new MediaObject();

        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            //Log.d("JSON", name);
            if (name.equals("imdbID")) {
                mediaObject.imdbID = reader.nextString();
            } else if (name.equals("name")) {
                mediaObject.name = reader.nextString();
            } else if (name.equals("year")) {
                mediaObject.year = reader.nextInt();
            } else if (name.equals("size")) {
                mediaObject.size = reader.nextLong();
            } else if (name.equals("Size")) {
                mediaObject.Size = reader.nextLong();
            } else if (name.equals("md5")) {
                mediaObject.md5 = reader.nextString();
            } else if (name.equals("3d")) {
                mediaObject.dimensions = reader.nextString();
            } else if (name.equals("vcodec")) {
                mediaObject.vcodec = reader.nextString();
            } else if (name.equals("duration")) {
                mediaObject.duration = reader.nextInt();
            } else if (name.equals("Duration")) {
                mediaObject.Duration = reader.nextInt();
            } else if (name.equals("totalbitrate")) {
                mediaObject.totalbitrate = reader.nextInt();
            } else if (name.equals("resolution")) {
                mediaObject.resolution = reader.nextString();
            } else if (name.equals("width")) {
                mediaObject.width = reader.nextInt();
            } else if (name.equals("height")) {
                mediaObject.height = reader.nextInt();
            } else if (name.equals("acodecger")) {
                mediaObject.acodecger = reader.nextString();
            } else if (name.equals("abitrateger")) {
                mediaObject.abitrateger = reader.nextInt();
            } else if (name.equals("channelsger")) {
                mediaObject.channelsger = reader.nextInt();
            } else if (name.equals("acodeceng")) {
                try {
                    mediaObject.acodeceng = reader.nextString();
                } catch (Exception e){
                    mediaObject.acodeceng = "";
                }
            } else if (name.equals("abitrateeng")) {
                try {
                    mediaObject.abitrateeng = Integer.valueOf(reader.nextString());
                } catch (Exception e) {
                    mediaObject.abitrateeng = 0;
                }
            } else if (name.equals("channelseng")) {
                try {
                    mediaObject.channelseng = Integer.valueOf(reader.nextString());
                } catch (Exception e) {
                    mediaObject.channelseng = 0;
                }
            } else if (name.equals("hdd")) {
                mediaObject.hdd = reader.nextInt();
            } else if (name.equals("rating")) {
                mediaObject.rating = reader.nextDouble();
            } else if (name.equals("checked")) {
                mediaObject.checked = reader.nextString();
            } else if (name.equals("Checked")) {
                mediaObject.Checked = reader.nextString();
            } else if (name.equals("views")) {
                mediaObject.views = reader.nextInt();
            } else if (name.equals("Views")) {
                mediaObject.Views = reader.nextDouble();
            } else if (name.equals("comment")) {
                mediaObject.comment = reader.nextString();
            } else if (name.equals("added")) {
                mediaObject.added = reader.nextString();
            } else if (name.equals("lastView")) {
                mediaObject.lastView = reader.nextString();
            } else if (name.equals("Schauspieler")) {
                reader.beginArray();
                while (reader.hasNext()) {
                    try {
                        mediaObject.schauspieler.add(reader.nextString());
                    } catch (Exception e) {
                        Log.d("FIND", "Hallo");
                    }
                }
                reader.endArray();
            } else if (name.equals("Genre") && reader.peek() != JsonToken.NULL) {
                reader.beginArray();
                while (reader.hasNext()) {
                    mediaObject.Genre.add(reader.nextString());
                }
                reader.endArray();
            } else if (name.equals("series_nr")) {
                mediaObject.series_nr = reader.nextInt();
            } else if (name.equals("season_nr")) {
                mediaObject.season_nr = reader.nextInt();
            } else if (name.equals("season")) {
                mediaObject.season = reader.nextInt();
            } else if (name.equals("source")) {
                mediaObject.source = reader.nextString();
            } else if (name.equals("sound")) {
                mediaObject.sound = reader.nextString();
            } else if (name.equals("finished")) {
                mediaObject.finished = reader.nextInt();
            } else if (name.equals("episodenumber")) {
                mediaObject.episodenumber = reader.nextInt();
            } else {
                Log.d("JSON", "Skipped: " + name);
                reader.skipValue();
            }
        }
        reader.endObject();
        return mediaObject;
    }



}
