<?php
class Media {
	private $Console;
	private $configfile;
	private $config;
	private $PfadzumEinlesen;
	private $PfadzumAusgeben;
	private $HDDID;
	private $FolderArray;
	public function __construct($configfile) {
		$this->Console = new Console();
		$this->configfile = $configfile;
		
		
		if(file_exists($configfile)){
			echo $this->Console->getColoredString("Hinweis:","black", "light_gray")." Configfile: ".$configfile." geladen!".PHP_EOL.PHP_EOL;
			$dateihandle = fopen($this->configfile,"r");
			$this->config = json_decode(fread($dateihandle, filesize($this->configfile)),true);
			
		}
		else{
			echo $this->Console->getColoredString("Hinweis:","black", "light_gray")." Configfile: ".$configfile." exisitiert nicht! Es werden defaults geladen!".PHP_EOL;
			echo "         Zum Anlegen der config bitte config save eingeben!".PHP_EOL.PHP_EOL;
			$this->config = array("configChangeTime" => time(),
							"ReadFromDir" => "/media/QNAP/FilmeWirdgelesen",
							"FolderIgnor" => array('.', '..', '.@__thumb', '@Recycle'),
							"HDD" => array(1 => array("HDDdir" => "/media/QNAP/",
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/"),
											2 => array("HDDdir" => NULL,
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/"),
											3 => array("HDDdir" => NULL,
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/"),
											4 => array("HDDdir" => NULL,
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/"),
											5 => array("HDDdir" => NULL,
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/") 
			));
		}
	}
	public function config($Action){
		switch ($Action){
			case "show":
				echo $this->Console->error("Folgende Config ist geladen:","black").PHP_EOL.PHP_EOL;
				echo "Config erstellt: ".date("H:i:s d.m.Y ",$this->config["configChangeTime"])		.PHP_EOL;
				foreach ($this->config["HDD"] as $key => $value) {
					if($value["HDDdir"] != NULL){
						foreach ($value as $key2 => $value2) {
						echo "HDD ".$key.": ".$key2.": ".$value2.PHP_EOL;
						}
					}
				}
				echo PHP_EOL;
				break;
			case "save":
				echo $this->Console->error("Config gespeichert!", "green").PHP_EOL.PHP_EOL;
				$dateihandle = fopen($this->configfile,"w");
				fwrite($dateihandle, json_encode($this->config, JSON_PRETTY_PRINT));
				fclose($dateihandle);
				break;
			default:
				echo $this->Console->getColoredString("Kein Parameter für Config übergeben","red", "light_gray").PHP_EOL.PHP_EOL;
				
				break;
		}
	}
	public function filme(){
		//var_dump($this->config);
		echo $this->Console->getColoredString("Filme", "black", "light_gray") .PHP_EOL;
		
		echo "In welchen Verzeichnis liegen die einzulesenden Dateien? ( nur Enter = ".$this->config["ReadFromDir"].")" .PHP_EOL;
		$Pfad = trim(fgets(STDIN));
		$this->PfadzumEinlesen = (strlen($Pfad)>0?$Pfad:$this->config["ReadFromDir"]);
		if(!is_dir($this->PfadzumEinlesen)){
			return $this->Console->error("Pfad Eingabe exisitiert nicht!").PHP_EOL;
		}else {
			echo "    Verzeichnis ".$this->PfadzumEinlesen." wird für Eingabe verwendet".PHP_EOL;
		}
		echo PHP_EOL;
		
		echo "Auf welche Festplatte sollen die Filme gespeichert werden? ( nur Enter = 1)" .PHP_EOL;
		$hddid = trim(fgets(STDIN));
		$this->HDDID = (strlen($hddid)>0?$hddid:1);
		$this->PfadzumAusgeben = $this->config["HDD"][$this->HDDID]["HDDdir"];
		foreach ($this->config["HDD"][$this->HDDID] as $key => $value) {
			if(!($key == "HDDdir")){
				if(!is_dir($this->PfadzumAusgeben.$value)){	return "   ".$this->Console->error("Pfad für Ausgabe exisitiert nicht!").PHP_EOL;        }
				else {									echo "    Verzeichnis ".$this->PfadzumAusgeben.$value." wird für ".$key." als Ausgabe verwendet".PHP_EOL;	}
			}
		}
		echo PHP_EOL;
		
		echo "Starte verarbeitung der Filme:".PHP_EOL.PHP_EOL;
		$FilmeArr = $this->dirtoArray($this->PfadzumEinlesen);
		//var_dump($FilmeArr);
		foreach ($FilmeArr as $value) {
			//echo " ".$this->PfadzumEinlesen.'/'.(strlen($value[0])>0?$value[0].'/':'').$value[1].PHP_EOL;
			echo $this->parseMovie($this->PfadzumEinlesen.'/'.(strlen($value[0])>0?$value[0].'/':''), $value[1]).PHP_EOL;
		}
		
		trim(fgets(STDIN));
		echo PHP_EOL;
		//return ;
	}
	private function parseMovie($Pfad, $Filename){
		$array = array();
		$FilenameOrg = $Filename;
		$array["hdd"] = $this->HDDID;
		if(strpos($Filename, "(3D)")>0){
			$Filename = str_replace("(3D)", "", $Filename);
			$array["3d"] = true;
		}
		else{ $array["3d"] = ""; }
		if(strpos($Filename, "(720p)")>0){
			$Filename = str_replace("(720p)", "", $Filename);
			$array["resolution"] = "720p";
		}
		else if(strpos($Filename, "(1080p)")>0){
			$Filename = str_replace("(1080p)", "", $Filename);
			$array["resolution"] = "1080p";
		}
		else if(strpos($Filename, "(SD)")>0){
			$Filename = str_replace("(SD)", "", $Filename);
			$array["resolution"] = "SD";
		}
		$array["imdbID"] = substr($Filename,strripos( $Filename,"(")+1,7);
		$array["name"]   = trim(substr($Filename, 0, strripos( $Filename,"(")));
		/**/$array["Endung"] = trim(substr($Filename,strripos( $Filename,".")+1));
		
		
		
		echo $Pfad.$FilenameOrg.PHP_EOL;
	// Werte aus IMdb Auslesen...
		$imdb = new IMDB("http://www.imdb.com/title/tt".$array["imdbID"]."/");
		if ($imdb->isReady) {
			//var_dump($imdb->getAll());
			$array["year"] = $imdb->getYear();
			$array["size"] = $this->getfileSize($Pfad.$FilenameOrg);
			//$array["md5"] = md5_file($Pfad.$FilenameOrg); //TODO Einkommentieren für md5
				
			$array["rating"] = $imdb->getRating();
		} else{
			echo "nichts gefunden!".PHP_EOL;
		}
	// werte von MediaInfo holen...
		/*$mediainfo = new mediaInfo($Pfad.$FilenameOrg);
		$array["width"] = $mediainfo->get_width();
		$array["height"] = $mediainfo->get_height(); 
		$array["Duration"] = $mediainfo->get_video_property("Duration");
		$array["Duration"] = $mediainfo->get_video_property("Duration");
		*/
		$p = xml_parser_create();
		$befehl = 'mediainfo --Output=XML "'.$Pfad.$FilenameOrg.'" > /tmp/'.$array["imdbID"].'.xml';
		exec($befehl);
		//echo $befehl;
		$xmlstring = file_get_contents('/tmp/'.$array["imdbID"].'.xml');
		/*echo $xml;
		xml_parse_into_struct($p, $xml, $vals, $index);
		xml_parser_free($p);*/
		
		$xml = simplexml_load_string($xmlstring);
		$json = json_encode($xml,JSON_PRETTY_PRINT);
		//echo $json;
		$array2 = json_decode($json,TRUE);
		foreach ($array2["File"]["track"] as $key => $value) {
			echo " ".$key." ".$value["@attributes"]["type"].PHP_EOL;
			switch ($key) {
				case "General":
					$array["vcodec"] = str_replace("Matroska", "mkv", $value["Format"]);
					$array["duration"] = $this->getRunTime($value["Duration"]);
					$array["totalbitrate"] = round(trim(str_replace(" ", "",str_replace("Mbps", "", $value["Overall_bit_rate"])))*1024,0);
					break;
				case "Video":
					$array["width"] = $value["Width"];
					$array["height"] = $value["Height"];
					break;					
				case "Audio":
					if(isset($value["Language"])){
						if(($value["Language"] == "Deutsch") OR ($value["Language"] == "German")){
							$array["acodecger"] = $value["Format"];
							$array["abitrateger"] = trim(str_replace("Kbps", "",$value["Bit_rate"]));
							$array["channelsger"] = $value["Channel_s_"];
						}
						else if(($value["Language"] == "Englisch") OR ($value["Language"] == "English")){
							$array["acodeceng"] = $value["Format"];
							$array["abitrateeng"] = trim(str_replace("Kbps", "",$value["Bit_rate"]));
						}
					}
					break;
				
				default:
					;
				break;
			}
			/*foreach ($value as $key2 => $value2) {
				if(!in_array($key2, array("@attributes"))){
					echo "  ".$key2." ".$value2.PHP_EOL;
				}
				
			}*/
		}
		//var_dump($array);
		//print_r($array);
		
		//print_r($vals);
		
		foreach ($array as $key => $value) {
			echo " ".$key." => '".$value."'".PHP_EOL;
		}
		//var_dump($array);
		//return 
		
	}
	private function getRunTime($laufzeit){
		$string = explode(" ", $laufzeit);
		return ((trim(str_replace("h", "", $string[0]))*3600)+(trim(str_replace("m", "", $string[1])*60)));
	}
	private function getfileSize($file){
		//$size = ;
		return trim(explode("/", exec('du -b "'.$file.'"'))[0]);
		
	}
	private function dirtoArray($dir, $root = ''){
		$Arr = scandir($dir);
		foreach ($this->config["FolderIgnor"] AS $value){
			unset($Arr[array_search($value, $Arr)]);
		}
		foreach ( $Arr AS $Key => $Value){
			if(is_dir ($dir.'/'.$Value) AND !in_array($Value, $FolderIgnor)){
				$SubDir = dirtoArray($dir.'/'.$Value, $root.'/'.$Value);
			}
			else{
				$this->FolderArray[] = array($root, $Value);
			}
		}
		return $this->FolderArray;
	}
	
	
}