<?php
class Media {
	private $Console;
	private $configfile;
	private $config;
	private $PfadzumEinlesen;
	private $PfadzumAusgeben;
	private $HDDID;
	private $FolderArray;
	public function __construct($configfile) {
		$this->Console = new Console();
		$this->configfile = $configfile;
		
		
		if(file_exists($configfile)){
			echo $this->Console->getColoredString("Hinweis:","black", "light_gray")." Configfile: ".$configfile." geladen!".PHP_EOL.PHP_EOL;
			$dateihandle = fopen($this->configfile,"r");
			$this->config = json_decode(fread($dateihandle, filesize($this->configfile)),true);
			
		}
		else{
			echo $this->Console->getColoredString("Hinweis:","black", "light_gray")." Configfile: ".$configfile." exisitiert nicht! Es werden defaults geladen!".PHP_EOL;
			echo "         Zum Anlegen der config bitte config save eingeben!".PHP_EOL.PHP_EOL;
			$this->config = array("configChangeTime" => time(),
							"ReadFromDir" => "/media/QNAP/FilmeWirdgelesen",
							"FolderIgnor" => array('.', '..', '.@__thumb', '@Recycle'),
							"HDD" => array(1 => array("HDDdir" => "/media/QNAP/",
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/"),
											2 => array("HDDdir" => NULL,
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/"),
											3 => array("HDDdir" => NULL,
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/"),
											4 => array("HDDdir" => NULL,
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/"),
											5 => array("HDDdir" => NULL,
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/") 
			));
			
			
			
		}
	}
	public function config_show(){
			
	}
	public function config($Action){
		switch ($Action){
			case "show":
				//var_dump($this->config);
				echo $this->Console->error("Folgende Config ist geladen:","black").PHP_EOL.PHP_EOL;
				echo "Config erstellt: ".date("H:i:s d.m.Y ",$this->config["configChangeTime"])		.PHP_EOL;
				foreach ($this->config["HDD"] as $key => $value) {
					if($value["HDDdir"] != NULL){
						foreach ($value as $key2 => $value2) {
						echo "HDD ".$key.": ".$key2.": ".$value2.PHP_EOL;
						}
					}
				}
		
				echo PHP_EOL;
				break;
			case "save":
				echo $this->Console->error("Config gespeichert!", "green").PHP_EOL.PHP_EOL;
				$dateihandle = fopen($this->configfile,"w");
				fwrite($dateihandle, json_encode($this->config, JSON_PRETTY_PRINT));
				fclose($dateihandle);
				break;
			default:
				echo $this->Console->getColoredString("Kein Parameter für Config übergeben","red", "light_gray").PHP_EOL.PHP_EOL;
				
				break;
		}
	}
	public function filme(){
		//var_dump($this->config);
		echo $this->Console->getColoredString("Filme", "black", "light_gray") .PHP_EOL;
		
		echo "In welchen Verzeichnis liegen die einzulesenden Dateien? ( nur Enter = ".$this->config["ReadFromDir"].")" .PHP_EOL;
		$Pfad = trim(fgets(STDIN));
		$this->PfadzumEinlesen = (strlen($Pfad)>0?$Pfad:$this->config["ReadFromDir"]);
		if(!is_dir($this->PfadzumEinlesen)){
			return $this->Console->error("Pfad Eingabe exisitiert nicht!").PHP_EOL;
		}else {
			echo "    Verzeichnis ".$this->PfadzumEinlesen." wird für Eingabe verwendet".PHP_EOL;
		}
		echo PHP_EOL;
		
		echo "Auf welche Festplatte sollen die Filme gespeichert werden? ( nur Enter = 1)" .PHP_EOL;
		$hddid = trim(fgets(STDIN));
		$this->HDDID = (strlen($hddid)>0?$hddid:1);
		$this->PfadzumAusgeben = $this->config["HDD"][$this->HDDID]["HDDdir"];
		foreach ($this->config["HDD"][$this->HDDID] as $key => $value) {
			if(!($key == "HDDdir")){
				if(!is_dir($this->PfadzumAusgeben.$value)){	return "   ".$this->Console->error("Pfad für Ausgabe exisitiert nicht!").PHP_EOL;        }
				else {									echo "    Verzeichnis ".$this->PfadzumAusgeben.$value." wird für ".$key." als Ausgabe verwendet".PHP_EOL;	}
			}
		}
		echo PHP_EOL;
		
		echo "Starte verarbeitung der Filme:".PHP_EOL.PHP_EOL;
		$FilmeArr = $this->dirtoArray($this->PfadzumEinlesen);
		//var_dump($FilmeArr);
		foreach ($FilmeArr as $value) {
			//echo " ".$this->PfadzumEinlesen.'/'.(strlen($value[0])>0?$value[0].'/':'').$value[1].PHP_EOL;
			echo $this->parseMovie($this->PfadzumEinlesen.'/'.(strlen($value[0])>0?$value[0].'/':''), $value[1]).PHP_EOL;
		}
		
		trim(fgets(STDIN));
		echo PHP_EOL;
		//return ;
	}
	private function parseMovie($Pfad, $Filename){
		$array = array();
		if(strpos($Filename, "(3D)")>0){
			$Filename = str_replace("(3D)", "", $Filename);
			$array["3d"] = true;
		}
		else{ $array["3d"] = false; }
		if(strpos($Filename, "(720p)")>0){
			$Filename = str_replace("(720p)", "", $Filename);
			$array["Quality"] = "720p";
		}
		else if(strpos($Filename, "(1080p)")>0){
			$Filename = str_replace("(1080p)", "", $Filename);
			$array["Quality"] = "1080p";
		}
		else if(strpos($Filename, "(SD)")>0){
			$Filename = str_replace("(SD)", "", $Filename);
			$array["Quality"] = "SD";
		}
		$array["imdbID"] = substr($Filename,strripos( $Filename,"(")+1,7);
		$array["name"]   = trim(substr($Filename, 0, strripos( $Filename,"(")));
		$array["Endung"] = trim(substr($Filename,strripos( $Filename,".")+1));
		
		strripos( $Filename,".");
		var_dump($array);
		return $Pfad." > ".$Filename;
		
	}
	private function dirtoArray($dir, $root = ''){
		$Arr = scandir($dir);
		foreach ($this->config["FolderIgnor"] AS $value){
			unset($Arr[array_search($value, $Arr)]);
		}
		foreach ( $Arr AS $Key => $Value){
			if(is_dir ($dir.'/'.$Value) AND !in_array($Value, $FolderIgnor)){
				$SubDir = dirtoArray($dir.'/'.$Value, $root.'/'.$Value);
			}
			else{
				$this->FolderArray[] = array($root, $Value);
			}
		}
		return $this->FolderArray;
	}
	
	
}