<?php
mb_internal_encoding("UTF-8");
class Media {
	private $Console;
	private $configfile;
	private $config;
	private $PfadzumEinlesen;
	private $PfadzumAusgeben;
	private $HDDID;
	private $FolderArray;
	public function __construct($configfile) {
		$this->Console = new Console();
		$this->configfile = $configfile;
		if(file_exists($configfile)){
			echo $this->Console->getColoredString("Hinweis:","black", "light_gray")." Configfile: ".$configfile." geladen!".PHP_EOL.PHP_EOL;
			$dateihandle = fopen($this->configfile,"r");
			$this->config = json_decode(fread($dateihandle, filesize($this->configfile)),true);
			
		}
		else{
			echo $this->Console->getColoredString("Hinweis:","black", "light_gray")." Configfile: ".$configfile." exisitiert nicht! Es werden defaults geladen!".PHP_EOL;
			echo "         Zum Anlegen der config bitte config save eingeben!".PHP_EOL.PHP_EOL;
			$this->config = array("configChangeTime" => time(),
							"ReadFromDir" => "/media/QNAP/FilmeZumEinlesen",
							"ReadFromDirSerien" => "/media/QNAP/SerienZumEinlesen",
							"CoverDir" => "cover/",
							"DB_Database" => "MediaDB_Nico",
							"DB_Username" => "MediaDB",
							"DB_Passwort" => "MediaDB",
							"DB_Server" => "192.168.0.32",
							"ApiKeys" => array(	"Fanart_Key"	=>"9902c9197f457401ff7a7eba839213ba",
												"Tmdb_Key"  	=>"b1ddcc7d16281ce09f692896f882ba9d",
												"MediaDB_Key"   =>"Wah2doonie"),
							"FolderIgnor" => array('.', '..', '.@__thumb', '@Recycle'),
							"FileEndungIgnor" => array('jpg', 'nfo'),
							"HDD" => array(1 => array("HDDdir" => "/media/QNAP/",	// Interne QNAP Festplatte
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/"),
											2 => array("HDDdir" => NULL,			// 8 TB Externe für gesehene Filme
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/"),
											3 => array("HDDdir" => "/media/nico/c02491d9-9d01-4817-8eb6-ae2ac438224a/",			// 1 TB Orico für Temporäres einlesen
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/"),
											4 => array("HDDdir" => NULL,
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/"),
											5 => array("HDDdir" => NULL,
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/") 
			));
		}
	}
	public function config($Action){
		switch ($Action){
			case "show":
				echo $this->Console->error("Folgende Config ist geladen:","black").PHP_EOL.PHP_EOL;
				echo "Config erstellt: ".date("H:i:s d.m.Y ",$this->config["configChangeTime"])		.PHP_EOL;
				foreach ($this->config["HDD"] as $key => $value) {
					if($value["HDDdir"] != NULL){
						foreach ($value as $key2 => $value2) {
						echo "HDD ".$key.": ".$key2.": ".$value2.PHP_EOL;
						}
					}
				}
				echo PHP_EOL;
				break;
			case "save":
				echo $this->Console->error("Config gespeichert!", "green").PHP_EOL.PHP_EOL;
				$dateihandle = fopen($this->configfile,"w");
				fwrite($dateihandle, json_encode($this->config, JSON_PRETTY_PRINT));
				fclose($dateihandle);
				break;
			default:
				echo $this->Console->getColoredString("Kein Parameter für Config übergeben","red", "light_gray").PHP_EOL.PHP_EOL;
				
				break;
		}
	}
	public function filme($action = "einlesen"){
		$start = time();
		$endLast = time();
		$korrektor=0;
		if(in_array($action, array( "einlesen","check", "checkfile", "nfo"))){
			//var_dump($this->config);
			echo $this->Console->getColoredString("Filme > ".$action, "black", "light_gray") .PHP_EOL;
			
			if($action == "einlesen"){
				echo "In welchen Verzeichnis liegen die einzulesenden Dateien? ( nur Enter = ".$this->config["ReadFromDir"].")" .PHP_EOL;
				$Pfad = trim(fgets(STDIN));
				$this->PfadzumEinlesen = (strlen($Pfad)>0?$Pfad:$this->config["ReadFromDir"]);
				if(!is_dir($this->PfadzumEinlesen)){
					return $this->Console->error("Pfad Eingabe exisitiert nicht!").PHP_EOL;
				}else {
					echo "    Verzeichnis ".$this->PfadzumEinlesen." wird für einlesen verwendet!".PHP_EOL;
				}
				echo PHP_EOL;
			}
			
			echo "Auf welche Festplatte sollen die Filme gespeichert werden \n bzw. Welche Festplatte soll überprüft bzw. upgedatet werden? ( nur Enter = 1)" .PHP_EOL;
			$hddid = trim(fgets(STDIN));
			$this->HDDID = (strlen($hddid)>0?$hddid:1);
			$this->PfadzumAusgeben = $this->config["HDD"][$this->HDDID]["HDDdir"];
			foreach ($this->config["HDD"][$this->HDDID] as $key => $value) {
				if(!(in_array($key,array ( "HDDdir", "Serien")))){
					if(!is_dir($this->PfadzumAusgeben.$value)){	return "   ".$this->Console->error("Pfad für Ausgabe exisitiert nicht!").PHP_EOL;        }
					else {									echo "    Verzeichnis ".$this->PfadzumAusgeben.$value." wird für ".$key." als Ausgabe verwendet".PHP_EOL;	}
				}
			}
			echo PHP_EOL;
			
			echo "Starte verarbeitung der Filme:".PHP_EOL.PHP_EOL;
			$FilmeArr = array();
			$this->FolderArray = array();
			if(($action == "einlesen")){
				$FilmeArr = $this->dirtoArray($this->PfadzumEinlesen."/");
				//var_dump($FilmeArr);
			}else{
				$this->dirtoArray($this->PfadzumAusgeben."Filme/");
				$FilmeArr = $this->dirtoArray($this->PfadzumAusgeben."Filme3D/");
			}
			
			$fehlerArr = array("");
			$Counter=0;
			//var_dump($FilmeArr);
			foreach ($FilmeArr as $value) {
				//echo $value[2]."<>/<>".$value[1].PHP_EOL.PHP_EOL.PHP_EOL.PHP_EOL;
				$array = $this->parseMovie($value[2].(strlen($value[0])>0?'/':''), $value[1],$action);
				if(($array == false)){
					echo $this->Console->getColoredString("       ","black", "red").PHP_EOL;
					$fehler = $this->Console->getColoredString("Fehler!","black", "red")." ".$this->PfadzumEinlesen.'/'.(strlen($value[0])>0?$value[0].'/':'').$value[1].PHP_EOL;
					echo $fehler;
					$fehlerArr[] = $fehler;
					echo $this->Console->getColoredString("       ","black", "red").PHP_EOL;
				}/*else if((file_exists("./phpTestout/".$array['imdbID'].".txt"))){
					echo $this->Console->getColoredString("Info!","black", "red")."Film wurde bereits verarbeitet!! Bitte Outputfile in 'phpTestout' löschen!".PHP_EOL;
				}*/else{
				
					$Pfad = $value[2].(strlen($value[0])>0?'/':'');
					$PfadOrg = (strlen($value[0])>0?$value[0].'/':'');
					$FilenameOrg = $value[1];
					$Endung = trim(substr($FilenameOrg,strripos( $FilenameOrg,".")+1));
					//Was soll mit den geparsten Film gemacht werden?
					if($action == "einlesen"){
						
						if( $this->addMovie($array, $Pfad.$FilenameOrg, true)){
							if(($Pfad.$FilenameOrg) == ($this->PfadzumAusgeben.($array["3d"]==""?$this->config["HDD"][$this->HDDID]["Filme"]:$this->config["HDD"][$this->HDDID]["3D"]).$Pfad.$array["name"]." (".$array["resolution"].")".($array["3d"] != ""?" (3D)":"")." (".$array["imdbID"].").".$Endung)){
								echo "Datei liegt schon am ausgabe Ort!".PHP_EOL;
							}
							else{
								if(isset($array["collection"])){
									echo "Collection Ausgabe in eigenen Collection Ordner: ".$array["collection"].PHP_EOL;
									$Pfadnew = trim($array["collection"]).'/';
								}
								else{
									$Pfadnew = '';
								}
								if(!is_dir($this->PfadzumAusgeben.($array["3d"]==""?$this->config["HDD"][$this->HDDID]["Filme"]:$this->config["HDD"][$this->HDDID]["3D"]).$Pfadnew)){
									shell_exec("mkdir '".$this->PfadzumAusgeben.($array["3d"]==""?$this->config["HDD"][$this->HDDID]["Filme"]:$this->config["HDD"][$this->HDDID]["3D"]).$Pfadnew."'");
								}
								
								echo "Verschiebe Datei...";
									
								$copy = 'mv "'.
										$Pfad.$FilenameOrg.'" "'.
										$this->PfadzumAusgeben.($array["3d"]==""?$this->config["HDD"][$this->HDDID]["Filme"]:$this->config["HDD"][$this->HDDID]["3D"]).$Pfadnew.$array["name"]." (".$array["resolution"].")".($array["3d"] != ""?" (3D)":"")." (".$array["imdbID"].").".$Endung.'"';
										file_put_contents("./phpTestout/imdbID/".$array['imdbID'].".txt", $copy.PHP_EOL, FILE_APPEND);
										shell_exec($copy);
										echo "done!".PHP_EOL;
							}
							shell_exec("mv './phpTestout/imdbID/".$array["imdbID"].".txt' './phpTestout/imdbID/OK_".$array["imdbID"].".txt'");
						}
						else{
							echo $this->Console->error("Fehler beim Eintragen in die DB!").PHP_EOL;
							file_put_contents("./phpTestout/imdbID/".$array["imdbID"].".txt", "Fehler beim Eintragen in die DB".PHP_EOL, FILE_APPEND);
						}
					}else if($action == "check"){
						if( $this->updateMovie($array, $Pfad.$FilenameOrg, false, true)){  //TODO auf true für md5!!!
							echo " Film wurde Aktualisiert".PHP_EOL;
						}else {
							echo " Film wurde nicht Aktualisiert".PHP_EOL;
						}
					}else if($action == "checkfile"){
						if( $this->updateMovie($array, $Pfad.$FilenameOrg, true, true)){
							echo "Film wurde geprüft und Query angelegt".PHP_EOL;
						}else {
							echo "Film wurde geprüft, keine Änderung".PHP_EOL;
						}
						
					}else if($action == "nfo"){
						
						//NFO
						$this->GenerateNFO($array, $Pfad.$FilenameOrg);
					}
				}
				
				$end = time();
				if(abs($end-$endLast)<10){
					$korrektor++;
				}
				$endLast = $end;
				$Counter++;
				$laufzeit = $end - $start;
					$H = floor($laufzeit / 3600);
					$i = ($laufzeit / 60) % 60;
					$s = $laufzeit % 60;
				$Durchschnitt = $laufzeit/($Counter);
					$Hd = floor($Durchschnitt / 3600);
					$id = ($Durchschnitt / 60) % 60;
					$sd = $Durchschnitt % 60;
				if(($Counter-$korrektor)>0){
					$Durchschnittk = $laufzeit/($Counter-$korrektor);
					$Hdk = floor($Durchschnittk / 3600);
					$idk = ($Durchschnittk / 60) % 60;
					$sdk = $Durchschnittk % 60;
				}
				
				$status =  "Laufzeit: ".sprintf("%02d:%02d:%02d", $H, $i, $s).
							"(Pro Film:  ".sprintf("%02d:%02d:%02d", $Hd, $id, $sd).   " (".$Counter.' von '.count($FilmeArr)."))".(($Counter-$korrektor)>0?
							"(korrigiert:".sprintf("%02d:%02d:%02d", $Hdk, $idk, $sdk)." (".($Counter-$korrektor).' von '.(count($FilmeArr)-$korrektor).")) ":"");
				echo $status.PHP_EOL.PHP_EOL;
				file_put_contents("./phpTestout/default.txt", $status." ".$value[1].PHP_EOL.PHP_EOL, FILE_APPEND);
			}
			echo $this->Console->getColoredString("Alle Filme Verarbeitet!", "green", "light_gray") .PHP_EOL;
			echo "Folgende Filme konten nicht verarbeitet werden: ".PHP_EOL;
			foreach ($fehlerArr as $fehler) {
				//echo $fehler.PHP_EOL;
			}
			$end = time();
			$laufzeit = $end - $start;
				$H = floor($laufzeit / 3600);
				$i = ($laufzeit / 60) % 60;
				$s = $laufzeit % 60;
			
			$status =  "Gesamtlaufzeit: ".sprintf("%02d:%02d:%02d", $H, $i, $s)."! ".$Counter.' von '.count($FilmeArr).PHP_EOL.PHP_EOL;
			echo $status;
			file_put_contents("./phpTestout/default.txt", $status.PHP_EOL, FILE_APPEND);
			
			//trim(fgets(STDIN));
			echo PHP_EOL;
			//return ;
		}else{
			echo "Not Found!".PHP_EOL;
		}
	}
	public function serien($action = "einlesen"){
		$start = time();
		$endLast = time();
		$korrektor=0;
		if(in_array($action, array( "einlesen","check", "checkfile", "nfo"))){
			if($action == "einlesen"){
				echo "In welchen Verzeichnis liegen die einzulesenden Dateien? ( nur Enter = ".$this->config["ReadFromDirSerien"].")" .PHP_EOL;
				$Pfad = trim(fgets(STDIN));
				$this->PfadzumEinlesen = (strlen($Pfad)>0?$Pfad:$this->config["ReadFromDirSerien"]);
				if(!is_dir($this->PfadzumEinlesen)){
					return $this->Console->error("Pfad Eingabe exisitiert nicht!").PHP_EOL;
				}else {
					echo "    Verzeichnis ".$this->PfadzumEinlesen." wird für einlesen verwendet!".PHP_EOL;
				}
				echo PHP_EOL;
				
			}
			echo "Auf welche Festplatte sollen die Serien gespeichert werden \n bzw. Welche Festplatte soll überprüft bzw. upgedatet werden? ( nur Enter = 1)" .PHP_EOL;
			$hddid = trim(fgets(STDIN));
			$this->HDDID = (strlen($hddid)>0?$hddid:1);
			$this->PfadzumAusgeben = $this->config["HDD"][$this->HDDID]["HDDdir"];
			foreach ($this->config["HDD"][$this->HDDID] as $key => $value) {
				if(!(in_array($key,array ( "HDDdir", "Filme", "3D")))){
					if(!is_dir($this->PfadzumAusgeben.$value)){	return "   ".$this->Console->error("Pfad für Ausgabe exisitiert nicht!").PHP_EOL;        }
					else {									echo "    Verzeichnis ".$this->PfadzumAusgeben.$value." wird für ".$key." als Ausgabe verwendet".PHP_EOL;	}
				}
			}
			echo PHP_EOL;
				
			echo "Starte verarbeitung der Filme:".PHP_EOL.PHP_EOL;
			$FilmeArr = array();
			$this->FolderArray = array();
			if(($action == "einlesen")){
				$FilmeArr = $this->dirtoArray($this->PfadzumEinlesen."/");
			}else{
				$this->dirtoArray($this->PfadzumAusgeben."Serien/");
			}
				
			$fehlerArr = array("");
			$Counter=0;
			var_dump($FilmeArr);
			exit;
			foreach ($FilmeArr as $value) {
				$array = $this->parseEpisode($value[2].(strlen($value[0])>0?'/':''), $value[1],$action);
				
				
				
				var_dump($array);
				
				
				// Statistik Ausgabe
				$end = time();
				if(abs($end-$endLast)<10){
					$korrektor++;
				}
				$endLast = $end;
				$Counter++;
				$laufzeit = $end - $start;
				$H = floor($laufzeit / 3600);
				$i = ($laufzeit / 60) % 60;
				$s = $laufzeit % 60;
				$Durchschnitt = $laufzeit/($Counter);
				$Hd = floor($Durchschnitt / 3600);
				$id = ($Durchschnitt / 60) % 60;
				$sd = $Durchschnitt % 60;
				if(($Counter-$korrektor)>0){
					$Durchschnittk = $laufzeit/($Counter-$korrektor);
					$Hdk = floor($Durchschnittk / 3600);
					$idk = ($Durchschnittk / 60) % 60;
					$sdk = $Durchschnittk % 60;
				}
				
				$status =  "Laufzeit: ".sprintf("%02d:%02d:%02d", $H, $i, $s).
				"(Pro Film:  ".sprintf("%02d:%02d:%02d", $Hd, $id, $sd).   " (".$Counter.' von '.count($FilmeArr)."))".(($Counter-$korrektor)>0?
						"(korrigiert:".sprintf("%02d:%02d:%02d", $Hdk, $idk, $sdk)." (".($Counter-$korrektor).' von '.(count($FilmeArr)-$korrektor).")) ":"");
				echo $status.PHP_EOL.PHP_EOL;
				file_put_contents("./phpTestout/defaultSerien.txt", $status." ".$value[1].PHP_EOL.PHP_EOL, FILE_APPEND);
			}
					
			$end = time();
			$laufzeit = $end - $start;
			$H = floor($laufzeit / 3600);
			$i = ($laufzeit / 60) % 60;
			$s = $laufzeit % 60;
				
			$status =  "Gesamtlaufzeit: ".sprintf("%02d:%02d:%02d", $H, $i, $s)."! ".$Counter.' von '.count($FilmeArr).PHP_EOL.PHP_EOL;
			echo $status;
			file_put_contents("./phpTestout/defaultSerien.txt", $status.PHP_EOL, FILE_APPEND);
			
			
			
		}else{
			echo "Not Found!".PHP_EOL;
		}
	}
	/**
	 * @param imdbID
	 * @param DataArray
	 * @param 
	 * @param 
	 */private function gibTMDBdata($imdbID, &$DataArray){
		echo " Hole Daten von themoviedb.org... ";
		//TODO COVERDOWNLOAD und FANART für themovieDB
		$tmdb = $this->jsonCacheDecoder("https://api.themoviedb.org/3/find/tt".$imdbID."?external_source=imdb_id&api_key=".$this->config["ApiKeys"]['Tmdb_Key']."&language=de");
		if(!($tmdb == false)){
			if(isset($tmdb["movie_results"][0])){
				if(isset($tmdb["movie_results"][0]["overview"])){	
					echo " done!".PHP_EOL;
					$DataArray["summary"]=$tmdb["movie_results"][0]["overview"];
				}else{
					//echo " fail2!".PHP_EOL;
					echo  $this->Console->error("keine summary gefunden für imdbID ".$imdbID."!").PHP_EOL;
				}
				$tmdbURL="https://api.themoviedb.org/3/movie/".$tmdb["movie_results"][0]["id"]."?api_key=".$this->config["ApiKeys"]['Tmdb_Key']."&language=de&append_to_response=trailers";
				//echo $tmdbURL;
				$tmdbData1 = $this->jsonCacheDecoder($tmdbURL);
				if(!($tmdbData1 == false)){
					if(isset($tmdbData1["title"])){				$DataArray["titelDeutsch"] = $tmdbData1["title"]; }
					if(isset($tmdbData1["original_title"])){	$DataArray["titelOriginal"] = $tmdbData1["original_title"];}
					if(isset($tmdbData1["tagline"])){			$DataArray["tagline"] = $tmdbData1["tagline"];}
					if(isset($tmdbData1["belongs_to_collection"]["name"])){			
						$DataArray["collection"] = $tmdbData1["belongs_to_collection"]["name"];
						$DataArray["collection"] = str_replace("Filmreihe", "", $DataArray["collection"]);
						$DataArray["collection"] = str_replace(":", "", $DataArray["collection"]);
						$DataArray["collection"] = str_replace("Reihe", "", $DataArray["collection"]);
						$DataArray["collection"] = str_replace("/", "", $DataArray["collection"]);
						$DataArray["collection"] = str_replace("Immer Ärger mit 40", "", $DataArray["collection"]);
						$DataArray["collection"] = str_replace("Immer Ärger mit 40", "", $DataArray["collection"]);
						$DataArray["collection"] = str_replace("()", "o", $DataArray["collection"]);
						$DataArray["collection"] = str_replace("(Animiert)", "", $DataArray["collection"]);
						$DataArray["collection"] = str_replace("Collection", "", $DataArray["collection"]);
					}
					if(isset($tmdbData1["trailers"]["youtube"][0]["source"])){
						//TODO youtube Key auf 11 Zeichen prüfen!!
						$youtubeDE = str_replace("&hd=1", "", $tmdbData1["trailers"]["youtube"][0]["source"]);
						if(strpos($youtubeDE,"youtube")>0){
							echo "doofer IFrame....!!!";
						}else{
							$DataArray["youtube"]= "DE:".$youtubeDE;
						}
						
					}else{
						$tmdbURL2="https://api.themoviedb.org/3/movie/".$tmdb["movie_results"][0]["id"]."?api_key=".$this->config["ApiKeys"]['Tmdb_Key']."&language=en&append_to_response=trailers";
						$tmdbData2 = $this->jsonCacheDecoder($tmdbURL2);
						if(isset($tmdbData2["trailers"]["youtube"][0]["source"])){
							$youtubeEN = str_replace("&hd=1", "", $tmdbData2["trailers"]["youtube"][0]["source"]);
							if(strpos($youtubeEN,"youtube")>0){
								echo "doofer IFrame....!!!";
							}else{
								$DataArray["youtube"]= "EN:".$youtubeEN;
							}
						}
						else{
							echo  $this->Console->error("kein Trailer gefunden für imdbID ".$imdbID."!").PHP_EOL;
						}
					}
					return true;
				}else{return false;}
				
			}else{
				echo " fail1!".PHP_EOL;
				return false;
			}
		}else{
			return false;
		}
	}

	/**
	 * @param imdb
	 * @param fehler
	 * @return die FSK oder false
	 */private function gibFSK($imdb, $imdbID, &$fehler = "") {
		$fsktemp = $imdb->getCertification();
		$fskbool= false;
		if(!(strpos( $fsktemp,"Germany") === false)){
			$fsk = trim(substr($fsktemp,strpos( $fsktemp,"Germany")+8,2));
			if($fsk == "No"){
				$fsk = 18;
			}
			if(in_array($fsk, array(0, 6, 12,16,18))){
				$fskbool = true;
				return $fsk;
			}
		}
		if(!$fskbool){
			$fsk = "";
			//var_dump($fsktemp);
			echo "	Hole Daten von altersfreigaben.de... ";
			$fsk2 = file_get_contents("https://altersfreigaben.de/api2/s/tt".$imdbID."/de");
			echo $fsk2;
			echo " done!".PHP_EOL;
			if (in_array($fsk2, array(0, 6, 12,16,18))){
				$fsk = $fsk2;
				return $fsk2;
				$fskbool = true;
			}else{
				$fehler .=  $this->Console->error("keine fsk gefunden für imdbID ".$imdbID."!").PHP_EOL; 
				$fsk = "";
				return false;
				$counterNotFound++;
			}
		}
		//return $counterNotFound;
	}
	private function parseEpisode($Pfad, $Filename, $minimal = "nfo"){
		
		if(is_file($Pfad.$Filename)){
			echo "Datei: ".$Pfad." > ".$Filename.PHP_EOL;
			
			if(!(stripos( $Pfad,"(") == false)){
				$array["imdbID"] = substr($Pfad,stripos( $Pfad,"(")+1,7);
			}else{return false;}
			for ($i = 0; $i < strlen($Filename)-3; $i++) {
				//
				if((strtoupper(substr($Filename,$i,1))=="S") AND (strtoupper(substr($Filename,$i+3,1))=="E")){
					//echo "Compare1: ".substr($Filename,$i,1)." ".substr($Filename,$i+3,1).PHP_EOL;
					$array["Season"] = substr($Filename,$i+1,2);
					$array["Episode"] = substr($Filename,$i+4,2);
				}
				//
				if((strtoupper(substr($Filename,$i,1))=="S") AND (strtoupper(substr($Filename,$i+4,1))=="E")){
					//echo "Compare2: ".substr($Filename,$i,1)." ".substr($Filename,$i+4,1).PHP_EOL;
					$array["Season"] = substr($Filename,$i+1,2);
					$array["Episode"] = substr($Filename,$i+5,2);
				}
			}
			echo "imdbID: ".$array["imdbID"].">".$array["Season"].">".$array["Episode"].PHP_EOL;
			
			
			return $array;
		}
	}
	private function parseMovie($Pfad, $Filename, $minimal = "nfo"){
		/*TODO mehrere Sachen
		 * Auf weitere Saplten die für nfo gebraucht werden erweitern
		 * 
		 */	
		$PfadOrg = $Pfad;
		$Pfad = $Pfad;
		if(is_file($Pfad.$Filename)){
			$array = array();
			$FilenameOrg = $Filename;
			echo $Pfad.$FilenameOrg.PHP_EOL;
			
			$array["hdd"] = $this->HDDID;
			if(strpos($Filename, "(3D)")>0){
				$Filename = str_replace("(3D)", "", $Filename);
				$array["3d"] = "ja";
			}
			else{ $array["3d"] = ""; }
			if(strpos($Filename, "(720p)")>0){
				$Filename = str_replace("(720p)", "", $Filename);
				$array["resolution"] = "720p";
			}
			else if(strpos($Filename, "(1080p)")>0){
				$Filename = str_replace("(1080p)", "", $Filename);
				$array["resolution"] = "1080p";
			}
			else if(strpos($Filename, "(SD)")>0){
				$Filename = str_replace("(SD)", "", $Filename);
				$array["resolution"] = "SD";
			}
			if(!(strripos( $Filename,"(") == false)){
				$array["imdbID"] = substr($Filename,strripos( $Filename,"(")+1,7);
			}
			//
			if(!isset($array["imdbID"])){  //strlen($array["imdbID"])<=2
				file_put_contents("./phpTestout/default.txt", "Keine imdbID in Dateinamen: ".$Pfad.$Filename." gefunden!".PHP_EOL, FILE_APPEND);
				return false;
			}
			$array["name"]   = trim(substr($Filename, 0, strripos( $Filename,"(")));
			//TODO wird hier nicht gebraucht?
			//$Endung = trim(substr($Filename,strripos( $Filename,".")+1));
			if(!($minimal =="nfo")){
				if(($minimal =="check") OR ($minimal =="einlesen")){	
					echo " Hole Daten von imdb... ";
				// Werte aus IMdb Auslesen...
					$imdb = new IMDB("http://www.imdb.com/title/tt".$array["imdbID"]."/");
					if ($imdb->isReady) {
						echo " done!".PHP_EOL;
						$array["year"] = $imdb->getYear();
						$array["rating"] = $imdb->getRating();
						
						$array["Genre"] = $imdb->getGenre();
						$Schauspieler = $imdb->getCastAsOwn(0, false);
						$SchauspielerRole = $imdb->getCastAndCharacter(0, false);//ALT:$imdb->getCastAsOwn(0, false);
						
						
						$Schauspieler = explode("/", str_replace("nm", "", $Schauspieler));
						$SchauspielerRole = explode("/",  $SchauspielerRole);
						foreach ($SchauspielerRole as $value) {
							if(!(strpos($value, "as") == false)){
								$value = explode("as", $value);
								$value[1] = str_replace("(uncredited)", "", $value[1]);
								if(substr($value[1], -1) == "("){
									$value[1] =substr($value[1],0, -1);
								}
								$SchauspielerRollen[trim($value[0])] = trim($value[1]);
							}
						}
						
						
						foreach ($Schauspieler as $value) {
							if(!(strpos($value, ">") == false)){
								$value = explode(">", $value);
								//$Schauspieler[trim($value[0])] = array(trim($value[1]),trim(array_search(trim($value[1]), $SchauspielerRollen)));
								$rolname= (isset($SchauspielerRollen[trim($value[1])])?$SchauspielerRollen[trim($value[1])]:"");
								$array["Schauspieler"][trim($value[0])] = array(trim($value[1]),trim($rolname));// TODO isset hinzufügen (wegen notice meldung)
							}
						}

						$array["fsk"] = $this->gibFSK ($imdb,$array["imdbID"]);
						if ($array["fsk"] == false){
							unset($array["fsk"]);
						}
						if(!$this->gibTMDBdata ( $array["imdbID"], $array)){
							file_put_contents("./phpTestout/imdbID/".$array["imdbID"].".txt", "Keine Infos auf TMDB gefunden: ".$Pfad.$FilenameOrg.PHP_EOL, FILE_APPEND);
							return false;  //TODO Abbruch wenn keine Daten auf TMDB gefunden
						}
					} else{
						echo $this->Console->error("imdbID (".$array["imdbID"].") nicht bei imdb gefunden!").PHP_EOL;
						file_put_contents("./phpTestout/imdbID/".$array["imdbID"].".txt", "Keine Infos auf imdbID gefunden: ".$Pfad.$FilenameOrg.PHP_EOL, FILE_APPEND);
						return false;
					}
				}
				
				if(($minimal =="checkfile") OR ($minimal =="einlesen")){
				// werte von MediaInfo holen...
					echo " Hole Daten von mediainfo... ";
					$array["size"] = $this->getfileSize($Pfad.$FilenameOrg);
					if(!file_exists('/tmp/'.$array["imdbID"].(!$array["3d"]==""?"3d":"").'.xml')){
						$befehl = 'mediainfo --Output=XML "'.$Pfad.$FilenameOrg.'" > /tmp/'.$array["imdbID"].(!$array["3d"]==""?"3d":"").'.xml';
						exec($befehl);
					}
					$xmlstring = file_get_contents('/tmp/'.$array["imdbID"].(!$array["3d"]==""?"3d":"").'.xml'); //TODO Testen ob 3d Geht....
					$xml = simplexml_load_string($xmlstring);
					$json = json_encode($xml,JSON_PRETTY_PRINT);
					$array2 = json_decode($json,TRUE);
					foreach ($array2["File"]["track"] as $key => $value) {
						//echo " ".$key." ".$value["@attributes"]["type"].PHP_EOL;
						switch ($value["@attributes"]["type"]) {
							case "General":
								$array["vcodec"] = str_replace("Matroska", "mkv", $value["Format"]);
								$array["duration"] = $this->getRunTime($value["Duration"]);
								$array["totalbitrate"] = round(trim(str_replace(" ", "",str_replace("Mbps", "", $value["Overall_bit_rate"])))*1024,0);
								break;
							case "Video":
								$array["width"] = trim(str_replace(" ", "",str_replace("pixels", "",$value["Width"])));
								//TODO Resolution aus diesen werten neusetzen
								$array["height"] = trim(str_replace(" ", "",str_replace("pixels", "",$value["Height"])));
								break;					
							case "Audio":
								if(isset($value["Language"])){
									if(($value["Language"] == "Deutsch") OR ($value["Language"] == "German")){
										$array["acodecger"] = $value["Format"];
										$array["abitrateger"] = round(trim(str_replace(" ", "",str_replace("Kbps", "",$value["Bit_rate"]))),0);
										$array["channelsger"] = str_replace(" channels", "",$value["Channel_s_"]);
										if(!is_numeric($array["channelsger"])){
											$array["channelsger"] = substr($array["channelsger"],strripos( $array["channelsger"],"/")+1);
											if(!is_numeric($array["channelsger"])){
												echo $this->Console->error("channelsger ist nicht Numerisch!").PHP_EOL;
												file_put_contents("./phpTestout/imdbID/".$array["imdbID"].".txt", "channelsger ist nicht Numerisch!".PHP_EOL, FILE_APPEND);
												return false;
											}
										}
									}
									else if(($value["Language"] == "Englisch") OR ($value["Language"] == "English")){
										$array["acodeceng"] = $value["Format"];
										$array["abitrateeng"] = round(trim(str_replace(" ", "",str_replace("Kbps", "",$value["Bit_rate"]))),0);
										$array["channelseng"] = str_replace(" channels", "",$value["Channel_s_"]);
										if(!is_numeric($array["channelseng"])){
											$array["channelseng"] = substr($array["channelseng"],strripos( $array["channelseng"],"/")+1);
											if(!is_numeric($array["channelseng"])){
												echo $this->Console->error("channelseng ist nicht Numerisch!").PHP_EOL;
												file_put_contents("./phpTestout/imdbID/".$array["imdbID"].".txt", "channelseng ist nicht Numerisch!".PHP_EOL, FILE_APPEND);
												return false;
											}
										}
									}
								}
								break;
						}
					}
					echo " done!".PHP_EOL;
				}
			}
			foreach ($array as $key => $value) {
				if((($value == 'n/A') OR ($value == false)) AND !($Key = '3d')){
					unset($array[$key]);
					echo "Lösche: ".$key.PHP_EOL;
				}
			}
			return $array;
		}else{
			echo $this->Console->error("Datei Existiert nicht!").PHP_EOL;
			file_put_contents("./phpTestout/default.txt", "Datei existiert nicht: ".$Pfad.$Filename.PHP_EOL, FILE_APPEND);
			return false;
		}
	}
	private function GenerateNFO($DataArr, $File){
		$nfoFile = substr($File,0,strripos($File,".")).".nfo"; // Echte NFO Ausgabe Pfad
		//$nfoFile = str_replace("/media/QNAP/Filme", "/home/osmc/MediaDBPythonScripte/phpTestout/nfo", $nfoFile); // nur für Testausgaben drin....
		$Query = "SELECT *,".
					"(SELECT GROUP_CONCAT( g.gername SEPARATOR '|' ) FROM FilmGenre fg JOIN Genre g ON g.genreID = fg.genreID WHERE fg.imdbID = '".$DataArr['imdbID']."' ) AS Genre,".
					"(SELECT GROUP_CONCAT(s.name SEPARATOR '|') FROM FilmSchauspieler fs JOIN Schauspieler s ON s.schauspielerID = fs.schauspielerID WHERE fs.imdbID = '".$DataArr['imdbID']."' ) AS Schauspieler".
				" FROM Filme WHERE imdbID = '".$DataArr['imdbID']."' AND 3d ".(!($DataArr['3d']=="")?"!=":"=").'""';
		//echo $Query.PHP_EOL;
		
		echo "Generiere NFO Datei für ".$DataArr['imdbID']." ...";
		$mysqli = new mysqli($this->config["DB_Server"],$this->config["DB_Username"],$this->config["DB_Passwort"],$this->config["DB_Database"]);
		if($mysqli->connect_error != ""){		echo "Mysql-Fehler: ".$mysqli->connect_error.PHP_EOL; return false;}
		$mysqli->query("SET NAMES 'utf8'");
		
		
		$result = $mysqli->query($Query);
		if($mysqli->error != ""){		echo "Mysql-Fehler: ".$mysqli->error.PHP_EOL; return false;}
		if($result->num_rows==1){
			$Film = $result->fetch_assoc();
			
			
			//$mediaDBurl = "http://mediadb.ivaya.de/api.php?key=".$this->config["ApiKeys"]['MediaDB_Key']."&action=GetDataList&Tabelle=Filme&Spalten=imdbID,Genre,Schauspieler&imdbID=".$Film["imdbID"];
			//echo $mediaDBurl.PHP_EOL;
			//$mediaDB = $this->jsonCacheDecoder($mediaDBurl);
			
			$co	= '<?xml version="1.0" encoding="UTF-8" standalone="yes" ?>'.PHP_EOL;
			$co.= '<movie>'.PHP_EOL;
			$co.= '    <title>'.(strlen($Film['titelDeutsch'])>0?$Film['titelDeutsch']:$Film['name']).'</title>'.PHP_EOL;
			$co.= '    <originaltitle>'.$Film['titelOriginal'].'</originaltitle>'.PHP_EOL;
			if(!(strlen($Film['collection']) ==0)){
				$co.= '    <sorttitle>'.$Film['name'].'</sorttitle>'.PHP_EOL;
				$co.= '    <set>'.$Film['collection'].'</set>'.PHP_EOL;
					
			}
			$co.= '    <rating>'.$Film['rating'].'</rating>'.PHP_EOL;
			$co.= '    <year>'.$Film['year'].'</year>'.PHP_EOL;
			$co.= '    <plot>'.$Film['summary'].'</plot>'.PHP_EOL;
			$co.= '    <tagline>'.$Film['tagline'].'</tagline>'.PHP_EOL;
			$co.= '    <runtime>'.($Film['duration']/60).'</runtime>'.PHP_EOL;
			if(file_exists($this->config["CoverDir"]."Filme/full/".$Film["imdbID"].".jpg")){
				$co.= '    <thumb aspect="poster" preview="http://mediadb.ivaya.de/cover/Filme/high/'.$Film['imdbID'].'.jpg">'.
						'http://mediadb.ivaya.de/cover/Filme/high/'.$Film['imdbID'].'.jpg</thumb>'.PHP_EOL;
			}
			if(file_exists($this->config["CoverDir"]."Filme/background/".$Film["imdbID"].".jpg")){
				$co.= '    <fanart>'.PHP_EOL;
				$co.= '        <thumb preview="http://mediadb.ivaya.de/cover/Filme/background/'.$Film['imdbID'].'.jpg">'.
						'http://mediadb.ivaya.de/cover/Filme/background/'.$Film['imdbID'].'.jpg</thumb>'.PHP_EOL;
				$co.= '    </fanart>'.PHP_EOL;
			}
			if(isset($DataArr['fsk'])){
				$co.= '    <mpaa>FSK '.$Film['fsk'].'</mpaa>'.PHP_EOL;
			}
			$co.= '    <playcount>'.$Film['views'].'</playcount>'.PHP_EOL;
			$co.= '    <lastplayed>'.$Film['lastView'].'</lastplayed>'.PHP_EOL;
			$co.= '    <id>tt'.$Film['imdbID'].'</id>'.PHP_EOL;
			$genre = explode("|", $Film['Genre']);
			foreach ($genre as $value) {
				$co.= '        <genre>'.$value.'</genre>'.PHP_EOL;
			}
			if(!(strlen($Film['youtube']) ==0)){
				$youtube = explode(":", $Film['youtube']);
				$co.= '    <trailer>plugin://plugin.video.youtube/?action=play_video&amp;videoid='.$youtube[1].'</trailer>'.PHP_EOL;
			}
			// <fileinfo> .....
			
			$counter = 0;
			$schauspieler = explode("|", $Film['Schauspieler']);
			foreach ( $schauspieler as $value) {
				$co.= '    <actor>'.PHP_EOL;
				$co.= '        <name>'.$value.'</name>'.PHP_EOL;
				$co.= '        <order>'.$counter.'</order>'.PHP_EOL;
				$co.= '    </actor>'.PHP_EOL;
				$counter++;
			}
			
			
			$co.= '    <dateadded>'.$Film['added'].'</dateadded>'.PHP_EOL;
			
			
			$co.= '</movie>'.PHP_EOL;
			file_put_contents($nfoFile, $co);
			echo " Done!!".PHP_EOL;
			
		}
	}
	private function updateMovie($DataArr, $File, $md5 = true, $CheckOnly=true){
		
		
		$mysqli = new mysqli($this->config["DB_Server"],$this->config["DB_Username"],$this->config["DB_Passwort"],$this->config["DB_Database"]);
		if($mysqli->connect_error != ""){		echo "Mysql-Fehler: ".$mysqli->connect_error.PHP_EOL; return false;}
		$mysqli->query("SET NAMES 'utf8'");
		
		$Query = "SELECT * FROM Filme WHERE imdbID = '".$DataArr['imdbID']."' AND 3d ".(!($DataArr['3d']=="")?"!=":"=").'""';
		$result = $mysqli->query($Query);
		if($mysqli->error != ""){		echo "Mysql-Fehler: ".$mysqli->error.PHP_EOL; return false;}
		if($result->num_rows==1){
			$Film = $result->fetch_assoc();
			
			// Jetzt noch MD5 berechnen
			if($md5){
				if(strtotime($Film["lastUpdate"])>=time()-(30*24*60*60)){
					echo "Film wurde innerhalb der jetzten 30 Tage Aktualisiert (md5 Prüfung)!".PHP_EOL;
					return false;
				}
				//var_dump($DataArr);
				echo " Berechne MD5... ";
				$DataArr["md5"] = substr(shell_exec('md5sum -b "'.$File.'"'),0,32);
				file_put_contents("./phpTestout/imdbID/".$DataArr['imdbID'].".txt", "md5 = ".$DataArr["md5"].PHP_EOL, FILE_APPEND);
				$DataArr["lastUpdate"] = date("Y-m-d");
				echo " done!".PHP_EOL;
			}
			
			$changed = "";
			$first = true;
			$update = "";
			
			foreach ($DataArr AS $key=> $value){
				if(!in_array($key, array("Schauspieler", "Genre", "3d")) AND !in_array($value,array("n/A", ""))){
					if(!(md5(trim($Film[$key])) == md5(trim($DataArr[$key])))) {
						$update .= " ".($first?"":",").trim($key)." = '".mysql_escape_string(trim($value))."'";
						$first = false;
						$changed .= "  ".$key." old: ".trim($Film[$key]).PHP_EOL;
						$changed .= "  ".$key." new: ".trim($DataArr[$key]).PHP_EOL;
					}
				}
			}
			//var_dump($DataArr["Schauspieler"]);
			//TODO Update für Schauspieler role einbauen 
			$SQL = "SELECT * FROM FilmSchauspieler WHERE imdbID = ".$DataArr['imdbID'];
			$entrys = $mysqli->query($SQL);
			echo " Update Schauspielerrollennamen ...";
			while($entry = $entrys->fetch_array()){
				//var_dump($entry);
				//var_dump(array_search($entry["schauspielerID"], $DataArr["Schauspieler"]));
				//var_dump($DataArr["Schauspieler"][$entry["schauspielerID"]]);
				//exit;
				//$newSchauspieler = array_search($entry["schauspielerID"], $DataArr["Schauspieler"]);
				
				//echo "Vergleiche:".$entry["role"]." mit ".$DataArr["Schauspieler"][$entry["schauspielerID"]][1].PHP_EOL;
				if(isset($DataArr["Schauspieler"][$entry["schauspielerID"]][1])){
					if(!($entry["role"] == $DataArr["Schauspieler"][$entry["schauspielerID"]][1])){
						//var_dump($newSchauspieler);
						$SQL =  "UPDATE FilmSchauspieler SET role='".$mysqli->real_escape_string($DataArr["Schauspieler"][$entry["schauspielerID"]][1]).
							"' WHERE imdbID = '".$entry["imdbID"]."' AND schauspielerID ='".$entry["schauspielerID"]."';";
						
						file_put_contents("./phpTestout/updateSchauspieler.sql", $SQL.PHP_EOL, FILE_APPEND);
					}
				}
				
				//exit;
					
			}
			echo "done!".PHP_EOL;
			
				
			
			
			
			
			//exit;
			//$fehlerglobal .= $fehler;
			//echo $fehler;
			if(!$first){
				//$SQL = "UPDATE Filme SET".$update." WHERE imdbID = '".$Film["imdbID"]."';";
				$SQL = "UPDATE Filme SET".$update." WHERE imdbID = '".$Film["imdbID"]."' AND 3d ".(!$DataArr['3d']==""?"!=":"=").'"";';
				//$counterChange++;
				if(!$CheckOnly){
					 $Ausgabe = " Ändere (bei ".$Film["imdbID"].") :".PHP_EOL.$changed.PHP_EOL;
					 echo $Ausgabe;
					//echo $SQL.PHP_EOL;
					$mysqli->query($SQL);
					file_put_contents("./phpTestout/imdbID/".$DataArr['imdbID'].".txt", $SQL.PHP_EOL, FILE_APPEND);
					file_put_contents("./phpTestout/update.txt", $SQL.PHP_EOL, FILE_APPEND);
					
				}else{
					 $Ausgabe= "Unterschiede (bei ".$Film["imdbID"].") :".PHP_EOL.$changed.PHP_EOL;
					echo $Ausgabe;
					file_put_contents("./phpTestout/imdbID/".$DataArr['imdbID'].".txt", $Ausgabe.PHP_EOL.$SQL.PHP_EOL, FILE_APPEND);
					file_put_contents("./phpTestout/update_CheckOnly.txt", $Ausgabe." ".$SQL.PHP_EOL.PHP_EOL, FILE_APPEND);
					file_put_contents("./phpTestout/update.sql", $SQL.PHP_EOL, FILE_APPEND);
				}
				echo PHP_EOL;
				return true;
			}else {
				if(!$CheckOnly){
					file_put_contents("./phpTestout/update.txt",		   "Alles OK bei Film ".$Film["name"]."(".$Film["imdbID"].")!".PHP_EOL, FILE_APPEND);
				}else{
					file_put_contents("./phpTestout/update_CheckOnly.txt", "Alles OK bei Film ".$Film["name"]."(".$Film["imdbID"].")!".PHP_EOL, FILE_APPEND);
				}
				file_put_contents("./phpTestout/imdbID/".$DataArr['imdbID'].".txt", "Alles OK bei Film ".$Film["name"]."(".$Film["imdbID"].")!".PHP_EOL, FILE_APPEND);
				return false;
			}
		
		}else{
			echo $this->Console->error("Film Existiert nicht in der Datenbank!!").PHP_EOL;
			return false;
		}
	}
	
	private function addMovie($DataArr, $File, $md5 = true){
		
		$mysqli = new mysqli($this->config["DB_Server"],$this->config["DB_Username"],$this->config["DB_Passwort"],$this->config["DB_Database"]);
		if($mysqli->connect_error != ""){		echo "Mysql-Fehler: ".$mysqli->connect_error.PHP_EOL; return false;}
		$mysqli->query("SET NAMES 'utf8'");
		$Query = "SELECT imdbID FROM Filme WHERE imdbID = '".$DataArr['imdbID']."' AND ".
				'3d '.($DataArr['3d']?"!=":"=").'""';
		//echo $Query.PHP_EOL;
		$result = $mysqli->query($Query);
		
		if($mysqli->error != ""){		echo "Mysql-Fehler: ".$mysqli->error.PHP_EOL; return false;}
		if($result->num_rows>0){
			echo " Film bereits in DB!".PHP_EOL;
			file_put_contents("./phpTestout/imdbID/".$DataArr['imdbID'].".txt", "Film bereits in DB!".PHP_EOL, FILE_APPEND); 
			return false;
		}
		// Jetzt noch MD5 berechnen
		if($md5){
			echo " Berechne MD5... ";
			$DataArr["md5"] = substr(shell_exec('md5sum -b "'.$File.'"'),0,32);
			file_put_contents("./phpTestout/imdbID/".$DataArr['imdbID'].".txt", "md5 = ".$DataArr["md5"].PHP_EOL, FILE_APPEND);
			$DataArr["lastUpdate"] = date("Y-m-d");
			echo " done!".PHP_EOL;
		}
		
		// und Jetzt Querys Bauen und Ausführen...
		$Querys= array();
		$keys = array("views", "checked", "comment", "added");
		$values = array(0, "null", "''", "'".date("Y-m-d")."'");
		
		foreach ($DataArr as $key => $value) {
			if(in_array($key, array("Genre", "Schauspieler")) ){
				if ($key == "Genre"){
					$genreArr = explode(" / ", $value);
					echo " Genre anlegen... ";
					foreach ($genreArr as $value2) {
						$Querys[] =  "INSERT INTO FilmGenre (imdbID, genreID) VALUES ('".$DataArr['imdbID']."', '".$this->getGenreID($mysqli, $value2)."');";
					}
					echo "done".PHP_EOL;
				}
				else if ($key == "Schauspieler"){
					//$Schauspielers = explode(" / ", $value);
					
					echo " Schauspieler anlegen... ";
					foreach ($value as $Key => $value3) {
						//$Schauspieler = explode(">", str_replace("nm", "", $value3));
						
						$Querys[] = "INSERT INTO FilmSchauspieler (imdbID, schauspielerID, role) 
								VALUES ('".$DataArr['imdbID']."', '".$this->getSchauspielerID($mysqli, $value3[0],$Key)."', '".$mysqli->real_escape_string($value3[1])."');";
						// TODO Rolle Ergänzen!!!!!
						
						
					}
					
					echo "done".PHP_EOL;
				}
			}else{
				$keys[] = trim($key);
				$values[] = "'".mysql_escape_string(trim($value))."'";  //TODO ggf. utf8_encode einbauen?!
			}
		}
		echo " Film eintragen... ";
		$Query = "INSERT INTO Filme (".implode(",", $keys).") VALUES (".implode(",", $values).");";
		//var_dump($Querys);
		//echo $Query.PHP_EOL;
		//exit;
		$result = $mysqli->query($Query);
		file_put_contents("./phpTestout/imdbID/".$DataArr['imdbID'].".txt", $Query.PHP_EOL, FILE_APPEND);
		if($mysqli->error != ""){
			echo "Mysql-Fehler: ".$mysqli->error.PHP_EOL;
			file_put_contents("./phpTestout/imdbID/".$DataArr['imdbID'].".txt", "Mysql-Fehler: ".$mysqli->error.PHP_EOL, FILE_APPEND);
			return false;
		}
		echo "done".PHP_EOL;
		//echo $this->Console->getColoredString("Query", "light_gray", "green")." ".$Query.PHP_EOL;
		
		echo " Lege FilmSchauspieler und FilmGenre Verküpfungen an...";
		foreach ($Querys as $Query) {
			//echo $this->Console->getColoredString("Query", "light_gray", "green")." ".$Query.PHP_EOL;
			
			$result = $mysqli->query($Query);
			file_put_contents("./phpTestout/imdbID/".$DataArr['imdbID'].".txt", $Query.PHP_EOL, FILE_APPEND);
			if($mysqli->error != ""){		
				echo "Mysql-Fehler: ".$mysqli->error.PHP_EOL; 
				file_put_contents("./phpTestout/imdbID/".$DataArr['imdbID'].".txt", "Mysql-Fehler: ".$mysqli->error.PHP_EOL, FILE_APPEND);
				return false;
			}
			
		}
		echo "done!".PHP_EOL;
		$mysqli->close();
		return true;
	}
	private function getGenreID($mysqli, $GenreName){ 
		$GenreName = $mysqli->real_escape_string($GenreName);
		$result = $mysqli->query("SELECT genreID FROM Genre WHERE engname = '".mysql_escape_string($GenreName)."'");
		if($mysqli->error != ""){		echo "Mysql-Fehler: ".$mysqli->error.PHP_EOL; return false;}
		if($result->num_rows>0){
			$resultArr = $result->fetch_array();
			//echo PHP_EOL.$this->Console->getColoredString("Genre Existiert", "light_gray", "green")." ".$result->num_rows.PHP_EOL;
			return $resultArr["genreID"];
		}
		else{
			$Query = "INSERT INTO Genre (engname) VALUES('".mysql_escape_string(($GenreName))."')";
			$mysqli->query($Query);
			return $mysqli->insert_id; //TODO nicht getestet Ob das überhaupt geht?! 
		}
	}
	private function getSchauspielerID($mysqli, $SchauspielerName, $SchauspielerID){
		//$SchauspielerName = $mysqli->real_escape_string($SchauspielerName);
		//$result = $mysqli->query("SELECT schauspielerID FROM Schauspieler WHERE name = '".mysql_escape_string(utf8_encode($SchauspielerName))."'");
		$result = $mysqli->query("SELECT schauspielerID FROM Schauspieler WHERE schauspielerID = '".$SchauspielerID."'");
		//echo "SELECT schauspielerID FROM Schauspieler WHERE name = '".$SchauspielerName."'".PHP_EOL;
		if($mysqli->error != ""){		echo "Mysql-Fehler: ".$mysqli->error.PHP_EOL; return false;}
		if($result->num_rows > 0){
			$resultArr = $result->fetch_array();
			//echo PHP_EOL.$this->Console->getColoredString("Schauspieler Existiert", "light_gray", "green")." ".$SchauspielerName.PHP_EOL;
			return $resultArr["schauspielerID"];
		}
		else{
			$Query = "INSERT INTO Schauspieler (name, schauspielerID) VALUES('".mysql_escape_string(($SchauspielerName))."', '".$SchauspielerID."');";
			//echo PHP_EOL.$this->Console->getColoredString("Query", "light_gray", "green")." ".$Query.PHP_EOL;
			//echo $SchauspielerName.", ";
			$mysqli->query($Query);
			//exit;
			return $SchauspielerID;
		}
	}
	private function getRunTime($laufzeit){
		$string = explode(" ", $laufzeit);
		return ((trim(str_replace("h", "", $string[0]))*3600)+(trim(str_replace("m", "", $string[1])*60)));
	}
	private function getfileSize($file){
		return trim(explode("/", exec('du -b "'.$file.'"'))[0]);
		
	}
	private function dirtoArray($dir, $root = ''){
		$Arr = scandir($dir);
		foreach ($this->config["FolderIgnor"] AS $value){
			unset($Arr[array_search($value, $Arr)]);
		}
		foreach ( $Arr AS $Key => $Value){
			if(is_dir ($dir.'/'.$Value) AND !in_array($Value, $this->config["FolderIgnor"])){
				$SubDir = $this->dirtoArray($dir.'/'.$Value, ($root==""?"":$root.'/').$Value);
				//echo PHP_EOL.$dir.'<>'.$Value."<>". ($root==""?"":$root.'/').$Value.PHP_EOL;
			}
			else{
				$Endung = trim(substr($Value,strripos( $Value,".")+1));
				if(!in_array($Endung, $this->config["FileEndungIgnor"]) ){	
					$this->FolderArray[] = array(str_replace("//", "/", $root), $Value, str_replace("//", "/", $dir));
					//echo "Füge hinzu: ".$dir."<>".$root."<>".$Value.PHP_EOL;
				}
			}
		}
		return $this->FolderArray;
	}
	private function jsonCacheDecoder($url){
		$CacheFolderName = "JsonCache/";
		
		$files = glob($CacheFolderName."*");
		$now   = time();
		
		foreach ($files as $file){
			if (is_file($file)){
				if (($now - filemtime($file) >= 60 * 60 * 24 * 1) OR (filesize($file) == 0)) {
					unlink($file);
				}
			}
		}
		if(!is_dir($CacheFolderName)){
			exec( "mkdir ".$CacheFolderName);
		}
		$filename= md5($url).".json"; //TODO Cachetime Ändern
		if(!file_exists($CacheFolderName.$filename)){
			$Data = file_get_contents($url);
			if(strlen($Data)>0){
				file_put_contents($CacheFolderName.$filename, file_get_contents($url));
			}else{
				return false;
			}
		}
		return json_decode(file_get_contents($CacheFolderName.$filename), true);
	}
	/**
	 * Cover download
	 */
	public function cover($type = "all"){
		echo $this->Console->getColoredString("Coverdownload > Filme", "black", "light_gray") .PHP_EOL;
		$start = time();
		$mysqli = new mysqli($this->config["DB_Server"],$this->config["DB_Username"],$this->config["DB_Passwort"],$this->config["DB_Database"]);
		if($mysqli->connect_error != ""){		echo "Mysql-Fehler: ".$mysqli->connect_error.PHP_EOL; return false;}
		$mysqli->query("SET NAMES 'utf8'");
		$Query = "SELECT imdbID FROM Filme GROUP BY imdbID;";
	
		$result = $mysqli->query($Query);
		if($mysqli->error != ""){		echo "Mysql-Fehler: ".$mysqli->error.PHP_EOL; return false;}
		$counterNotFound = 0;
		//shell_exec("rm ".$this->config["CoverDir"]."Filme/full/*");
		// Ordnerstruktur
		if(!is_dir($this->config["CoverDir"]."Filme")){
			shell_exec("mkdir ".$this->config["CoverDir"]);
			shell_exec("mkdir ".$this->config["CoverDir"]."Filme");
			shell_exec("mkdir ".$this->config["CoverDir"]."Filme/full");
			shell_exec("mkdir ".$this->config["CoverDir"]."Filme/high");
			shell_exec("mkdir ".$this->config["CoverDir"]."Filme/low");
			shell_exec("mkdir ".$this->config["CoverDir"]."Filme/background");
		}
		while ($Film = $result->fetch_assoc()){
			//echo "imdbID = ".$Film["imdbID"].PHP_EOL;
			//echo $url.PHP_EOL;	
			if(!file_exists($this->config["CoverDir"]."Filme/full/".$Film["imdbID"].".jpg")){
				echo "  Lade Cover von Markus ....";
				$url = "http://mediadb.ddns.net/cover/Filme/full/".$Film["imdbID"].".jpg";
				//echo $url."<>wget ".$url." -O ".$this->config["CoverDir"].$Film["imdbID"].".jpg";
				shell_exec("wget ".$url." -O ".$this->config["CoverDir"]."Filme/full/".$Film["imdbID"].".jpg > /dev/null 2>&1"); //");//
				if(filesize($this->config["CoverDir"]."Filme/full/".$Film["imdbID"].".jpg")==0){
					echo " fail!".PHP_EOL."  Lade Cover von imdb/tmdb ....";
					$imdb = new IMDB("http://www.imdb.com/title/tt".$Film["imdbID"]."/");
					$url = $imdb->getPoster("big");
					if(strpos($url, "imdb-share")>3){
						$url =  "https://api.themoviedb.org/3/find/tt".$Film["imdbID"]."?external_source=imdb_id&api_key=".$this->config["ApiKeys"]['Tmdb_Key']."&language=de".PHP_EOL; //$this->config["ApiKeys"]['Tmdb_Key']
						$tmdb = $this->jsonCacheDecoder($url);
						if(isset($tmdb["movie_results"][0]["poster_path"])){
							$url = "https://image.tmdb.org/t/p/original".$tmdb["movie_results"][0]["poster_path"];
							shell_exec("wget ".$url." -O ".$this->config["CoverDir"]."Filme/full/".$Film["imdbID"].".jpg > /dev/null 2>&1");
							echo "done!".PHP_EOL;
						}else {
							//TODO 3. Quelle für cover einbauen
							echo " fail (Kein Cover gefunden)!".PHP_EOL;
							file_put_contents("./phpTestout/cover.txt", "Kein Cover für ".$Film["imdbID"].PHP_EOL, FILE_APPEND);
							$counterNotFound++;
						}
					}else{
						shell_exec("wget ".$url." -O ".$this->config["CoverDir"]."Filme/full/".$Film["imdbID"].".jpg"." > /dev/null 2>&1");
						echo "done !".PHP_EOL;
					}
				}
				else{
					echo " done!".PHP_EOL;
				}
			}
			//echo "geht1".PHP_EOL;
			if(filesize($this->config["CoverDir"]."Filme/full/".$Film["imdbID"].".jpg")>0){
				//echo "geht1.1".PHP_EOL;
				if(!file_exists($this->config["CoverDir"]."Filme/low/".$Film["imdbID"].".jpg")){
					//echo "geht1.2".PHP_EOL;
					/*echo "convert ".$this->config["CoverDir"]."Filme/full/".$Film["imdbID"].".jpg".
					 	" -bordercolor White -border 1 -fuzz 50%% -trim -bordercolor White +repage -resize 5000x150\> ".
					 	$this->config["CoverDir"]."Filme/low/".$Film["imdbID"].".jpg".PHP_EOL;*/
					shell_exec("convert ".$this->config["CoverDir"]."Filme/full/".$Film["imdbID"].".jpg".
					 	" -bordercolor White -border 1 -fuzz 50%% -trim -bordercolor White +repage -resize 5000x150\> ".
					 	$this->config["CoverDir"]."Filme/low/".$Film["imdbID"].".jpg");
				}
				if(!file_exists($this->config["CoverDir"]."Filme/high/".$Film["imdbID"].".jpg")){
					//echo "geht1.3".PHP_EOL;
					
					/*echo "  convert ".$this->config["CoverDir"]."Filme/full/".$Film["imdbID"].".jpg".
					 	" -bordercolor White -border 1 -fuzz 50%% -trim -bordercolor White +repage -resize 5000x600\> ".
					 	$this->config["CoverDir"]."Filme/high/".$Film["imdbID"].".jpg".PHP_EOL;*/
					shell_exec("  convert ".$this->config["CoverDir"]."Filme/full/".$Film["imdbID"].".jpg".
					 	" -bordercolor White -border 1 -fuzz 50%% -trim -bordercolor White +repage -resize 5000x600\> ".
					 	$this->config["CoverDir"]."Filme/high/".$Film["imdbID"].".jpg");
					//echo "geht1.3 danach".PHP_EOL;
				}
			}else {
				//echo "geht fehler rm".PHP_EOL;
				shell_exec("rm ".$this->config["CoverDir"]."Filme/full/".$Film["imdbID"].".jpg");
				
			}
			//echo "geht2".PHP_EOL;
			if(!file_exists($this->config["CoverDir"]."Filme/background/".$Film["imdbID"].".jpg")){
				echo "  Lade Hintergrundbild von fanart.tv ....";
				$Data = @file_get_contents("http://webservice.fanart.tv/v3/movies/tt".$Film["imdbID"]."?api_key=".$this->config["ApiKeys"]['Fanart_Key']);
				if(!($Data === false)){
					$fanart = json_decode($Data,true);
					if(isset($fanart["moviebackground"][0]["url"])){
						$url = $fanart["moviebackground"][0]["url"];
						shell_exec("wget ".$url." -O ".$this->config["CoverDir"]."Filme/background/".$Film["imdbID"].".jpg > /dev/null 2>&1");
						echo "done!".PHP_EOL;
					}else{
						echo "fail (Kein Hintergrundbild gefunden)!".PHP_EOL;
						file_put_contents("./phpTestout/cover.txt", "Kein Hintergrundbild für ".$Film["imdbID"]." auf fanart.tv".PHP_EOL, FILE_APPEND);
					}
				}else{
					echo "fail (Film nicht gefunden)!".PHP_EOL;
				}
				
				if(!file_exists($this->config["CoverDir"]."Filme/background/".$Film["imdbID"].".jpg")){
					echo "  Lade Hintergrundbild von themoviedb.org ....";
					$url =  "https://api.themoviedb.org/3/find/tt".$Film["imdbID"]."?external_source=imdb_id&api_key=".$this->config["ApiKeys"]['Tmdb_Key']."&language=de".PHP_EOL; //$this->config["ApiKeys"]['Tmdb_Key']
					$tmdb = $this->jsonCacheDecoder($url);
					if(isset($tmdb["movie_results"][0]["backdrop_path"])){
						$url = "https://image.tmdb.org/t/p/original".$tmdb["movie_results"][0]["backdrop_path"];
						shell_exec("wget ".$url." -O ".$this->config["CoverDir"]."Filme/background/".$Film["imdbID"].".jpg > /dev/null 2>&1");
						echo "done!".PHP_EOL;
					}else{
						echo "fail (Kein Hintergrundbild gefunden)!".PHP_EOL;
						file_put_contents("./phpTestout/cover.txt", "Kein Hintergrundbild für ".$Film["imdbID"]." auf tmdb.org".PHP_EOL, FILE_APPEND);
						$counterNotFound++;
					}
				}
			}
		}
		echo $this->Console->getColoredString("Coverdownload > Serien und Staffeln", "black", "light_gray") .PHP_EOL;
		$Query = "SELECT series_nr FROM Serien GROUP BY series_nr;";
	
		$result = $mysqli->query($Query);
		if($mysqli->error != ""){		echo "Mysql-Fehler: ".$mysqli->error.PHP_EOL; return false;}
		
		//shell_exec("rm ".$this->config["CoverDir"]."Serien/full/*");
		//shell_exec("rm ".$this->config["CoverDir"]."Staffeln/full/*");
		if(!is_dir($this->config["CoverDir"]."Serien")){
			shell_exec("mkdir ".$this->config["CoverDir"]);
			shell_exec("mkdir ".$this->config["CoverDir"]."Serien");
			shell_exec("mkdir ".$this->config["CoverDir"]."Serien/full");
			shell_exec("mkdir ".$this->config["CoverDir"]."Serien/low");
			shell_exec("mkdir ".$this->config["CoverDir"]."Staffeln");
			shell_exec("mkdir ".$this->config["CoverDir"]."Staffeln/full");
			shell_exec("mkdir ".$this->config["CoverDir"]."Staffeln/high");
			shell_exec("mkdir ".$this->config["CoverDir"]."Staffeln/low");
		}
		while ($Film = $result->fetch_assoc()){
			if(!file_exists($this->config["CoverDir"]."Serien/full/".$Film["series_nr"].".jpg")){
				echo "Lade Cover (".$Film["series_nr"].") von Markus ....";
				$url = "http://mediadb.ddns.net/cover/Serien/full/".$Film["series_nr"].".jpg";//1479358
				//echo $url."<>wget ".$url." -O ".$this->config["CoverDir"].$Film["imdbID"].".jpg";
				shell_exec("wget ".$url." -O ".$this->config["CoverDir"]."Serien/full/".$Film["series_nr"].".jpg > /dev/null 2>&1"); //");//
				if(filesize($this->config["CoverDir"]."Serien/full/".$Film["series_nr"].".jpg")>0){
					echo "done".PHP_EOL;
					
				}else{
					shell_exec("rm ".$this->config["CoverDir"]."Serien/full/".$Film["series_nr"].".jpg");
					echo "fail".PHP_EOL;
					$counterNotFound++;
				}
			}else{ echo "Cover für series_nr: ".$Film["series_nr"]." existiert bereits!".PHP_EOL;}
			if(file_exists($this->config["CoverDir"]."Serien/full/".$Film["series_nr"].".jpg") AND !file_exists($this->config["CoverDir"]."Serien/low/".$Film["series_nr"].".jpg")){
				shell_exec("convert ".$this->config["CoverDir"]."Serien/full/".$Film["series_nr"].".jpg".
						" -bordercolor White -border 1 -fuzz 50%% -trim -bordercolor White +repage -resize 5000x150\> ".
						$this->config["CoverDir"]."Serien/low/".$Film["series_nr"].".jpg");
			}
			$Query = "SELECT season_nr FROM Staffeln WHERE series_nr = ".$Film["series_nr"]." GROUP BY season_nr;";

			$result2 = $mysqli->query($Query);
			if($mysqli->error != ""){		echo "Mysql-Fehler: ".$mysqli->error.PHP_EOL; return false;}
					
			
			while ($Film2 = $result2->fetch_assoc()){
				if(!file_exists($this->config["CoverDir"]."Staffeln/full/".$Film2["season_nr"].".jpg")){
					echo "  Lade Cover (".$Film2["season_nr"].") von Markus ....";
					$url = "http://mediadb.ddns.net/cover/Staffeln/full/".$Film2["season_nr"].".jpg";
					//echo $url;
					shell_exec("wget ".$url." -O ".$this->config["CoverDir"]."Staffeln/full/".$Film2["season_nr"].".jpg > /dev/null 2>&1"); //");//
					if(filesize($this->config["CoverDir"]."Staffeln/full/".$Film2["season_nr"].".jpg")>0){
						echo "done".PHP_EOL;
						
					}else{
						shell_exec("rm ".$this->config["CoverDir"]."Staffeln/full/".$Film2["season_nr"].".jpg");
						echo "fail".PHP_EOL;
						$counterNotFound++;
					}
				}else{ echo "  Cover für season_nr: ".$Film2["season_nr"]." existiert bereits!".PHP_EOL;}
				if(file_exists($this->config["CoverDir"]."Staffeln/full/".$Film2["season_nr"].".jpg") AND !file_exists($this->config["CoverDir"]."Staffeln/low/".$Film2["season_nr"].".jpg")){
					shell_exec("convert ".$this->config["CoverDir"]."Staffeln/full/".$Film2["season_nr"].".jpg".
							" -bordercolor White -border 1 -fuzz 50%% -trim -bordercolor White +repage -resize 5000x150\> ".
							$this->config["CoverDir"]."Staffeln/low/".$Film2["season_nr"].".jpg");
					shell_exec("convert ".$this->config["CoverDir"]."Staffeln/full/".$Film2["season_nr"].".jpg".
							" -bordercolor White -border 1 -fuzz 50%% -trim -bordercolor White +repage -resize 5000x600\> ".
							$this->config["CoverDir"]."Staffeln/high/".$Film2["season_nr"].".jpg");
				}
			}
		}
		echo $this->Console->getColoredString("Coverdownload > Upload auf FTP Server", "black", "light_gray") .PHP_EOL;
		$SFTP_SERVER="192.168.0.32";
		$SFTP_USER="nico";
		$SFTP_PWD="1nico2%";
		shell_exec("lftp sftp://$SFTP_USER:$SFTP_PWD@$SFTP_SERVER  -e 'mirror --reverse ~/MediaDBPythonScripte/cover /var/www/mediadb.ivaya.de/MediaDBViewerAPI/cover; bye'");
		echo "Done!".PHP_EOL;

		$end = time();
		$laufzeit = $end - $start;
		$H = floor($laufzeit / 3600);
		$i = ($laufzeit / 60) % 60;
		$s = $laufzeit % 60;
	
		$status =  "Gesamtlaufzeit: ".sprintf("%02d:%02d:%02d", $H, $i, $s)."!".PHP_EOL.
		"	Nicht gefunden: ".$counterNotFound.PHP_EOL;
		echo $status;
		file_put_contents("./phpTestout/cover.txt", $status.PHP_EOL, FILE_APPEND);
	}
}