<?php
mb_internal_encoding("UTF-8");
class Media {
	private $Console;
	private $configfile;
	private $config;
	private $PfadzumEinlesen;
	private $PfadzumAusgeben;
	private $HDDID;
	private $FolderArray;
	public function __construct($configfile) {
		$this->Console = new Console();
		$this->configfile = $configfile;
		
		
		if(file_exists($configfile)){
			echo $this->Console->getColoredString("Hinweis:","black", "light_gray")." Configfile: ".$configfile." geladen!".PHP_EOL.PHP_EOL;
			$dateihandle = fopen($this->configfile,"r");
			$this->config = json_decode(fread($dateihandle, filesize($this->configfile)),true);
			
		}
		else{
			echo $this->Console->getColoredString("Hinweis:","black", "light_gray")." Configfile: ".$configfile." exisitiert nicht! Es werden defaults geladen!".PHP_EOL;
			echo "         Zum Anlegen der config bitte config save eingeben!".PHP_EOL.PHP_EOL;
			$this->config = array("configChangeTime" => time(),
							"ReadFromDir" => "/media/QNAP/FilmeZumEinlesen",
							"CoverDir" => "Cover/",
							"DB_Database" => "MediaDB_Nico",
							"DB_Username" => "MediaDB",
							"DB_Passwort" => "MediaDB",
							"DB_Server" => "192.168.0.32",
							"ApiKeys" => array(	"Fanart_Key" =>"9902c9197f457401ff7a7eba839213ba",
												"Tmdb_Key"   =>"b1ddcc7d16281ce09f692896f882ba9d"),
							"FolderIgnor" => array('.', '..', '.@__thumb', '@Recycle'),
							"FileEndungIgnor" => array('jpg', 'nfo'),
							"HDD" => array(1 => array("HDDdir" => "/media/QNAP/",
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/"),
											2 => array("HDDdir" => NULL,
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/"),
											3 => array("HDDdir" => NULL,
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/"),
											4 => array("HDDdir" => NULL,
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/"),
											5 => array("HDDdir" => NULL,
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/") 
			));
		}
	}
	public function config($Action){
		switch ($Action){
			case "show":
				echo $this->Console->error("Folgende Config ist geladen:","black").PHP_EOL.PHP_EOL;
				echo "Config erstellt: ".date("H:i:s d.m.Y ",$this->config["configChangeTime"])		.PHP_EOL;
				foreach ($this->config["HDD"] as $key => $value) {
					if($value["HDDdir"] != NULL){
						foreach ($value as $key2 => $value2) {
						echo "HDD ".$key.": ".$key2.": ".$value2.PHP_EOL;
						}
					}
				}
				echo PHP_EOL;
				break;
			case "save":
				echo $this->Console->error("Config gespeichert!", "green").PHP_EOL.PHP_EOL;
				$dateihandle = fopen($this->configfile,"w");
				fwrite($dateihandle, json_encode($this->config, JSON_PRETTY_PRINT));
				fclose($dateihandle);
				break;
			default:
				echo $this->Console->getColoredString("Kein Parameter für Config übergeben","red", "light_gray").PHP_EOL.PHP_EOL;
				
				break;
		}
	}
	public function filme($action = "einlesen"){
		$start = time();
		if(in_array($action, array( "einlesen","update", "check"))){
			//var_dump($this->config);
			echo $this->Console->getColoredString("Filme > ".$action, "black", "light_gray") .PHP_EOL;
			
			if($action == "einlesen"){
				echo "In welchen Verzeichnis liegen die einzulesenden Dateien? ( nur Enter = ".$this->config["ReadFromDir"].")" .PHP_EOL;
				$Pfad = trim(fgets(STDIN));
				$this->PfadzumEinlesen = (strlen($Pfad)>0?$Pfad:$this->config["ReadFromDir"]);
				if(!is_dir($this->PfadzumEinlesen)){
					return $this->Console->error("Pfad Eingabe exisitiert nicht!").PHP_EOL;
				}else {
					echo "    Verzeichnis ".$this->PfadzumEinlesen." wird für Eingabe verwendet".PHP_EOL;
				}
				echo PHP_EOL;
			}
			
			echo "Auf welche Festplatte sollen die Filme gespeichert werden \n bzw. Welche Festplatte soll überprüft bzw. upgedatet werden? ( nur Enter = 1)" .PHP_EOL;
			$hddid = trim(fgets(STDIN));
			$this->HDDID = (strlen($hddid)>0?$hddid:1);
			$this->PfadzumAusgeben = $this->config["HDD"][$this->HDDID]["HDDdir"];
			foreach ($this->config["HDD"][$this->HDDID] as $key => $value) {
				if(!($key == "HDDdir")){
					if(!is_dir($this->PfadzumAusgeben.$value)){	return "   ".$this->Console->error("Pfad für Ausgabe exisitiert nicht!").PHP_EOL;        }
					else {									echo "    Verzeichnis ".$this->PfadzumAusgeben.$value." wird für ".$key." als Ausgabe verwendet".PHP_EOL;	}
				}
			}
			echo PHP_EOL;
			
			echo "Starte verarbeitung der Filme:".PHP_EOL.PHP_EOL;
			$FilmeArr = array();
			$this->FolderArray = array();
			$FilmeArr = $this->dirtoArray((($action == "einlesen")?$this->PfadzumEinlesen:$this->PfadzumAusgeben."Filme/"));
			$fehlerArr = array("");
			$Counter=0;
			//var_dump($FilmeArr);
			foreach ($FilmeArr as $value) {
				//echo " ".$this->PfadzumEinlesen.'/'.(strlen($value[0])>0?$value[0].'/':'').$value[1].PHP_EOL;
				//echo (strlen($value[0])>0?$value[0].'/':''), $value[1].PHP_EOL;
				//$ParseFile = ">>>>>>".(($action == "einlesen")?$this->PfadzumEinlesen."/":$this->PfadzumAusgeben."Filme/").(strlen($value[0])>0?$value[0].'/':'').$value[1];
				//echo $ParseFile;
				
				$array = $this->parseMovie((($action == "einlesen")?$this->PfadzumEinlesen."/":$this->PfadzumAusgeben."Filme/").(strlen($value[0])>0?$value[0].'/':''), $value[1]);
				if($array == false){
					echo $this->Console->getColoredString("       ","black", "red").PHP_EOL;
					$fehler = $this->Console->getColoredString("Fehler!","black", "red")." ".$this->PfadzumEinlesen.'/'.(strlen($value[0])>0?$value[0].'/':'').$value[1].PHP_EOL;
					echo $fehler;
					$fehlerArr[] = $fehler;
					echo $this->Console->getColoredString("       ","black", "red").PHP_EOL;
				}else{
					
					//TODO Baustelle Start
					$Pfad = $this->PfadzumEinlesen.'/'.(strlen($value[0])>0?$value[0].'/':'');
					$PfadOrg = (strlen($value[0])>0?$value[0].'/':'');
					$FilenameOrg = $value[1];
					$Endung = trim(substr($FilenameOrg,strripos( $FilenameOrg,".")+1));
					//Was soll mit den geparsten Film gemacht werden?
					if($action == "einlesen"){
						if( $this->addMovie($array, (strlen($value[0])>0?$value[0].'/':'').$value[1], false)){  //TODO auf true für md5!!!
							if(($Pfad.$FilenameOrg) == ($this->PfadzumAusgeben.($array["3d"]==""?$this->config["HDD"][$this->HDDID]["Filme"]:$this->config["HDD"][$this->HDDID]["3D"]).$Pfad.$array["name"]." (".$array["resolution"].")".($array["3d"] != ""?" (3D)":"")." (".$array["imdbID"].").".$Endung)){
								echo "Datei liegt schon am ausgabe Ort!".PHP_EOL;
							}
							else{
									
								if(!is_dir($this->PfadzumAusgeben.($array["3d"]==""?$this->config["HDD"][$this->HDDID]["Filme"]:$this->config["HDD"][$this->HDDID]["3D"]).$PfadOrg)){
									shell_exec("mkdir '".$this->PfadzumAusgeben.($array["3d"]==""?$this->config["HDD"][$this->HDDID]["Filme"]:$this->config["HDD"][$this->HDDID]["3D"]).$PfadOrg."'");
								}
								echo "Verschiebe Datei...";
									
								$copy = 'mv "'.
										$Pfad.$FilenameOrg.'" "'.
										$this->PfadzumAusgeben.($array["3d"]==""?$this->config["HDD"][$this->HDDID]["Filme"]:$this->config["HDD"][$this->HDDID]["3D"]).$PfadOrg.$array["name"]." (".$array["resolution"].")".($array["3d"] != ""?" (3D)":"")." (".$array["imdbID"].").".$Endung.'"';
										file_put_contents("./phpTestout/".$array['imdbID'].".txt", $copy.PHP_EOL, FILE_APPEND);
										//shell_exec($copy);
										echo $copy."done!".PHP_EOL;
							}
							//TODO nfo file generieren
							shell_exec("mv './phpTestout/".$array["imdbID"].".txt' './phpTestout/OK_".$array["imdbID"].".txt'");
							//return true;
						
						}
						else{
							echo $this->Console->error("Fehler beim Eintragen in die DB!").PHP_EOL;
							file_put_contents("./phpTestout/".$array["imdbID"].".txt", "Fehler beim Eintragen in die DB".PHP_EOL, FILE_APPEND);
							//return false;
						}
					}else if($action == "update"){
						if( $this->updateMovie($array, (strlen($value[0])>0?$value[0].'/':'').$value[1], false, false)){  //TODO auf true für md5!!!
							echo "Film wurde Aktualisiert".PHP_EOL;
						}else {
							echo "Film wurde nicht Aktualisiert".PHP_EOL;
								
						}
					}else if($action == "check"){
						if( $this->updateMovie($array, (strlen($value[0])>0?$value[0].'/':'').$value[1], false, true)){  //TODO auf true für md5!!!
							echo "Film wurde geprüft".PHP_EOL;
								
						}
					}
					//TODO  Baustelle Ende 
				}
				$end = time();
				$Counter++;
				$laufzeit = $end - $start;
					$H = floor($laufzeit / 3600);
					$i = ($laufzeit / 60) % 60;
					$s = $laufzeit % 60;
				$Durchschnitt = $laufzeit/$Counter;
					$Hd = floor($Durchschnitt / 3600);
					$id = ($Durchschnitt / 60) % 60;
					$sd = $Durchschnitt % 60;
				//echo ;
				
				$status =  "Laufzeit: ".sprintf("%02d:%02d:%02d", $H, $i, $s)."( Pro Film: ".sprintf("%02d:%02d:%02d", $Hd, $id, $sd).") (".$Counter.' von '.count($FilmeArr).") ";
				echo $status.PHP_EOL.PHP_EOL;
				file_put_contents("./phpTestout/default.txt", $status." ".$value[1].PHP_EOL.PHP_EOL, FILE_APPEND);
			}
			echo $this->Console->getColoredString("Alle Filme Verarbeitet!", "green", "light_gray") .PHP_EOL;
			echo "Folgende Filme konten nicht verarbeitet werden: ".PHP_EOL;
			foreach ($fehlerArr as $fehler) {
				//echo $fehler.PHP_EOL;
			}
			$end = time();
			$laufzeit = $end - $start;
				$H = floor($laufzeit / 3600);
				$i = ($laufzeit / 60) % 60;
				$s = $laufzeit % 60;
			
			$status =  "Gesamtlaufzeit: ".sprintf("%02d:%02d:%02d", $H, $i, $s)."! ".$Counter.' von '.count($FilmeArr).PHP_EOL.PHP_EOL;
			echo $status;
			file_put_contents("./phpTestout/default.txt", $status.PHP_EOL, FILE_APPEND);
			
			//trim(fgets(STDIN));
			echo PHP_EOL;
			//return ;
		}else{
			echo "Not Found!".PHP_EOL;
		}
		/*
		else if($action == "update"){
			echo $this->Console->getColoredString("Filme > update", "black", "light_gray") .PHP_EOL;
			
			$mysqli = new mysqli($this->config["DB_Server"],$this->config["DB_Username"],$this->config["DB_Passwort"],$this->config["DB_Database"]);
			if($mysqli->connect_error != ""){		echo "Mysql-Fehler: ".$mysqli->connect_error.PHP_EOL; return false;}
			$mysqli->query("SET NAMES 'utf8'");
			$Query = "SELECT * FROM Filme;";
			//echo $Query.PHP_EOL;
			$result = $mysqli->query($Query); //TODO 3D überprüfung!!!
			if($mysqli->error != ""){		echo "Mysql-Fehler: ".$mysqli->error.PHP_EOL; return false;}
			$counterNotFound= 0;
			$counterChange=0;
			$fehlerglobal = "";
			while ($Film = $result->fetch_assoc()){
				$newData = array();
				$fehler = "";
				echo "	Hole Daten von imdb... ";
				// Werte aus IMdb Auslesen...
				$imdb = new IMDB("http://www.imdb.com/title/tt".$Film["imdbID"]."/");
				if ($imdb->isReady) {
					echo " done!".PHP_EOL;
					$newData["rating"] = $imdb->getRating();
					
					$newData["fsk"] = $this->gibFSK ($imdb, $fehler);

					$this->gibTMDBdata ( $Film["imdbID"], $newData);

					
					$update ="";
					$first = true;
					$changed = "";
					foreach ($newData AS $key=> $value){
						if(!(md5($Film[$key]) == md5($newData[$key]))) {
							$update .= " ".($first?"":",").$key." = '".mysql_escape_string($value)."'";
							$first = false;
							$changed .= $key.", "; 
						}
					}
					$fehlerglobal .= $fehler; 
					echo $fehler;
					if(!$first){
						$SQL = "UPDATE Filme SET".$update." WHERE imdbID = '".$Film["imdbID"]."';";
						$counterChange++;
						echo "Ändere (bei ".$Film["imdbID"].") ".$changed.PHP_EOL;
						//echo $SQL;
						$mysqli->query($SQL);
						file_put_contents("./phpTestout/update.txt", $SQL.PHP_EOL, FILE_APPEND);
					
						echo PHP_EOL;
					}else {
						echo "Nix zu ändern bei ".$Film["imdbID"]."!".PHP_EOL;
					}
				} else{
					echo $this->Console->error(" fail!").PHP_EOL;
					
					echo $this->Console->error("imdbID nicht bei imdb gefunden!").PHP_EOL;
					//file_put_contents("./phpTestout/".$array["imdbID"].".txt", "Keine Infos auf imdbID gefunden: ".$Pfad.$FilenameOrg.PHP_EOL, FILE_APPEND);
				}
				
			}
			echo PHP_EOL.$fehlerglobal.PHP_EOL;
			$end = time();
			$laufzeit = $end - $start;
			$H = floor($laufzeit / 3600);
			$i = ($laufzeit / 60) % 60;
			$s = $laufzeit % 60;
				
			$status =  "Gesamtlaufzeit: ".sprintf("%02d:%02d:%02d", $H, $i, $s)."!".PHP_EOL.
						"	Nicht gefunden: ".$counterNotFound.PHP_EOL.
						"	Geändert: ".$counterChange.PHP_EOL.PHP_EOL;
			echo $status;
			file_put_contents("./phpTestout/update.txt", $status.PHP_EOL, FILE_APPEND);
		}*/
	}
	/**
	 * @param imdbID
	 * @param DataArray
	 * @param 
	 * @param 
	 */private function gibTMDBdata($imdbID, &$DataArray){
		echo " Hole Daten von themoviedb.org... ";
		//$tmdbKey = "b1ddcc7d16281ce09f692896f882ba9d";
		//echo "API KEY TMDB: ".$this->config["ApiKeys"]['Tmdb_Key']."<>".$tmdbKey."\n\n\n";
		$tmdb = $this->jsonCacheDecoder("https://api.themoviedb.org/3/find/tt".$imdbID."?external_source=imdb_id&api_key=".$this->config["ApiKeys"]['Tmdb_Key']."&language=de");
		if(isset($tmdb["movie_results"])){
			if(isset($tmdb["movie_results"][0]["overview"])){	
				echo " done!".PHP_EOL;
				$DataArray["summary"]=$tmdb["movie_results"][0]["overview"];
			}else{
				//echo " fail2!".PHP_EOL;
				echo  $this->Console->error("keine summary gefunden für imdbID ".$imdbID."!").PHP_EOL;
			}
			$tmdbURL="https://api.themoviedb.org/3/movie/".$tmdb["movie_results"][0]["id"]."?api_key=".$this->config["ApiKeys"]['Tmdb_Key']."&language=de&append_to_response=trailers";
			$tmdbData1 = $this->jsonCacheDecoder($tmdbURL);
			if(isset($tmdbData1["trailers"]["youtube"][0]["source"])){
				//TODO youtube Key auf 11 Zeichen prüfen!!
				$youtubeDE = str_replace("&hd=1", "", $tmdbData1["trailers"]["youtube"][0]["source"]);
				if(strpos($youtubeDE,"youtube")>0){
					echo "doofer IFrame....!!!";
				}else{
					$DataArray["youtube"]= "DE:".$youtubeDE;
				}
				
			}else{
				$tmdbURL2="https://api.themoviedb.org/3/movie/".$tmdb["movie_results"][0]["id"]."?api_key=".$this->config["ApiKeys"]['Tmdb_Key']."&language=en&append_to_response=trailers";
				$tmdbData2 = $this->jsonCacheDecoder($tmdbURL2);
				if(isset($tmdbData2["trailers"]["youtube"][0]["source"])){
					$youtubeEN = str_replace("&hd=1", "", $tmdbData2["trailers"]["youtube"][0]["source"]);
					if(strpos($youtubeEN,"youtube")>0){
						echo "doofer IFrame....!!!";
					}else{
						$DataArray["youtube"]= "EN:".$youtubeEN;
					}
				}
				else{
					echo  $this->Console->error("kein Trailer gefunden für imdbID ".$imdbID."!").PHP_EOL;
				}
			}
		}else{
			echo " fail1!".PHP_EOL;
		}
}

	/**
	 * @param imdb
	 * @param fehler
	 * @return die FSK oder false
	 */private function gibFSK($imdb, $imdbID, &$fehler = "") {
	 //TODO imdb ID ist hier drinne nicht verfügbar....
		$fsktemp = $imdb->getCertification();
		
		$fskbool= false;
		
		if(!(strpos( $fsktemp,"Germany") === false)){
			$fsk = trim(substr($fsktemp,strpos( $fsktemp,"Germany")+8,2));
			if($fsk == "No"){
				$fsk = 18;
			}
			if(in_array($fsk, array(0, 6, 12,16,18))){
				$fskbool = true;
				return $fsk;
			}
		}
		if(!$fskbool){
			$fsk = "";
			//var_dump($fsktemp);
			echo "	Hole Daten von altersfreigaben.de... ";
			$fsk2 = file_get_contents("https://altersfreigaben.de/api2/s/tt".$imdbID."/de");
			echo $fsk2;
			echo " done!".PHP_EOL;
			if (in_array($fsk2, array(0, 6, 12,16,18))){
				$fsk = $fsk2;
				return $fsk2;
				$fskbool = true;
			}else{
				$fehler .=  $this->Console->error("keine fsk gefunden für imdbID ".$imdbID."!").PHP_EOL; 
				$fsk = "";
				return false;
				$counterNotFound++;
			}
		}
		//return $counterNotFound;
	}

	
	//TODO diese Funktion auch für Update benutzen?! bzw. sachen aus dem Update hier mit einbauen
	private function parseMovie($Pfad, $Filename){
		/*TODO
		 * FSK hinzufügen (siehe update)
		 */
		$PfadOrg = $Pfad;
		$Pfad = $Pfad;
		if(is_file($Pfad.$Filename)){
			$array = array();
			$FilenameOrg = $Filename;
			echo $Pfad.$FilenameOrg.PHP_EOL;
			
			$array["hdd"] = $this->HDDID;
			if(strpos($Filename, "(3D)")>0){
				$Filename = str_replace("(3D)", "", $Filename);
				$array["3d"] = "ja";
			}
			else{ $array["3d"] = ""; }
			if(strpos($Filename, "(720p)")>0){
				$Filename = str_replace("(720p)", "", $Filename);
				$array["resolution"] = "720p";
			}
			else if(strpos($Filename, "(1080p)")>0){
				$Filename = str_replace("(1080p)", "", $Filename);
				$array["resolution"] = "1080p";
			}
			else if(strpos($Filename, "(SD)")>0){
				$Filename = str_replace("(SD)", "", $Filename);
				$array["resolution"] = "SD";
			}
			if(!(strripos( $Filename,"(") == false)){
				$array["imdbID"] = substr($Filename,strripos( $Filename,"(")+1,7);
			}
			//echo strlen($array["imdbID"])." ".$array["imdbID"].PHP_EOL;
			if(!isset($array["imdbID"])){  //strlen($array["imdbID"])<=2
				file_put_contents("./phpTestout/default.txt", "Keine imdbID in Dateinamen: ".$Pfad.$Filename." gefunden!".PHP_EOL, FILE_APPEND);
				return false;
			}
			$array["name"]   = trim(substr($Filename, 0, strripos( $Filename,"(")));
			//TODO wird hier nicht gebraucht?
			//$Endung = trim(substr($Filename,strripos( $Filename,".")+1));
			
			echo " Hole Daten von imdb... ";
		// Werte aus IMdb Auslesen...
			$imdb = new IMDB("http://www.imdb.com/title/tt".$array["imdbID"]."/");
			if ($imdb->isReady) {
				echo " done!".PHP_EOL;
				//var_dump($imdb->getAll());
				$array["year"] = $imdb->getYear();
				$array["size"] = $this->getfileSize($Pfad.$FilenameOrg);
				$array["rating"] = $imdb->getRating();
				$array["Genre"] = $imdb->getGenre();
				$array["Schauspieler"] = $imdb->getCastAsOwn(0, false);
				$array["fsk"] = $this->gibFSK ($imdb,$array["imdbID"]);
				$this->gibTMDBdata ( $array["imdbID"], $array);
				// TODO Summery und Youtube hinzufügen
			} else{
				echo $this->Console->error("imdbID (".$array["imdbID"].") nicht bei imdb gefunden!").PHP_EOL;
				file_put_contents("./phpTestout/".$array["imdbID"].".txt", "Keine Infos auf imdbID gefunden: ".$Pfad.$FilenameOrg.PHP_EOL, FILE_APPEND);
				return false;
			}
			
			//TODO hier weiter!!
		// werte von MediaInfo holen...
			echo " Hole Daten von mediainfo... ";
			$befehl = 'mediainfo --Output=XML "'.$Pfad.$FilenameOrg.'" > /tmp/'.$array["imdbID"].'.xml';
			exec($befehl);
			$xmlstring = file_get_contents('/tmp/'.$array["imdbID"].'.xml');
			$xml = simplexml_load_string($xmlstring);
			$json = json_encode($xml,JSON_PRETTY_PRINT);
			$array2 = json_decode($json,TRUE);
			foreach ($array2["File"]["track"] as $key => $value) {
				//echo " ".$key." ".$value["@attributes"]["type"].PHP_EOL;
				switch ($value["@attributes"]["type"]) {
					case "General":
						$array["vcodec"] = str_replace("Matroska", "mkv", $value["Format"]);
						$array["duration"] = $this->getRunTime($value["Duration"]);
						$array["totalbitrate"] = round(trim(str_replace(" ", "",str_replace("Mbps", "", $value["Overall_bit_rate"])))*1024,0);
						break;
					case "Video":
						$array["width"] = trim(str_replace(" ", "",str_replace("pixels", "",$value["Width"])));
						//TODO Resolution aus diesen werten neusetzen
						$array["height"] = trim(str_replace(" ", "",str_replace("pixels", "",$value["Height"])));
						break;					
					case "Audio":
						if(isset($value["Language"])){
							if(($value["Language"] == "Deutsch") OR ($value["Language"] == "German")){
								$array["acodecger"] = $value["Format"];
								$array["abitrateger"] = round(trim(str_replace(" ", "",str_replace("Kbps", "",$value["Bit_rate"]))),0);
								$array["channelsger"] = str_replace(" channels", "",$value["Channel_s_"]);
								if(!is_numeric($array["channelsger"])){
									$array["channelsger"] = substr($array["channelsger"],strripos( $array["channelsger"],"/")+1);
									if(!is_numeric($array["channelsger"])){
										echo $this->Console->error("channelsger ist nicht Numerisch!").PHP_EOL;
										file_put_contents("./phpTestout/".$array["imdbID"].".txt", "channelsger ist nicht Numerisch!".PHP_EOL, FILE_APPEND);
										return false;
									}
								}
							}
							else if(($value["Language"] == "Englisch") OR ($value["Language"] == "English")){
								$array["acodeceng"] = $value["Format"];
								$array["abitrateeng"] = round(trim(str_replace(" ", "",str_replace("Kbps", "",$value["Bit_rate"]))),0);
								$array["channelseng"] = str_replace(" channels", "",$value["Channel_s_"]);
								if(!is_numeric($array["channelseng"])){
									$array["channelseng"] = substr($array["channelseng"],strripos( $array["channelseng"],"/")+1);
									if(!is_numeric($array["channelseng"])){
										echo $this->Console->error("channelseng ist nicht Numerisch!").PHP_EOL;
										file_put_contents("./phpTestout/".$array["imdbID"].".txt", "channelseng ist nicht Numerisch!".PHP_EOL, FILE_APPEND);
										return false;
									}
								}
							}
						}
						break;
				}
			}
			echo " done!".PHP_EOL;
			foreach ($array as $key => $value) {
				if($value == 'n/A'){
					unset($array[$key]);
				}
			}
			return $array;
			/*if( $this->addMovie($array, $Pfad.$FilenameOrg)){
				if(($Pfad.$FilenameOrg) == ($this->PfadzumAusgeben.($array["3d"]==""?$this->config["HDD"][$this->HDDID]["Filme"]:$this->config["HDD"][$this->HDDID]["3D"]).$PfadOrg.$array["name"]." (".$array["resolution"].")".($array["3d"] != ""?" (3D)":"")." (".$array["imdbID"].").".$Endung)){
					echo "Datei liegt schon am ausgabe Ort!".PHP_EOL;
				}
				else{
					
					if(!is_dir($this->PfadzumAusgeben.($array["3d"]==""?$this->config["HDD"][$this->HDDID]["Filme"]:$this->config["HDD"][$this->HDDID]["3D"]).$PfadOrg)){
						shell_exec("mkdir '".$this->PfadzumAusgeben.($array["3d"]==""?$this->config["HDD"][$this->HDDID]["Filme"]:$this->config["HDD"][$this->HDDID]["3D"]).$PfadOrg."'");
					}
					echo "Verschiebe Datei...";
					
					$copy = 'mv "'.
						$Pfad.$FilenameOrg.'" "'.
						$this->PfadzumAusgeben.($array["3d"]==""?$this->config["HDD"][$this->HDDID]["Filme"]:$this->config["HDD"][$this->HDDID]["3D"]).$PfadOrg.$array["name"]." (".$array["resolution"].")".($array["3d"] != ""?" (3D)":"")." (".$array["imdbID"].").".$Endung.'"';
					file_put_contents("./phpTestout/".$array['imdbID'].".txt", $copy.PHP_EOL, FILE_APPEND);
					shell_exec($copy);
					echo "done!".PHP_EOL;
				}
				shell_exec("mv './phpTestout/".$array["imdbID"].".txt' './phpTestout/OK_".$array["imdbID"].".txt'");
				return true;
			}
			else{
				echo $this->Console->error("Fehler beim Eintragen in die DB!").PHP_EOL;
				file_put_contents("./phpTestout/".$array["imdbID"].".txt", "Fehler beim Eintragen in die DB".PHP_EOL, FILE_APPEND);
				return false;
			}*/
		}else{
			echo $this->Console->error("Datei Existiert nicht!").PHP_EOL;
			file_put_contents("./phpTestout/default.txt", "Datei existiert nicht: ".$Pfad.$Filename.PHP_EOL, FILE_APPEND);
			return false;
		}
	}
	private function updateMovie($DataArr, $File, $md5 = true, $CheckOnly=true){
		// Jetzt noch MD5 berechnen
		if($md5){
			echo "Berechne MD5... ";
			$DataArr["md5"] = substr(shell_exec('md5sum -b "'.$File.'"'),0,32);
			file_put_contents("./phpTestout/".$DataArr['imdbID'].".txt", "md5 = ".$DataArr["md5"].PHP_EOL, FILE_APPEND);
			echo " done!".PHP_EOL;
		}
		$mysqli = new mysqli($this->config["DB_Server"],$this->config["DB_Username"],$this->config["DB_Passwort"],$this->config["DB_Database"]);
		if($mysqli->connect_error != ""){		echo "Mysql-Fehler: ".$mysqli->connect_error.PHP_EOL; return false;}
		$mysqli->query("SET NAMES 'utf8'");
		
		$Query = "SELECT * FROM Filme WHERE imdbID = '".$DataArr['imdbID']."' AND 3d ".($DataArr['3d']?"!=":"=").'""';
		$result = $mysqli->query($Query); //TODO 3D überprüfung!!!
		
		if($mysqli->error != ""){		echo "Mysql-Fehler: ".$mysqli->error.PHP_EOL; return false;}
		if($result->num_rows==1){
			$Film = $result->fetch_assoc();
			
			$changed = "";
			$first = true;
			$update = "";
			foreach ($DataArr AS $key=> $value){
				if(!in_array($key, array("Schauspieler", "Genre"))){
					if(!(md5($Film[$key]) == md5($DataArr[$key]))) {
						$update .= " ".($first?"":",").$key." = '".mysql_escape_string($value)."'";
						$first = false;
						$changed .= "  ".$key." old: ".$Film[$key].PHP_EOL;
						$changed .= "  ".$key." new: ".$DataArr[$key].PHP_EOL;
					}
				}
			}
			//$fehlerglobal .= $fehler;
			//echo $fehler;
			if(!$first){
				$SQL = "UPDATE Filme SET".$update." WHERE imdbID = '".$Film["imdbID"]."';";
				//$counterChange++;
				if(!$CheckOnly){
					 $Ausgabe = " Ändere (bei ".$Film["imdbID"].") :".PHP_EOL.$changed.PHP_EOL;
					 echo $Ausgabe;
					echo $SQL.PHP_EOL;
					//TODO SQL Query wieder ausführen!! $mysqli->query($SQL);
					file_put_contents("./phpTestout/update.txt", $SQL.PHP_EOL, FILE_APPEND);
					
				}else{
					 $Ausgabe= " Unterschiede (bei ".$Film["imdbID"].") :".PHP_EOL.$changed.PHP_EOL;
					echo $Ausgabe;
					//echo "Nix geändert!".PHP_EOL;
					file_put_contents("./phpTestout/update_CheckOnly.txt", $Ausgabe.PHP_EOL.PHP_EOL, FILE_APPEND);
					
				}
					
				echo PHP_EOL;
			}else {
				//echo "Nix zu ändern bei ".$Film["imdbID"]."!".PHP_EOL;
			}
		
		}else{
			echo $this->Console->error("Film Existiert nicht in der Datenbank!!").PHP_EOL;
		}
		
	}
	
	private function addMovie($DataArr, $File, $md5 = true){
		
		$mysqli = new mysqli($this->config["DB_Server"],$this->config["DB_Username"],$this->config["DB_Passwort"],$this->config["DB_Database"]);
		if($mysqli->connect_error != ""){		echo "Mysql-Fehler: ".$mysqli->connect_error.PHP_EOL; return false;}
		$mysqli->query("SET NAMES 'utf8'");
		$Query = "SELECT imdbID FROM Filme WHERE imdbID = '".$DataArr['imdbID']."' AND ".
				'3d '.($DataArr['3d']?"!=":"=").'""';
		//echo $Query.PHP_EOL;
		$result = $mysqli->query($Query); //TODO 3D überprüfung!!!
		
		if($mysqli->error != ""){		echo "Mysql-Fehler: ".$mysqli->error.PHP_EOL; return false;}
		if($result->num_rows>0){
			echo "Film bereits in DB!".PHP_EOL;
			file_put_contents("./phpTestout/".$DataArr['imdbID'].".txt", "Film bereits in DB!".PHP_EOL, FILE_APPEND); 
			return false;
		}
		// Jetzt noch MD5 berechnen
		if($md5){
			echo "Berechne MD5... ";
			$DataArr["md5"] = substr(shell_exec('md5sum -b "'.$File.'"'),0,32);
			file_put_contents("./phpTestout/".$DataArr['imdbID'].".txt", "md5 = ".$DataArr["md5"].PHP_EOL, FILE_APPEND);
			echo " done!".PHP_EOL;
		}
		
		// und Jetzt Querys Bauen und Ausführen...
		$Querys= array();
		$keys = array("views", "checked", "comment", "added");
		$values = array(0, "null", "''", "'".date("Y-m-d")."'");
		
		foreach ($DataArr as $key => $value) {
			if(in_array($key, array("Genre", "Schauspieler")) ){//TODO hier weiter!!
				if ($key == "Genre"){
					$genreArr = explode(" / ", $value);
					echo " Genre anlegen... ";
					foreach ($genreArr as $value2) {
						$Querys[] =  "INSERT INTO FilmGenre (imdbID, genreID) VALUES ('".$DataArr['imdbID']."', '".$this->getGenreID($mysqli, $value2)."');";
					}
					echo "done".PHP_EOL;
				}
				else if ($key == "Schauspieler"){
					$Schauspielers = explode(" / ", $value);
					echo " Schauspieler anlegen... ";
					foreach ($Schauspielers as $value3) {
						$Schauspieler = explode(">", str_replace("nm", "", $value3));
						$Querys[] = "INSERT INTO FilmSchauspieler (imdbID, schauspielerID) VALUES ('".$DataArr['imdbID']."', '".$this->getSchauspielerID($mysqli, $Schauspieler[1],$Schauspieler[0])."');";
					}
					echo "done".PHP_EOL;
				}
			}else{
				$keys[] = $key;
				$values[] = "'".mysql_escape_string(($value))."'";  //TODO ggf. utf8_encode einbauen?!
			}
		}
		echo " Film eintragen... ";
		$Query = "INSERT INTO Filme (".implode(",", $keys).") VALUES (".implode(",", $values).");"; //TODO Query ausführen!!
			
		//$result = $mysqli->query($Query);
		file_put_contents("./phpTestout/".$DataArr['imdbID'].".txt", $Query.PHP_EOL, FILE_APPEND);
		if($mysqli->error != ""){
			echo "Mysql-Fehler: ".$mysqli->error.PHP_EOL;
			file_put_contents("./phpTestout/".$DataArr['imdbID'].".txt", "Mysql-Fehler: ".$mysqli->error.PHP_EOL, FILE_APPEND);
			return false;
		}
		echo "done".PHP_EOL;
		echo $this->Console->getColoredString("Query", "light_gray", "green")." ".$Query.PHP_EOL;
		
		echo " Lege FilmSchauspieler und FilmGenre Verküpfungen an...";
		foreach ($Querys as $Query) {
			echo $this->Console->getColoredString("Query", "light_gray", "green")." ".$Query.PHP_EOL;
			
			//$result = $mysqli->query($Query);
			file_put_contents("./phpTestout/".$DataArr['imdbID'].".txt", $Query.PHP_EOL, FILE_APPEND);
			if($mysqli->error != ""){		
				echo "Mysql-Fehler: ".$mysqli->error.PHP_EOL; 
				file_put_contents("./phpTestout/".$DataArr['imdbID'].".txt", "Mysql-Fehler: ".$mysqli->error.PHP_EOL, FILE_APPEND);
				return false;
			}
			//TODO Query ausführen!!
		}
		echo "done!".PHP_EOL;
		$mysqli->close();
		return true;
	}
	private function getGenreID($mysqli, $GenreName){ 
		$GenreName = $mysqli->real_escape_string($GenreName);
		$result = $mysqli->query("SELECT genreID FROM Genre WHERE engname = '".mysql_escape_string(utf8_encode($GenreName))."'");
		if($mysqli->error != ""){		echo "Mysql-Fehler: ".$mysqli->error.PHP_EOL; return false;}
		if($result->num_rows>0){
			$resultArr = $result->fetch_array();
			//echo PHP_EOL.$this->Console->getColoredString("Genre Existiert", "light_gray", "green")." ".$result->num_rows.PHP_EOL;
			return $resultArr["genreID"];
		}
		else{
			$Query = "INSERT INTO Genre (engname) VALUES('".mysql_escape_string(utf8_encode($GenreName))."')";
			$mysqli->query($Query);
			return $mysqli->insert_id; //TODO nicht getestet Ob das überhaupt geht?! 
		}
	}
	private function getSchauspielerID($mysqli, $SchauspielerName, $SchauspielerID){
		$SchauspielerName = $mysqli->real_escape_string($SchauspielerName);
		//$result = $mysqli->query("SELECT schauspielerID FROM Schauspieler WHERE name = '".mysql_escape_string(utf8_encode($SchauspielerName))."'");
		$result = $mysqli->query("SELECT schauspielerID FROM Schauspieler WHERE schauspielerID = '".$SchauspielerID."'");
		//echo "SELECT schauspielerID FROM Schauspieler WHERE name = '".$SchauspielerName."'".PHP_EOL;
		if($mysqli->error != ""){		echo "Mysql-Fehler: ".$mysqli->error.PHP_EOL; return false;}
		if($result->num_rows > 0){
			$resultArr = $result->fetch_array();
			//echo PHP_EOL.$this->Console->getColoredString("Schauspieler Existiert", "light_gray", "green")." ".$SchauspielerName.PHP_EOL;
			return $resultArr["schauspielerID"];
		}
		else{
			$Query = "INSERT INTO Schauspieler (name, schauspielerID) VALUES('".mysql_escape_string(utf8_encode($SchauspielerName))."', '".$SchauspielerID."');";
			//echo PHP_EOL.$this->Console->getColoredString("Query", "light_gray", "green")." ".$Query.PHP_EOL;
			echo $SchauspielerName.", ";
			$mysqli->query($Query);
			return $SchauspielerID;
		}
	}
	private function getRunTime($laufzeit){
		$string = explode(" ", $laufzeit);
		return ((trim(str_replace("h", "", $string[0]))*3600)+(trim(str_replace("m", "", $string[1])*60)));
	}
	private function getfileSize($file){
		return trim(explode("/", exec('du -b "'.$file.'"'))[0]);
		
	}
	private function dirtoArray($dir, $root = ''){
		$Arr = scandir($dir);
		foreach ($this->config["FolderIgnor"] AS $value){
			unset($Arr[array_search($value, $Arr)]);
		}
		foreach ( $Arr AS $Key => $Value){
			if(is_dir ($dir.'/'.$Value) AND !in_array($Value, $this->config["FolderIgnor"])){
				$SubDir = $this->dirtoArray($dir.'/'.$Value, ($root==""?"":$root.'/').$Value);
				//echo PHP_EOL.$dir.'  /   '.$Value." ". ($root==""?"":$root.'/').$Value.PHP_EOL;
			}
			else{
				//TODO Dateiendungen ignorieren einbauen!! z.b. jpg und nfo
				$Endung = trim(substr($Value,strripos( $Value,".")+1));
				if(!in_array($Endung, $this->config["FileEndungIgnor"]) ){	
					$this->FolderArray[] = array($root, $Value);
				}
			}
		}
		return $this->FolderArray;
	}
	private function jsonCacheDecoder($url){
		$CacheFolderName = "JsonCache/";
		exec("rm ".$CacheFolderName.date("y-W_",time()-14*24*3600)."* > /dev/null 2>&1");
		exec("rm ".$CacheFolderName.date("y-W_",time()-7*24*3600)."* > /dev/null 2>&1");
		if(!is_dir($CacheFolderName)){
			exec( "mkdir ".$CacheFolderName);
		}
		$filename= date("y-W_",time()).md5($url).".json"; //TODO Cachetime Ändern
		if(!file_exists($CacheFolderName.$filename)){
			file_put_contents($CacheFolderName.$filename, file_get_contents($url));
		}
		return json_decode(file_get_contents($CacheFolderName.$filename), true);
	}
	/**
	 * Cover download
	 */
	public function cover(){
		echo $this->Console->getColoredString("Coverdownload > Filme", "black", "light_gray") .PHP_EOL;
		$start = time();
		$mysqli = new mysqli($this->config["DB_Server"],$this->config["DB_Username"],$this->config["DB_Passwort"],$this->config["DB_Database"]);
		if($mysqli->connect_error != ""){		echo "Mysql-Fehler: ".$mysqli->connect_error.PHP_EOL; return false;}
		$mysqli->query("SET NAMES 'utf8'");
		$Query = "SELECT imdbID FROM Filme GROUP BY imdbID;";
	
		$result = $mysqli->query($Query);
		if($mysqli->error != ""){		echo "Mysql-Fehler: ".$mysqli->error.PHP_EOL; return false;}
		$counterNotFound = 0;
		//shell_exec("rm ".$this->config["CoverDir"]."Filme/full/*");
		while ($Film = $result->fetch_assoc()){
			if(!file_exists($this->config["CoverDir"]."Filme/full/".$Film["imdbID"].".jpg")){
				echo "Lade Cover (".$Film["imdbID"].") von Markus ....";
				$url = "http://mediadb.ddns.net/cover/Filme/full/".$Film["imdbID"].".jpg";
				//echo $url."<>wget ".$url." -O ".$this->config["CoverDir"].$Film["imdbID"].".jpg";
				shell_exec("wget ".$url." -O ".$this->config["CoverDir"]."Filme/full/".$Film["imdbID"].".jpg > /dev/null 2>&1"); //");//
				if(filesize($this->config["CoverDir"]."Filme/full/".$Film["imdbID"].".jpg")==0){
					echo " fail!".PHP_EOL."  Lade Cover von imdb ....";
					$imdb = new IMDB("http://www.imdb.com/title/tt".$Film["imdbID"]."/");
					$url = $imdb->getPoster("big");
					if(strpos($url, "imdb-share")>3){
						echo "fail !".PHP_EOL;
						$counterNotFound++;
					}else{
						shell_exec("wget ".$url." -O ".$this->config["CoverDir"]."Filme/full/".$Film["imdbID"].".jpg"." > /dev/null 2>&1");
						echo "done !".PHP_EOL;
					}
				}
				else{
					echo " done!".PHP_EOL;
				}
				if(filesize($this->config["CoverDir"]."Filme/full/".$Film["imdbID"].".jpg")>0){
					shell_exec("convert ".$this->config["CoverDir"]."Filme/full/".$Film["imdbID"].".jpg".
					 	" -bordercolor White -border 1 -fuzz 50%% -trim -bordercolor White +repage -resize 5000x150\> ".
					 	$this->config["CoverDir"]."Filme/low/".$Film["imdbID"].".jpg");
					shell_exec("  convert ".$this->config["CoverDir"]."Filme/full/".$Film["imdbID"].".jpg".
					 	" -bordercolor White -border 1 -fuzz 50%% -trim -bordercolor White +repage -resize 5000x600\> ".
					 	$this->config["CoverDir"]."Filme/high/".$Film["imdbID"].".jpg");
				}else {
					shell_exec("rm ".$this->config["CoverDir"]."Filme/full/".$Film["imdbID"].".jpg");
				}
			}
			else{
				//echo "Überspringe ".$Film["imdbID"].PHP_EOL;
			}
		}
		echo $this->Console->getColoredString("Coverdownload > Serien und Staffeln", "black", "light_gray") .PHP_EOL;
		$Query = "SELECT series_nr FROM Serien GROUP BY series_nr;";
	
		$result = $mysqli->query($Query);
		if($mysqli->error != ""){		echo "Mysql-Fehler: ".$mysqli->error.PHP_EOL; return false;}
		$counterNotFound = 0;
		shell_exec("rm ".$this->config["CoverDir"]."Serien/full/*");
		shell_exec("rm ".$this->config["CoverDir"]."Staffeln/full/*");
		while ($Film = $result->fetch_assoc()){
			if(!file_exists($this->config["CoverDir"]."Serien/full/".$Film["series_nr"].".jpg")){
				echo "Lade Cover (".$Film["series_nr"].") von Markus ....";
				$url = "http://mediadb.ddns.net/cover/Serien/full/".$Film["series_nr"].".jpg";//1479358
				//echo $url."<>wget ".$url." -O ".$this->config["CoverDir"].$Film["imdbID"].".jpg";
				shell_exec("wget ".$url." -O ".$this->config["CoverDir"]."Serien/full/".$Film["series_nr"].".jpg > /dev/null 2>&1"); //");//
				if(filesize($this->config["CoverDir"]."Serien/full/".$Film["series_nr"].".jpg")>0){
					echo "done".PHP_EOL;
					shell_exec("convert ".$this->config["CoverDir"]."Serien/full/".$Film["series_nr"].".jpg".
							" -bordercolor White -border 1 -fuzz 50%% -trim -bordercolor White +repage -resize 5000x150\> ".
							$this->config["CoverDir"]."Serien/low/".$Film["series_nr"].".jpg");
				}else{
					shell_exec("rm ".$this->config["CoverDir"]."Serien/full/".$Film["series_nr"].".jpg");
					echo "fail".PHP_EOL;
				}
	
				$Query = "SELECT season_nr FROM Staffeln WHERE series_nr = ".$Film["series_nr"]." GROUP BY season_nr;";
	
				$result2 = $mysqli->query($Query);
				if($mysqli->error != ""){		echo "Mysql-Fehler: ".$mysqli->error.PHP_EOL; return false;}
				$counterNotFound = 0;
	
				while ($Film2 = $result2->fetch_assoc()){
					if(!file_exists($this->config["CoverDir"]."Staffeln/full/".$Film2["season_nr"].".jpg")){
						echo " Lade Cover (".$Film2["season_nr"].") von Markus ....";
						$url = "http://mediadb.ddns.net/cover/Staffeln/full/".$Film2["season_nr"].".jpg";
						//echo $url;
						shell_exec("wget ".$url." -O ".$this->config["CoverDir"]."Staffeln/full/".$Film2["season_nr"].".jpg > /dev/null 2>&1"); //");//
						if(filesize($this->config["CoverDir"]."Staffeln/full/".$Film2["season_nr"].".jpg")>0){
							echo "done".PHP_EOL;
							shell_exec("convert ".$this->config["CoverDir"]."Staffeln/full/".$Film2["season_nr"].".jpg".
									" -bordercolor White -border 1 -fuzz 50%% -trim -bordercolor White +repage -resize 5000x150\> ".
									$this->config["CoverDir"]."Staffeln/low/".$Film2["season_nr"].".jpg");
							shell_exec("convert ".$this->config["CoverDir"]."Staffeln/full/".$Film2["season_nr"].".jpg".
									" -bordercolor White -border 1 -fuzz 50%% -trim -bordercolor White +repage -resize 5000x600\> ".
									$this->config["CoverDir"]."Staffeln/high/".$Film2["season_nr"].".jpg");
						}else{
							shell_exec("rm ".$this->config["CoverDir"]."Staffeln/full/".$Film2["season_nr"].".jpg");
							echo "fail".PHP_EOL;
						}
	
	
	
					}
				}
	
			}
		}
	
	
		$end = time();
		$laufzeit = $end - $start;
		$H = floor($laufzeit / 3600);
		$i = ($laufzeit / 60) % 60;
		$s = $laufzeit % 60;
	
		$status =  "Gesamtlaufzeit: ".sprintf("%02d:%02d:%02d", $H, $i, $s)."!".PHP_EOL.
		"	Nicht gefunden: ".$counterNotFound.PHP_EOL;
		echo $status;
		file_put_contents("./phpTestout/cover.txt", $status.PHP_EOL, FILE_APPEND);
	
	}
}