<?php
class Media {
	private $Console;
	private $configfile;
	private $config;
	private $PfadzumEinlesen;
	private $PfadzumAusgeben;
	private $HDDID;
	private $FolderArray;
	public function __construct($configfile) {
		$this->Console = new Console();
		$this->configfile = $configfile;
		
		
		if(file_exists($configfile)){
			echo $this->Console->getColoredString("Hinweis:","black", "light_gray")." Configfile: ".$configfile." geladen!".PHP_EOL.PHP_EOL;
			$dateihandle = fopen($this->configfile,"r");
			$this->config = json_decode(fread($dateihandle, filesize($this->configfile)),true);
			
		}
		else{
			echo $this->Console->getColoredString("Hinweis:","black", "light_gray")." Configfile: ".$configfile." exisitiert nicht! Es werden defaults geladen!".PHP_EOL;
			echo "         Zum Anlegen der config bitte config save eingeben!".PHP_EOL.PHP_EOL;
			$this->config = array("configChangeTime" => time(),
							"ReadFromDir" => "/media/QNAP/FilmeWirdgelesen",
							"DB_Database" => "MediaDB_Nico",
							"DB_Username" => "MediaDB",
							"DB_Passwort" => "MediaDB",
							"DB_Server" => "192.168.0.32",
							"FolderIgnor" => array('.', '..', '.@__thumb', '@Recycle'),
							"HDD" => array(1 => array("HDDdir" => "/media/QNAP/",
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/"),
											2 => array("HDDdir" => NULL,
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/"),
											3 => array("HDDdir" => NULL,
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/"),
											4 => array("HDDdir" => NULL,
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/"),
											5 => array("HDDdir" => NULL,
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/") 
			));
		}
	}
	public function config($Action){
		switch ($Action){
			case "show":
				echo $this->Console->error("Folgende Config ist geladen:","black").PHP_EOL.PHP_EOL;
				echo "Config erstellt: ".date("H:i:s d.m.Y ",$this->config["configChangeTime"])		.PHP_EOL;
				foreach ($this->config["HDD"] as $key => $value) {
					if($value["HDDdir"] != NULL){
						foreach ($value as $key2 => $value2) {
						echo "HDD ".$key.": ".$key2.": ".$value2.PHP_EOL;
						}
					}
				}
				echo PHP_EOL;
				break;
			case "save":
				echo $this->Console->error("Config gespeichert!", "green").PHP_EOL.PHP_EOL;
				$dateihandle = fopen($this->configfile,"w");
				fwrite($dateihandle, json_encode($this->config, JSON_PRETTY_PRINT));
				fclose($dateihandle);
				break;
			default:
				echo $this->Console->getColoredString("Kein Parameter für Config übergeben","red", "light_gray").PHP_EOL.PHP_EOL;
				
				break;
		}
	}
	public function filme(){
		$start = microtime(true);
		//var_dump($this->config);
		echo $this->Console->getColoredString("Filme", "black", "light_gray") .PHP_EOL;
		
		echo "In welchen Verzeichnis liegen die einzulesenden Dateien? ( nur Enter = ".$this->config["ReadFromDir"].")" .PHP_EOL;
		$Pfad = trim(fgets(STDIN));
		$this->PfadzumEinlesen = (strlen($Pfad)>0?$Pfad:$this->config["ReadFromDir"]);
		if(!is_dir($this->PfadzumEinlesen)){
			return $this->Console->error("Pfad Eingabe exisitiert nicht!").PHP_EOL;
		}else {
			echo "    Verzeichnis ".$this->PfadzumEinlesen." wird für Eingabe verwendet".PHP_EOL;
		}
		echo PHP_EOL;
		
		echo "Auf welche Festplatte sollen die Filme gespeichert werden? ( nur Enter = 1)" .PHP_EOL;
		$hddid = trim(fgets(STDIN));
		$this->HDDID = (strlen($hddid)>0?$hddid:1);
		$this->PfadzumAusgeben = $this->config["HDD"][$this->HDDID]["HDDdir"];
		foreach ($this->config["HDD"][$this->HDDID] as $key => $value) {
			if(!($key == "HDDdir")){
				if(!is_dir($this->PfadzumAusgeben.$value)){	return "   ".$this->Console->error("Pfad für Ausgabe exisitiert nicht!").PHP_EOL;        }
				else {									echo "    Verzeichnis ".$this->PfadzumAusgeben.$value." wird für ".$key." als Ausgabe verwendet".PHP_EOL;	}
			}
		}
		echo PHP_EOL;
		
		echo "Starte verarbeitung der Filme:".PHP_EOL.PHP_EOL;
		$FilmeArr = $this->dirtoArray($this->PfadzumEinlesen);
		$fehlerArr;
		//var_dump($FilmeArr);
		foreach ($FilmeArr as $value) {
			//echo " ".$this->PfadzumEinlesen.'/'.(strlen($value[0])>0?$value[0].'/':'').$value[1].PHP_EOL;
			$ret = $this->parseMovie($this->PfadzumEinlesen.'/'.(strlen($value[0])>0?$value[0].'/':''), $value[1]).PHP_EOL;
			if($ret == false){
				echo $this->Console->getColoredString("       ","black", "red").PHP_EOL;
				$fehler = $this->Console->getColoredString("Fehler!","black", "red")." ".$this->PfadzumEinlesen.'/'.(strlen($value[0])>0?$value[0].'/':'').$value[1].PHP_EOL;
				echo $fehler;
				$fehlerArr[] = $fehler;
				echo $this->Console->getColoredString("       ","black", "red").PHP_EOL;
			}
			$end = microtime(true);
			$laufzeit = $end - $start;
			echo "Laufzeit: ".$laufzeit." Sekunden!".PHP_EOL.PHP_EOL;
		}
		echo $this->Console->getColoredString("Alle Filme Verarbeitet!", "green", "light_gray") .PHP_EOL;
		echo "Folgende Filme konten nicht verarbeitet werden: ".PHP_EOL;
		foreach ($fehlerArr as $fehler) {
			echo $fehler.PHP_EOL;
		}
		
		//trim(fgets(STDIN));
		echo PHP_EOL;
		//return ;
	}
	private function parseMovie($Pfad, $Filename){
		if(is_file($Pfad.$Filename)){
			$array = array();
			$FilenameOrg = $Filename;
			echo $Pfad.$FilenameOrg.PHP_EOL;
			
			$array["hdd"] = $this->HDDID;
			if(strpos($Filename, "(3D)")>0){
				$Filename = str_replace("(3D)", "", $Filename);
				$array["3d"] = "ja";
			}
			else{ $array["3d"] = ""; }
			if(strpos($Filename, "(720p)")>0){
				$Filename = str_replace("(720p)", "", $Filename);
				$array["resolution"] = "720p";
			}
			else if(strpos($Filename, "(1080p)")>0){
				$Filename = str_replace("(1080p)", "", $Filename);
				$array["resolution"] = "1080p";
			}
			else if(strpos($Filename, "(SD)")>0){
				$Filename = str_replace("(SD)", "", $Filename);
				$array["resolution"] = "SD";
			}
			$array["imdbID"] = substr($Filename,strripos( $Filename,"(")+1,7);
			$array["name"]   = trim(substr($Filename, 0, strripos( $Filename,"(")));
			/*$array["Endung"] = trim(substr($Filename,strripos( $Filename,".")+1));*/
		// Werte aus IMdb Auslesen...
			$imdb = new IMDB("http://www.imdb.com/title/tt".$array["imdbID"]."/");
			if ($imdb->isReady) {
				//var_dump($imdb->getAll());
				$array["year"] = $imdb->getYear();
				$array["size"] = $this->getfileSize($Pfad.$FilenameOrg);
				//$array["md5"] = md5_file($Pfad.$FilenameOrg); //TODO Einkommentieren für md5
				$array["md5"] = md5_file("/tmp/".$array["imdbID"].".xml");
				$array["rating"] = $imdb->getRating();
				$array["Genre"] = $imdb->getGenre();
				$array["Schauspieler"] = $imdb->getCastAsOwn();
			} else{
				echo "nichts gefunden!".PHP_EOL;
			}
		// werte von MediaInfo holen...
			$befehl = 'mediainfo --Output=XML "'.$Pfad.$FilenameOrg.'" > /tmp/'.$array["imdbID"].'.xml';
			exec($befehl);
			$xmlstring = file_get_contents('/tmp/'.$array["imdbID"].'.xml');
			$xml = simplexml_load_string($xmlstring);
			$json = json_encode($xml,JSON_PRETTY_PRINT);
			$array2 = json_decode($json,TRUE);
			foreach ($array2["File"]["track"] as $key => $value) {
				//echo " ".$key." ".$value["@attributes"]["type"].PHP_EOL;
				switch ($value["@attributes"]["type"]) {
					case "General":
						$array["vcodec"] = str_replace("Matroska", "mkv", $value["Format"]);
						$array["duration"] = $this->getRunTime($value["Duration"]);
						$array["totalbitrate"] = round(trim(str_replace(" ", "",str_replace("Mbps", "", $value["Overall_bit_rate"])))*1024,0);
						break;
					case "Video":
						$array["width"] = trim(str_replace(" ", "",str_replace("pixels", "",$value["Width"])));
						$array["height"] = trim(str_replace(" ", "",str_replace("pixels", "",$value["Height"])));
						break;					
					case "Audio":
						if(isset($value["Language"])){
							if(($value["Language"] == "Deutsch") OR ($value["Language"] == "German")){
								$array["acodecger"] = $value["Format"];
								$array["abitrateger"] = round(trim(str_replace(" ", "",str_replace("Kbps", "",$value["Bit_rate"]))),0);
								$array["channelsger"] = str_replace(" channels", "",$value["Channel_s_"]);
								if(!is_numeric(str_replace(" channels", "",$value["Channel_s_"]))){
									return false;
								}
							}
							else if(($value["Language"] == "Englisch") OR ($value["Language"] == "English")){
								$array["acodeceng"] = $value["Format"];
								$array["abitrateeng"] = round(trim(str_replace(" ", "",str_replace("Kbps", "",$value["Bit_rate"]))),0);
								$array["channelseng"] = str_replace(" channels", "",$value["Channel_s_"]);
								if(!is_numeric(str_replace(" channels", "",$value["Channel_s_"]))){
									return false;
								}
							}
						}
						break;
					
					default:
						;
					break;
				}
			}
			
			return $this->addMovie($array);
			/*foreach ($array as $key => $value) {
				echo " ".$key." => '".$value."'".PHP_EOL;
			}*/
		}else{
			return "Keine Datei!".PHP_EOL;
		}
	}
	private function addMovie($DataArr){
		$mysqli = new mysqli($this->config["DB_Server"],$this->config["DB_Username"],$this->config["DB_Passwort"],$this->config["DB_Database"]);
		if($mysqli->error != ""){		return "Mysql-Fehler: ".$mysqli->error.PHP_EOL;}
		//$ret->num_rows
		foreach ($DataArr as $key => $value) {
			if(in_array($key, array("Genre", "Schauspieler")) ){
				//echo " ".$key." => '".implode("|", )."'".PHP_EOL;
				var_dump($value);
			}else{
				echo " ".$key." => '".$value."'".PHP_EOL;
			}
		}
		
		$mysqli->close();
	}
	private function getRunTime($laufzeit){
		$string = explode(" ", $laufzeit);
		return ((trim(str_replace("h", "", $string[0]))*3600)+(trim(str_replace("m", "", $string[1])*60)));
	}
	private function getfileSize($file){
		return trim(explode("/", exec('du -b "'.$file.'"'))[0]);
		
	}
	private function dirtoArray($dir, $root = ''){
		$Arr = scandir($dir);
		foreach ($this->config["FolderIgnor"] AS $value){
			unset($Arr[array_search($value, $Arr)]);
		}
		foreach ( $Arr AS $Key => $Value){
			if(is_dir ($dir.'/'.$Value) AND !in_array($Value, $this->config["FolderIgnor"])){
				$SubDir = $this->dirtoArray($dir.'/'.$Value, $root.'/'.$Value);
			}
			else{
				$this->FolderArray[] = array($root, $Value);
			}
		}
		return $this->FolderArray;
	}
	
	
}