# -*- coding: utf-8 -*-

from HTMLParser import HTMLParser
import codecs
import sys
import os
import xml.etree.ElementTree as ET
import os.path
import time
import MySQLdb
import imdb
import subprocess
import shutil
import csv
import urllib

class Database(object):
    
    def connect(self):
        try:
            self.connection = MySQLdb.connect(host="192.168.0.32", port=3306, db="MediaDB_Nico", user="MediaDB", passwd="MediaDB")
        except:
            self.connection = MySQLdb.connect(host="192.168.0.32", port=3306, db="MediaDB_Nico", user="MediaDB", passwd="MediaDB")
        self.instance = self.connection.cursor()

    def deleteDuplicates(self):

        self.connect()

        # Anzahl der Einträge vorher

        self.instance.execute("SELECT imdbID FROM FilmGenre")
        entriesGenreBegin = self.instance.fetchall()
        self.instance.execute("SELECT imdbID FROM FilmSchauspieler")
        entriesSchauspielerBegin = self.instance.fetchall()

        # Ermitteln der Duplikate

        self.instance.execute("SELECT imdbID, schauspielerID, COUNT(*) FROM FilmSchauspieler GROUP BY imdbID, schauspielerID HAVING COUNT(*) > 1")
        duplicatesSchauspieler = self.instance.fetchall()
        self.instance.execute("SELECT imdbID, genreID, COUNT(*) FROM FilmGenre GROUP BY imdbID, genreID HAVING COUNT(*) > 1")
        duplicatesGenre = self.instance.fetchall()

        # Löschen der Duplikate

        for duplicate in duplicatesSchauspieler:
    
            befehl = "DELETE FROM FilmSchauspieler WHERE imdbID = %s AND schauspielerID = %s LIMIT 1"
            self.instance.execute(befehl, (duplicate[0], duplicate[1])) 
            self.connection.commit();

        for duplicate in duplicatesGenre:
    
            befehl = "DELETE FROM FilmGenre WHERE imdbID = %s AND genreID = %s LIMIT 1"
            self.instance.execute(befehl, (duplicate[0], duplicate[1])) 
            self.connection.commit();

        # Anzahl der Einträge hinterher
    
        self.instance.execute("SELECT imdbID FROM FilmGenre")
        entriesGenreEnd = self.instance.fetchall()
        self.instance.execute("SELECT imdbID FROM FilmSchauspieler")
        entriesSchauspielerEnd = self.instance.fetchall()

        # Ausgabe der Ergebnisse

        print('Genre:\t\t' + str(len(entriesGenreBegin) - len(entriesGenreEnd)) + " Duplikate gelöscht")
        print("Schauspieler:\t" + str(len(entriesSchauspielerBegin) - len(entriesSchauspielerEnd)) + " Duplikate gelöscht")

        if (len(entriesGenreBegin) - len(entriesGenreEnd) == len(duplicatesGenre)) & (len(entriesSchauspielerBegin) - len(entriesSchauspielerEnd) == len(duplicatesSchauspieler)):

            print("keine Daten verloren!")

        else:

            print("!!!! mit den Daten stimmt etwas nicht mehr !!!!")

        self.instance.close()

    def updateRating(self):

        self.connect()
        # Abfrage der Ratings

        self.instance.execute("SELECT imdbID, rating FROM Filme")
        ratings = self.instance.fetchall()
        
        # Update des Ratings

        IMDBparser = imdb.IMDb()
        indexCount = 1          # Nummer des Films bei dem das Programm gerade ist
        updateCount = 0         # Anzahl notwendiger Updates

        for rating in ratings:

            print('Prüfe Film %d/%d (%d Updates)' % (indexCount, len(ratings), updateCount))
            movie = IMDBparser.get_movie(rating[0])

            try:
                if (rating[1] != movie['rating']):
                    befehl = "UPDATE Filme SET rating = %s WHERE imdbID = %s"
                    self.instance.execute(befehl, (movie['rating'], rating[0]))
                    self.connection.commit()
                    updateCount += 1
            except KeyError:
                print('No rating found for ID:%s' % rating[0])

            indexCount += 1
        
        print(str(updateCount) + " Filme erhielten ein Update")

        self.instance.close()

    def compare(self):

        watchlistIDs = []

        f = open(sys.argv[2])
        csvReader = csv.reader(f)
        for row in csvReader:
            if (len(row[1]) == 9):
                watchlistIDs.append(row[1][2:])
        self.connect()
        self.instance.execute('SELECT distinct imdbID FROM Filme')
        databaseIDs = self.instance.fetchall()
        a = watchlistIDs
        b = [x[0] for x in databaseIDs]
        missingInDatabase = [aa for aa in a if aa not in b]
        missingInWatchlist = [bb for bb in b if bb not in a]
        if (len(missingInDatabase) == 0) & (len(missingInWatchlist) == 0):
            print("In der Watchlist sind die gleichen Filme, wie in der Datenbank!")
        if (len(missingInDatabase) > 0):
            raw_input('%d Filme müssen aus der Watchlist gelöscht werden! Weiter?' % len(missingInDatabase))
            for x in missingInDatabase:
                subprocess.Popen(['firefox','http://www.imdb.com/title/tt%s' % x], shell=False, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
                time.sleep(1)
        if (len(missingInWatchlist) > 0):
            raw_input('%d Filme müssen der Watchlist hinzugefügt werden! Weiter?' % len(missingInWatchlist))
            for x in missingInWatchlist:
                subprocess.Popen(['firefox','http://www.imdb.com/title/tt%s' % x], shell=False, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        
class FileManager(object):

    def escape(self, f):

        f = f.replace(" ","\ ").replace("(","\(").replace(")","\)").replace("&","\&").replace("'","\'").replace("`","\`")
        
        return f
      
    def convert(self, text):
      
        # Umlaute ersetzen

        text = text.replace('\\xc3\\xa4','ä').replace('\\xc3\\x84','Ä').replace('\\xc3\\xb6','ö').replace('\\xc3\\x96','Ö').replace('\\xc3\\xbc','ü').replace('\\xc3\\x9c','Ü')

        # Sonderzeichen ersetzen

        text = text.replace('\\xc3\\x9f','ß')
        text = text.replace('\\xe2\\x80\\x99','') # Zeichen:
        text = text.replace('\\xe2\\x80\\x94','-')
        text = text.replace('\\xe2\\x80\\x93','-')
        text = text.replace(':','')
        text = text.replace('?','')
        text = text.replace('%','Prozent')
        text = text.replace('/','-')
        if ("*" in text):
            text = text.replace('*',raw_input('Wofür steht das folgende "*"?\n%s\n' % text))
        text = text.replace('\\xe2\\x80\\xa6','...')
        text = text.replace('\\xc3\\xa9','e')
        text = text.replace('\\xc3\\xa0','a')

        return text

    def checkHDD(self):

        database = Database()
        database.connect()

        # Abfrage notwendiger Werte

        hdd = str(raw_input('Welche Nummer hat die Festplatte?\n'))

        # Auflisten aller Filme

        f = FileManager().escape(sys.argv[2])
        f1 = str(os.popen("find " + f).read());
        f2 = f1.split("\n");
        f2.sort();

        # Abfrage Filme

        database.instance.execute("SELECT name, 3d, md5 FROM Filme WHERE hdd = %s ORDER BY name ASC", hdd)
        filme = database.instance.fetchall()

        # Abfrage Serien

        database.instance.execute("SELECT Serien.name, Staffeln.season, Episoden.episodenumber, Episoden.md5, Episoden.name FROM Serien, Staffeln, Episoden WHERE Serien.series_nr = Staffeln.series_nr AND Staffeln.season_nr = Episoden.season_nr AND Episoden.hdd = %s ORDER BY Serien.name, Staffeln.season, Episoden.episodenumber ASC", hdd)
        serien = database.instance.fetchall()

        # Ermittlung des belegten Speichers für Fortschrittsanzeige

        memTotal = int(os.popen("du -sb " + FileManager().escape(sys.argv[2])).read().split()[0])

        checked = 0
        md5Wrong = 0
        md5Right = 0
        memCurrent = 0
        fCleaned = []
        fCleanedTestRun = []
        found = 0

        for x in f2:
            if (x[-4:-3] == ".") & (x[-2:-1] != "."):
                fCleaned.append(x)
                fCleanedTestRun.append(x)

        ### Suche alle Dateien

        print("\n")

        if (len(serien) > 0):

            for x in serien:

                match = False

                kennung = "S" + str(x[1]).zfill(2) + " E" + str(x[2]).zfill(2)

                for y in fCleanedTestRun:

                    if (kennung in y) & (x[0].decode('iso-8859-1') in y.decode('utf-8')):
                        fCleanedTestRun.pop(fCleanedTestRun.index(y))
                        found += 1
                        match = True

                        break

                    if (x[0].decode('iso-8859-1') in y.decode('utf-8')) & ("Specials" in y) & (('/%s.' % x[4].decode('iso-8859-1')) in y.decode('utf-8')) & (("Staffel %s" % str(x[1]) in y) | ('Season %s' % x[1] in y)) & (kennung not in y) & (x[2] == 999):
                        fCleanedTestRun.pop(fCleanedTestRun.index(y))
                        found += 1
                        match = True

                        break

                if (match == False):

                    print(str(x) + " not found")
                    

            if (found != len(serien)):

                print("Es wurden %i von %i Folgen gefunden!" % (found, len(serien)))
                raw_input("Forfahren?")

            else:

                print("Es wurden alle Folgen gefunden!")

        found = 0

        if (len(filme) > 0): 

            for x in filme:

                if (x[1] == ""):

                    for y in fCleanedTestRun:

                        if (x[0].decode('iso-8859-1') in y.decode('utf-8')) & ("3D" not in y):
                            fCleanedTestRun.pop(fCleanedTestRun.index(y))
                            found += 1

                            break

                else:

                    for y in fCleanedTestRun:
                       
                        if (x[0].decode('iso-8859-1') in y.decode('utf-8')) & ("3D" in y):
                            fCleanedTestRun.pop(fCleanedTestRun.index(y))
                            found += 1

                            break

            if (found != len(filme)):

                print("Es wurden %i von %i Filmen gefunden" % (found, len(filme)))
                raw_input("Forfahren?")

            else:

                print("Es wurden alle Filme gefunden!")

        if (len(fCleanedTestRun) > 0):

            print("\nFolgende Dateien sind noch auf dem Datenträger, aber nicht in der Datenbank:")

            for x in fCleanedTestRun:

                print(x)

            raw_input('\nFortfahren?')


        ### Prüfung aller Prüfsummen

        print("\n")

        print("Fortschritt:\n0.00 %")

        wrongCheckSum = []

        check = False

        tmp = raw_input('Soll ein Offset genutzt werden?\n')
        if (tmp == "ja"):
            offset = raw_input('Welche Datei wurde als letztes geprüft (nur Name)?\n').replace('\\','')
        else:
            check = True

        if (len(serien) > 0):
            for x in serien:
                kennung = "S" + str(x[1]).zfill(2) + " E" + str(x[2]).zfill(2)
                for y in fCleaned:
                    if (kennung in y) & (x[0].decode('iso-8859-1') in y.decode('utf-8')):
                        memCurrent += os.path.getsize(y)
                        fCleaned.pop(fCleaned.index(y))
                        checked += 1
                        #md5 = x[3]
                        print(y)
                        if (check == True):
                            md5 = os.popen("md5sum " + FileManager().escape(y)).read().split()[0]
                            if (md5 == x[3]):
                                md5Right += 1
                            else:
                                print(x)
                                print("Datei: " + y)
                                print("neue MD5: " + str(md5))
                                print("alte md5: " + x[3])
                                wrongCheckSum.append(y)
                                md5Wrong += 1 
                        else:
                            md5Right += 1
                            if (offset == y):
                                check = True
                        break
                    if (x[0].decode('iso-8859-1') in y.decode('utf-8')) & ("Specials" in y) & (('/%s.' % x[4].decode('iso-8859-1')) in y.decode('utf-8')) & (("Staffel %s" % str(x[1]) in y) | ('Season %s' % x[1] in y)) & (kennung not in y) & (x[2] == 999):
                        memCurrent += os.path.getsize(y)
                        fCleaned.pop(fCleaned.index(y))
                        checked += 1
                        #md5 = x[3]
                        print(y)
                        if (check == True):
                            md5 = os.popen("md5sum " + FileManager().escape(y)).read().split()[0]
                            if (md5 == x[3]):
                                md5Right += 1
                            else:
                                print(x)
                                print("Datei: " + y)
                                print("neue MD5: " + str(md5))
                                print("alte md5: " + x[3])
                                wrongCheckSum.append(y)
                                md5Wrong += 1 
                        else:
                            md5Right += 1
                            if (offset == y):
                                check = True
                        break
                print("%3.2f %s\t(%d falsche MD5s)" % (((float(memCurrent) / float(memTotal)) * 100),"%",md5Wrong))


        if (len(filme) > 0): 
            for x in filme:
                if (x[1] == ""):
                    for y in fCleaned:
                        if (x[0].decode('iso-8859-1') in y.decode('utf-8')) & ("3D" not in y):
                            memCurrent += os.path.getsize(y)
                            fCleaned.pop(fCleaned.index(y))
                            checked += 1
                            #md5 = x[2]
                            print(y)
                            if (check == True):
                                md5 = os.popen("md5sum " + FileManager().escape(y)).read().split()[0]
                                if (md5 == x[2]):
                                    md5Right += 1
                                else:
                                    print(x)
                                    print("Datei: " + y)
                                    print("neue MD5: " + md5)
                                    print("alte md5: " + x[2])
                                    wrongCheckSum.append(y)
                                    md5Wrong += 1 
                            else:
                                md5Right +=1
                                if (offset == y):
                                    check = True
                            break
                else:
                    for y in fCleaned:
                        if (x[0].decode('iso-8859-1') in y.decode('utf-8')) & ("3D" in y):
                            memCurrent += os.path.getsize(y)
                            fCleaned.pop(fCleaned.index(y))
                            checked += 1
                            #md5 = x[2]
                            print(y)
                            if (check == True):
                                md5 = os.popen("md5sum " + FileManager().escape(y)).read().split()[0]
                                if (md5 == x[2]):
                                    md5Right += 1
                                else:
                                    print(x)
                                    print("Datei: " + y)
                                    print("neue MD5: " + md5)
                                    print("alte md5: " + x[2])
                                    wrongCheckSum.append(y)
                                    md5Wrong += 1 
                            else:
                                md5Right += 1
                                if (offset == y):
                                    check = True
                            break

                print("%3.2f %s\t(%d falsche MD5s)" % (((float(memCurrent) / float(memTotal)) * 100),"%",md5Wrong))


        print("\nEs wurden %i Dateien überprüft" % checked)
        print("Es wurden %i defekte Dateien gefunden" % md5Wrong)
        if (md5Wrong > 0):
            print("Folgende Dateien sind defekt:")
            for x in wrongCheckSum:
                print(x)
            print("Es wurden %i intakte Dateien gefunden" % md5Right)
            if (len(serien) + len(filme)) > checked:
                print("\nAchtung es wurden nur %i von %i Dateien überprüft" % (checked, (len(serien) + len(filme))))

    def extractDownloads(self):

        # Prüfe angegebenes Verzeichnis zum Entpacken
        try:
            if (os.path.isdir(sys.argv[2]) == True):
                extractPath = sys.argv[2]
            else:
                print('"%s" ist kein Verzeichnis' % sys.argv[2])
                sys.exit(1)
        except IndexError:
            print('Kein Pfad angegeben!')
            sys.exit(1)

        # Liste alle Unterordner auf, in denen entpackt werden soll
        subFolders = os.listdir(extractPath)
        for x in sorted(subFolders):
            if (os.path.isdir(extractPath + x) == True):
                try:
                    firstPart = sorted(os.listdir(extractPath + x))[0]
                except:
                    pass
                path = extractPath + x
                try:
                    digits = None
                    if ('part1.rar' in firstPart):
                        digits = '1' 
                    elif ('part01.rar' in firstPart):
                        digits = '01' 
                    elif ('part001.rar' in firstPart):
                        digits = '001' 
                    elif ('part0001.rar' in firstPart):
                        digits = '0001'
                except UnboundLocalError:
                    pass
                    
                if (digits != None):
                    os.chdir(path)
                    returnCode = subprocess.call('rar -inul -o+ -p- x "*.part%s.rar"' % (digits), shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
                    if (returnCode == 0):
                        print('SUCCESS: %s' % path)
                        subprocess.call('rm -fr *.rar', shell = True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
                    elif (returnCode == 10):
                        returnCode = subprocess.call('rar -inul -o+ -pserienjunkies.org x "*.part%s.rar"' % (digits), shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
                        if (returnCode == 10):
                            print('PW PROTECTED: %s' % path)
                        elif (returnCode == 0):
                            print('SUCCESS: %s' % path)
                            subprocess.call('rm -fr *.rar', shell = True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
                    else:
                        print('ERROR: %s' % path)
                else:
                    print('NO ARCHIV: %s' % path)

    def getMetaData(self, path, mode):

        # path-Variable darf NICHT escaped uebergeben werden!
        tempFileName = time.strftime('%Y-%m-%d_%H-%M-%S')
        results = {} # Ergebnis-Dictionary

        # Initialisierung der Attribute

        results['gerlanguage'] = None
        results['geraudiocodec'] = 'NULL'
        results['gerchannels'] = 'NULL'
        results['geraudiobitrate'] = 'NULL'
        results['englanguage'] = None
        results['engaudiocodec'] = 'NULL'
        results['engchannels'] = 'NULL'
        results['engaudiobitrate'] = 'NULL'
        results['dimension'] = ''

        ### Ermittlung aller Metadaten
        subprocess.Popen('mediainfo --Output=XML %s > /tmp/%s.xml' % (FileManager().escape(path), tempFileName), shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE).communicate()
        tree = ET.parse('/tmp/%s.xml' % tempFileName)
        root = tree.getroot()

        for x in range(0, len(root[0])):

            track = root[0][x].attrib

            if track['type'] == 'General':
                results['name'] = root[0][x].find('Complete_name').text
                results['videoformat'] = root[0][x].find('Format').text
                results['duration'] = root[0][x].find('Duration').text
                results['totalbitrate'] = root[0][x].find('Overall_bit_rate').text

            elif track['type'] == 'Video':
                results['width'] = root[0][x].find('Width').text
                results['height'] = root[0][x].find('Height').text

            elif track['type'] == 'Audio':

                try:
                    sprache = root[0][x].find('Language').text
                except:
                    sprache = str(raw_input('Welche Sprache hat der Audiotrack mit der ID %s ?\n' % root[0][x].find('ID').text))

                if (sprache == 'German') | (sprache == 'Deutsch'):
                    results['gerlanguage'] = 'ger'
                    results['geraudiocodec'] = root[0][x].find('Format').text
                    try:
                        results['geraudiobitrate'] = root[0][x].find('Bit_rate').text
                    except AttributeError:
                        results['geraudiobitrate'] = '%s Kbps' % raw_input('Wie ist die Bitrate der DEUTSCHEN Tonspur? (in Kbps)')
                    results['gerchannels'] = root[0][x].find('Channel_s_').text

                elif (sprache == 'English') | (sprache == 'Englisch'):
                    results['englanguage'] = 'eng'
                    results['engaudiocodec'] = root[0][x].find('Format').text
                    try:
                        results['engaudiobitrate'] = root[0][x].find('Bit_rate').text
                    except AttributeError:
                        results['engaudiobitrate'] = '%s Kbps' % raw_input('Wie ist die Bitrate der ENGLISCHEN Tonspur (in Kbps)?')
                    results['engchannels'] = root[0][x].find('Channel_s_').text

        results['size'] = os.path.getsize(path)
        results['added'] = time.strftime('%Y-%m-%d')

        ### Ermittlung film- oder serienspezifischer Daten

        if (mode == 'episode'):

            # Episodennummer ermitteln
            if "/Specials/" in results['name']:
                results['episodenumber'] = 999
            else:
                results['episodenumber'] = int(results['name'].split('/')[-1][5:7])

            # Source ermitteln
            if "BD" in results['name']:
                results['source'] = "BD";
            elif "Web" in results['name']:
                results['source'] = "Web"
            elif "DVD" in results['name']:
                results['source'] = "DVD"
            elif "TV" in results['name']:
                results['source'] = "TV"
            else:
                print('Keine Quelle im Ordnernamen!!!')
                sys.exit(1)

            results['md5'] = subprocess.Popen(['md5sum', results['name']], shell=False, stdout=subprocess.PIPE, stderr=subprocess.PIPE).communicate()[0].split()[0]   
                
            # Ermittlung des Namen
            lastSlashPos = results['name'].rfind('/')
            if ('/Specials/' in results['name']):
                results['name'] = results['name'][lastSlashPos+1:-4];
            else:
                if results['name'][lastSlashPos+8] != " ":
                    results['name'] = results['name'][lastSlashPos+10:-4];
                else:
                    if (results['name'][lastSlashPos+9] == '+'):
                        results['name'] = results['name'][lastSlashPos+15:-4]
                    else:
                        results['name'] = results['name'][lastSlashPos+9:-4]
                        
            
        elif (mode == 'film'):

            # Ermittlung Name
            lastSlashPos = results['name'].rfind("/");
            results['name'] = results['name'][results['name'].rfind("/")+1:-14];

            # Ermittlung 3D
            
            if results['name'][-4:] == '(3D)':
                results['name'] = results['name'][:-5]
                try:    
                    results['dimension'] = root[0][1].find('MultiView_Layout').text
                except:
                    results['dimension'] = str(raw_input('Um was fuer ein 3D handelt es sich bei %s?\n' % results['name']))

            # Aufloesung und Name Formatieren
            if results['name'][-6:] == '(720p)':
                results['resolution'] = '720p'
                results['name'] = results['name'][:-7]
            if results['name'][-7:] == '(1080p)':
                results['resolution'] = '1080p'
                results['name'] = results['name'][:-8]
            if results['name'][-4:] == '(SD)':
                results['resolution'] = 'SD'
                results['name'] = results['name'][:-5]

            # 3D formatieren
            if results['dimension'][:4] == 'Side':
                results['dimension'] = 'HSBS'
            if results['dimension'][:3] == 'Top':
                results['dimension'] = 'HOU'

        ### Formatierung aller Metadaten
    
        # Formatierung des Videoformats

        if results['videoformat'] == 'Matroska':
            results['videoformat'] = 'mkv';

        # Audiocodecs müssen nicht formatiert werden

        # Umrechnung der Laufzeit in Sekunden

        durationsplit = results['duration'].split()
        results['duration'] = 0

        for i in range(0,len(durationsplit),1):
            if durationsplit[i][-1] == 'h':
                results['duration'] += int(durationsplit[i][:-1]) * 3600
            elif durationsplit[i][-1] == 'n':
                results['duration'] += int(durationsplit[i][:-2]) * 60
            elif (durationsplit[i][-1] == 's') and (durationsplit[i][-2] != 'm'):
                results['duration'] += int(durationsplit[i][:-1])

        # Formatierung der Bitraten

        if results['totalbitrate'][-4:] == 'Mbps':
            results['totalbitrate'] = str(int(float(results['totalbitrate'][:-5].replace(' ',''))*1024))
        else:
            results['totalbitrate'] = results['totalbitrate'][:-5].replace(' ','')

        if (results['gerlanguage'] != None):
            results['geraudiobitrate'] = results['geraudiobitrate'][:-5].replace(' ','')
            if len(results['geraudiobitrate']) > 4:
                results['geraudiobitrate'] = results['geraudiobitrate'][8:]

            # Formatierung der deutschen Audiokanäle

            if (len(results['gerchannels']) > 10):
                results['gerchannels'] = results['gerchannels'].split('/')[-1][1]
            else:
                results['gerchannels'] = results['gerchannels'][0]
            

        # Formatierung der Auflösung

        results['width'] = results['width'][:-6].replace(' ','')
        results['height'] = results['height'][:-6].replace(' ','')

        # Formatierung einer eventuell vorhandenen englischen Tonspur

        if results['englanguage'] != None:

            results['engaudiobitrate'] = results['engaudiobitrate'][:-5].replace(' ','')
            if len(results['engaudiobitrate']) > 4:
                results['engaudiobitrate'] = results['engaudiobitrate'][8:]
            if (len(results['engchannels']) > 10):
                results['engchannels'] = results['engchannels'].split('/')[-1][1]
            else:
                results['engchannels'] = results['engchannels'][0]

        # Rueckgabe des Ergebnis-Dictionaries
        return results
        
    def getSeasonMetaData(self, path, mode='serie'):

        results = {} # Dictionary mit den Metadaten

        if (mode == 'serie'):

            # Staffel ermitteln
            pathSplit = path.replace('/',' ').split()
            for x in range(0,len(pathSplit)):
                if (pathSplit[x] == 'Staffel'):
                    results['season'] = pathSplit[x + 1]

            # Auflösung ermitteln
            if "(720p)" in path:
                results['resolution'] = "720p";
            elif "(1080p)" in path:
                results['resolution'] = "1080p"
            elif "(SD)" in path:
                results['resolution'] = "SD"
            else:
                print("Keine Auflösung im Ordnernamen!!!")
                sys.exit(1)

            # Sound ermitteln
            if "(2.0)" in path:
                results['sound'] = "2.0";
            elif "(5.1)" in path:
                results['sound'] = "5.1"
            else:
                print("Kein Sound im Ordnernamen!!!")
                sys.exit(1)

        elif (mode == 'replace'):
            for x in (path.split('/')):
                for y in range(0,100):
                    if (x[0] == 'S') & (x[1:3] == str(y).zfill(2)):
                        results['season'] = int(x[1:3])
                        break

        # Rueckgabe des Dictionaries mit Metadaten
        return results

    def copyMovies(self, listFile, destination):

        database = Database()
        database.connect()
        imdbList = []

        mediaPath = '/mounts/Media/'
        #mediaPath = '/mounts/Media/' # Mountpoint aller Festplatten
        moviesAvailable = subprocess.Popen('find %s' % mediaPath, shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE).communicate()[0].split('\n') # aller Filme, momentan angeschlossener Festplatten
        remainingFile = '/tmp/remaining.csv'        
        
        with open(listFile, 'r') as f:
            csvReader = csv.reader(f)
            firstRow = True
            for row in csvReader:
                if (row != []):
                    if ((len(row[0]) > 0) | (len(row[-1]) > 0)) & ((len(row[0]) != 3) | (len(row[0]) != len(row[-1]))):
                        if (firstRow == True):
                            for i in range(0,len(row)):
                                print('Spalte %d:\t%s' % (i, row[i]))
                            imdbColumn = int(raw_input('Welche Spalte enthält die imdbID? [0,1,2, ...]\n'))
                            dimensionColumn = raw_input('Welche Spalte enthält die 3D Information? [0,1,2, ..., keine, alle = alle sind 3D]\n')
                            try:
                                dimensionColumn = int(dimensionColumn)
                            except ValueError:
                                pass
                            useFirstRow = raw_input('Enthält die angezeigte Zeile bereits einen Film?\n')
                            if (len(useFirstRow) > 0):
                                useFirstRow = ('j' == useFirstRow[0])
                            else:
                                useFirstRow = False
                        if (useFirstRow == True) | (firstRow == False):
                            if dimensionColumn == 'alle':
                                imdbList.append((row[imdbColumn], '_%_'))
                            elif dimensionColumn != 'keine':
                                imdbList.append((row[imdbColumn], row[dimensionColumn]))
                            else:
                                imdbList.append((row[imdbColumn], ''))
                            firstRow = False
                        else:
                            firstRow = False
        #if (imdbList[0][0][:2] == 'tt'):
        #   for x in range(len(imdbList)):
        #        imdbList[x] = imdbList[x][0][2:]
        abfrage = "SELECT name, 3d, imdbID FROM Filme WHERE ("
        for x in imdbList:
            abfrage = abfrage + ' (imdbID="%s" AND 3d LIKE "%s") OR' % (x[0], x[1])
        abfrage = abfrage[:-3] + ')'
        database.instance.execute(abfrage)
        nameList = database.instance.fetchall() # Array mit allen Namen, die zu den IMDB-IDs gehören

        # Ausgabe der Gesamtgröße aller Filme
        database.instance.execute(abfrage.replace('name, 3d, imdbID', 'FORMAT(SUM(size)/pow(1024,3),2)'))
        print('Gesamtgröße aller Filme in der Liste: %s GB' %database.instance.fetchall()[0][0])

        abfrage = "SELECT SUM(size) FROM Filme WHERE ("        
        
        if (len(nameList) != len(imdbList)):
            print('Es wurden %d von %d Filmen in der Datenbank gefunden! (vielleicht 3D in wishlist?)' % (len(nameList), len(imdbList)))
            raw_input('Fortfahren?')
        filesToCopy = []
        for y in nameList:
            if (y[1] != ''):
                for x in moviesAvailable:
                    if (('/%s (' % y[0].decode('iso-8859-1') in x.decode('utf-8')) & ('3D' in x)):
                        filesToCopy.append(x) # absoluter Pfad zu allen gefundenen Filmen
                        try:                        
                            imdbList.remove((y[2], 'HSBS'))
                        except ValueError:
                            try:
                                imdbList.remove((y[2], 'HOU'))
                            except ValueError:
                                imdbList.remove((y[2], '_%_'))
                        abfrage += ' (imdbID="%s" AND 3d!="") OR' % y[2]
                        break
                        
            else:
                for x in moviesAvailable:
                    if (('/%s (' % y[0].decode('iso-8859-1') in x.decode('utf-8')) & ('3D' not in x)):
                        filesToCopy.append(x) # absoluter Pfad zu allen gefundenen Filmen
                        imdbList.remove((y[2], ''))
                        abfrage += ' (imdbID="%s" AND 3d="") OR' % y[2]
                        break
                    
        # Falls keine Filme auf den Festplatte gefunden wurde, würde die Abfrage fehlschlagen
        if (abfrage[-1] != 'R'):
            print('Keine Filme auf den Festplatten gefunden')
            sys.exit(1)
            
        database.instance.execute(abfrage[:-3] + ')')
        size = int(database.instance.fetchall()[0][0])/pow(1024,3) # Größe aller Filme        
        
        if (len(filesToCopy) < len(nameList)):
            print('Es wurden nur %d von %d Filmen auf den Festplatten gefunden!' % (len(filesToCopy), len(nameList)))
            raw_input('Fortfahren?')
        copiedSize = 0
        # Kopiervorgang
        print('Total: %d GB' % size)
        for x in filesToCopy:
            if not os.path.exists(os.path.join(destination, os.path.basename(x))):
                print("COPY: %s\t%d%% (%d/%d GB)" % (x, (100 * (copiedSize/pow(1024,3))/size), copiedSize/pow(1024,3), size)) 
                shutil.copy(x, os.path.join(destination, os.path.basename(x)))
                copiedSize = copiedSize + os.path.getsize(x)
            else:
                copiedSize = copiedSize + os.path.getsize(x)
        
        if len(imdbList) > 0:
            if not os.path.isfile(remainingFile):
                with open(remainingFile, 'a') as f:
                    for line in imdbList:
                        f.write('%s,%s\n' % (line[0], line[1]))	

            else:
                with open(remainingFile, 'w') as f:
                    for line in imdbList:
                        f.write('%s,%s\n' % (line[0], line[1]))
            print('\n%s wurde erstellt!!!\n' % remainingFile)
                
class WikipediaHTMLParser(HTMLParser):

    def __init__(self):
        HTMLParser.__init__(self)
        self.season = None
        # Initialisierung aller notwendigen Variablen
        self.filemanager = FileManager()
        self.episodes = []
        self.h2 = False
        self.h3 = False
        self.seasonFound = False
        self.rowColumnCount = 0
        self.columnCount = 0
        self.column = None
        self.table = False
        self.row = False
        self.found = False

    # Entgegennamhe der URL

    def parse(self, url, season):

        self.season = season
        page = urllib.urlopen(url).readlines()
        self.feed(str(page))

    # Verhalten beim Erreichen eines öffnenden Tags

    def handle_starttag(self, tag, attrs):

        # Wenn richtige Staffel in Ãberschrift gefunden wurde, wird beim Finden eines table-Tags table auf True gesetzt

        if (self.seasonFound == True) & (tag == "table"):

            self.table = True        

        # h2 wird immer auf True gesetzt, wenn ein öffnendes h2-Tag gefunden wird

        if tag == "h2":
            self.h2 = True
        if tag == "h3":
            self.h3 = True

        # wenn Tabelle gefunden wurde, werden Spalten im Header der Tabelle gezählt

        if ((tag == "td") | (tag == "th")) & (self.table == True):

            self.columnCount += 1

        # wenn noch nicht der Titel der Episode gefunden wurde, werden die Spalten in der Zeile gezählt         

        if (tag == "td") & (self.column != None) & (self.found == False):

            self.rowColumnCount += 1
        
    def handle_endtag(self, tag):
        
        # h2 oder h3 wird wieder auf False gesetzt, wenn ein schließendes h2-Tag gefunden wird

        if tag == "h2":
            self.h2 = False 
        if tag == "h3":
            self.h3 = False 

        # table wird auf False gesetzt, wenn das Ende der relevanten Tabelle gefunden wurde

        if tag == "table":
            self.table = False

        # Wenn das Ende einer Zeile in der Tabelle gefunden wird, wird found auf False gesetzt, da der Titel in der nächsten Zeile noch nicht gefunden wurde

        if (tag == "tr") & (self.table == True):
            self.found = False
            self.rowColumnCount = 0

    def handle_data(self, data):
        
        # wenn Staffel (season) als Ãberschrift der Ordnung 2 gefunden wird, wird seasonFound auf True gesetzt

        if (data == ("Staffel " + str(self.season))) & ((self.h2 == True) | (self.h3 == True)):
            self.seasonFound = True

        # Wenn der Tabellenkopf mit dem Deutschen Titel gefunden wird, wird column auf die richtige Spalte gesetzt und seasonFound auf False gsetzt, damit nicht weider nach der richtigen Spalte gesucht wird

        if (data.find("eutsch") == 1) & (self.seasonFound == True):
            self.column = self.columnCount
            self.columnCount = 0
            self.seasonFound = False

        # Wenn sich der Parser in der richtigen Spalte und gleichzeitig der richtigen Tabelle befindet, so wird der Inhalt der Zelle an das Array episodes angehängt

        if (self.column == self.rowColumnCount) & (self.table == True):
            self.episodes.append(data)
            self.rowColumnCount = 0
            self.found = True

class FilmParser(object):

    def getCovers(self, path):

        database = Database()
        database.connect()

        database.instance.execute("SELECT DISTINCT imdbID FROM Filme")
        imdbIDs = database.instance.fetchall()

        imdbParser = imdb.IMDb()
        for x in imdbIDs:
            if not (os.path.exists(os.path.join(path, '%s.jpg' % x))):
                try:
                    url = imdbParser.get_movie(x[0])['cover']
                    urlSplit = url.split('_')
                    url = '%s_%s_SX5000_SY5000_%s' % (urlSplit[0], urlSplit[1], urlSplit[4])
                    urllib.urlretrieve(url, '%s%s.jpg' % (path, x[0]))
                    print(url)
                except KeyError:
                    print('No cover for: %s' % x[0])

    def __init__(self):

        # Variable fuer Dictionaries aller Filme
        self.movies = []

        # Verbindung zur Datenbank aufbauen
        self.database = Database()
        self.database.connect()
    
    def getValues(self, path):

        # Erzeuge Dictionary fuer aktuellen Film
        values = {}
        values['path'] = path
        values['personID'] = []
        values['personName'] = []
        values['genres'] = []
        values['year'] = None
        values['rating'] = None

        # Metadaten abrufen

        values['metaData'] = FileManager().getMetaData(path, 'film')

        # Bestimmung des Speicherorts

        values['hdd'] = '1'
        #for folder in values['path'].split('/'):
        #    if folder[:3] == 'HDD':
        #        values['hdd'] = folder[-1]
        if values['hdd'] == None:
            print('Keine Speicherort fuer %s gefunden\n' % values['metaData']['name'])
            sys.exit(0)

        # Initialisierung des Parsers und Abruf der Informationen zur imdbID

        values['imdbID'] = None
        for word in values['path'].replace('\\','').replace('.',' ').split(' '):
            if (len(word) == 9) & (word[0] == '(') & (word[-1] == ')'):
                values['imdbID'] = word[1:-1]
        if (values['imdbID'] == None):
            print('Keine idmbID fuer %s gefunden' % values['metaData']['name'])
            sys.exit(1)
        IMDBparser = imdb.IMDb()
        movie = IMDBparser.get_movie(values['imdbID'])

        # Parsen aller Informationen

        values['year'] = movie['year']
        values['rating'] = movie['rating']
        schauspieler = movie['actors']
        genres = movie['genre']

        for person in schauspieler:

            values['personID'].append(person.personID)
            values['personName'].append(person.values()[0])

        for genre in genres:

            values['genres'].append(genre)

        self.movies.append(values)

    def calcMd5(self):

        number = 1
        for movie in self.movies:        
            print('Berechne md5 %s von %s' % (number, len(self.movies)))
            movie['md5'] = subprocess.Popen(['md5sum', movie['path']], shell=False, stdout=subprocess.PIPE, stderr=subprocess.PIPE).communicate()[0].split()[0]
            #movie['md5'] = 'c763d1aa80620530e494b1331151FAKE'
            number += 1

    def printOverview(self):

        iteration = 1

        for movie in self.movies:
            if iteration == 3:
                if ('nein' == raw_input('\nWeiter? (ENTER = Ja, oder "nein" zum überspringen)\n')):
                    break
                iteration = 1
            print('\nName:\t\t\t%s' % movie['metaData']['name'])
            print('3D:\t\t\t%s' % movie['metaData']['dimension'])
            print('Dateigroesse:\t\t%s GB' % str(float(movie['metaData']['size'])/(1024*1024*1024)))
            #print('md5-hash:\t\t%s' % movie['metaData']['md5']
            print('Videocodec:\t\t%s' % movie['metaData']['videoformat'])
            print('Laufzeit:\t\t%d' % int(movie['metaData']['duration']/60))
            print('Gesamtbitrate:\t\t%s' % movie['metaData']['totalbitrate'])
            print('Aufloesung:\t\t%s' % movie['metaData']['resolution'])
            print('Bildbreite:\t\t%s' % movie['metaData']['width'])
            print('Bildhoehe:\t\t%s' % movie['metaData']['height'])
            print('\nSprache:\t\t%s' % movie['metaData']['gerlanguage'])
            print('Audio-Codec:\t\t%s' % movie['metaData']['geraudiocodec'])
            print('Audio-Bitrate:\t\t%s' % movie['metaData']['geraudiobitrate'])
            print('Anzahl Channels:\t%s' % movie['metaData']['gerchannels'])

            ''' wird nur ausgegeben, falls Englische Tonspur vorhanden ist'''

            if movie['metaData']['englanguage'] != None:
                print('\nSprache:\t\t%s' % movie['metaData']['englanguage'])
                print('Audio-Codec:\t\t%s' % movie['metaData']['engaudiocodec'])
                print('Audio-Bitrate:\t\t%s' % movie['metaData']['engaudiobitrate'])
                print('Anzahl Channels:\t%s' % movie['metaData']['engchannels'])
            iteration += 1
        raw_input('md5 berechne?')

    def submit(self):

        for movie in self.movies:
      
            moviesBegin = self.database.instance.execute("SELECT name FROM Filme")

            # Variablen, die fix sein sollten

            views = 0 #raw_input('Wie oft hast du den Film bereits angesehen?\n')
            check = 'null' #raw_input('Ist der Film fehlerfrei?\n\n0 - Film enthaelt Fehler\n1 - Film ist fehlerfrei\nnull - Film wurde noch nicht geprueft\n\n')
            comment = '' #raw_input('Angabe von Kommentare:\n')
            
            befehl = "INSERT INTO Filme VALUES('%s','%s',%s,%d,'%s','%s','%s',%d,%s,'%s',%s,%s,'%s',%s,%s,'%s',%s,%s,%s,%s,%s,%s,'%s','%s',%s)" % (movie['imdbID'], movie['metaData']['name'], movie['year'], movie['metaData']['size'], movie['md5'], movie['metaData']['dimension'], movie['metaData']['videoformat'], movie['metaData']['duration'], movie['metaData']['totalbitrate'], movie['metaData']['resolution'], movie['metaData']['width'], movie['metaData']['height'], movie['metaData']['geraudiocodec'], movie['metaData']['geraudiobitrate'], movie['metaData']['gerchannels'], movie['metaData']['engaudiocodec'], movie['metaData']['engaudiobitrate'], movie['metaData']['engchannels'], movie['hdd'], movie['rating'], check, views, comment, movie['metaData']['added'],'NULL')

            befehl = befehl.replace("'NULL'","NULL")
            print(befehl)
            self.database.instance.execute(befehl)
            self.database.connection.commit()

            ### Eintragen der IMDB Werte

            # Eintragen der Schauspieler

            self.database.instance.execute("SELECT schauspielerID FROM Schauspieler")
            schauspielerInDB = self.database.instance.fetchall()

            bereitsInListe = False
            for x in range(len(movie['personID'])):

                ID = movie['personID'][x]
                name = movie['personName'][x]

                for y in schauspielerInDB:
            
                    y = y[0]
                    if (y == ID):
                        bereitsInListe = True

                if (bereitsInListe == False):
                    befehl = "INSERT INTO Schauspieler VALUES(%s, %s)"
                    self.database.instance.execute(befehl, (name, ID)) 
                    self.database.connection.commit()
                else:
                    bereitsInListe = False
        
                befehl = "INSERT INTO FilmSchauspieler VALUES(%s, %s)"
                self.database.instance.execute(befehl, (movie['imdbID'], ID))
                self.database.connection.commit()

            # Eintragen der Genres

            self.database.instance.execute("SELECT engname, genreID FROM Genre")
            genreInDB = self.database.instance.fetchall()

            genreID = None

            for x in movie['genres']:
                for y in genreInDB:
                    if (y[0] == x):
                        bereitsInListe = True
                        genreID = y[1]
                

                if (bereitsInListe == False):

                    # Anzahl der Kategorien muss immer neu bestimmt werden, da vorher bereits welche hinzugefügt werden konnten
                    self.database.instance.execute("SELECT genreID FROM Genre")
                    genreID = len(self.database.instance.fetchall()) + 1           
    
                    befehl = "INSERT INTO Genre VALUES(%s, %s, NULL)"
                    self.database.instance.execute(befehl, (genreID, x)) 
                    self.database.connection.commit()
 
                else:
                    bereitsInListe = False

                befehl = "INSERT INTO FilmGenre VALUES(%s, %s)"
                #print(befehl
                self.database.instance.execute(befehl, (movie['imdbID'], genreID))
                self.database.connection.commit()

            # Pruefung ob ein Datensatz in die Datenbank Uebernommen wurde

            moviesEnd = self.database.instance.execute("SELECT name FROM Filme")

            if (moviesBegin + 1) != moviesEnd:
               print("*** ES WURDE KEIN DATENSATZ IN DIE DATENBANK UEBERNOMMEN ***" )

        self.database.instance.close();

class SerienParser(object):

    def __init__(self):
        self.episodes = [] # haelt alle Dictionaries fuer die Episoden
        self.seasonMetaData = {}
        # Datenbankverbindung aufbauen
        self.database = Database()
        self.database.connect()

    def replaceEpisode(self, datei):

        self.episodes.append(FileManager().getMetaData(datei, 'episode'))
        self.seasonMetaData = FileManager().getSeasonMetaData(datei, 'replace')

    def getProperties(self, datei):

        files = subprocess.Popen(['find', datei], shell=False, stdout=subprocess.PIPE, stderr=subprocess.PIPE).communicate()[0].split("\n")
        files.sort()

        self.seasonMetaData = FileManager().getSeasonMetaData(files[1])

        for x in files:
            if x[-4:-3] == ".":
                print(x)
                self.episodes.append(FileManager().getMetaData(x, 'episode'))

    def printOverview(self):
      
        for x in self.episodes:

            print("\nName:\t\t\t%s" % x['name'])
            print("Dateigroesse:\t\t%s" % str(float(x['size'])/(1024*1024*1024)) + " GB")
            print("md5-hash:\t\t%s" % x['md5'])
            print("Videocodec:\t\t%s" % x['videoformat'])
            print("Laufzeit:\t\t%d" % int(x['duration']/60))
            print("Gesamtbitrate:\t\t%s" % x['totalbitrate'])
            print("Aufloesung:\t\t%s" % self.seasonMetaData['resolution'])
            print("Bildbreite:\t\t%s" % x['width'])
            print("Bildhoehe:\t\t%s" % x['height'])
            print("\nSprache:\t\t%s" % x['gerlanguage'])
            print("Audio-Codec:\t\t%s" % x['geraudiocodec'])
            print("Audio-Bitrate:\t\t%s" % x['geraudiobitrate'])
            print("Anzahl Channels:\t%s" % x['gerchannels'])

            ''' wird nur ausgegeben, falls Englische Tonspur vorhanden ist'''

            if x['englanguage'] != None:

                print("\nSprache:\t\t%s" % x['englanguage'])
                print("Audio-Codec:\t\t%s" % x['engaudiocodec'])
                print("Audio-Bitrate:\t\t%s" % x['engaudiobitrate'])
                print("Anzahl Channels:\t%s" % x['engchannels'])

            print("\n\nAufnahmedatum:\t\t" + x['added'])

    def checkEquality(self):

        # Test der Episoden auf Gleichheit
        width_test = 1;
        height_test = 1;
        videoformat_test = 1;
        geraudiocodec_test = 1;
        geraudiobitrate_test = 1;
        gerchannels_test = 1;
        engaudiocodec_test = 1;
        engaudiobitrate_test = 1;
        engchannels_test = 1;
        abweichung_prozent = 0.05


        for x in range(0,len(self.episodes)-1):
            if (float(self.episodes[x]['width']) < int((1 - abweichung_prozent) * int(self.episodes[x+1]['width']))) | (float(self.episodes[x]['width']) > int((1 + abweichung_prozent) * int(self.episodes[x+1]['width']))):
                width_test = 0;
            if (float(self.episodes[x]['height']) < int((1 - abweichung_prozent) * int(self.episodes[x+1]['height']))) | (float(self.episodes[x]['height']) > int((1 + abweichung_prozent) * int(self.episodes[x+1]['height']))):
                height_test = 0;
            if (self.episodes[x]['gerlanguage'] != None) & (self.episodes[x+1]['gerlanguage'] != None):
                if (float(self.episodes[x]['geraudiobitrate']) < int((1 - abweichung_prozent) * int(self.episodes[x+1]['geraudiobitrate']))) | (float(self.episodes[x]['geraudiobitrate']) > int((1 + abweichung_prozent) * int(self.episodes[x+1]['geraudiobitrate']))):
                    geraudiobitrate_test = 0;
            if (self.episodes[x]['englanguage'] != None) & (self.episodes[x+1]['englanguage'] != None):
                if (float(self.episodes[x]['engaudiobitrate']) < int((1 - abweichung_prozent) * int(self.episodes[x+1]['engaudiobitrate']))) | (float(self.episodes[x]['engaudiobitrate']) > int((1 + abweichung_prozent) * int(self.episodes[x+1]['engaudiobitrate']))):
                    engaudiobitrate_test = 0;
            if self.episodes[x]['videoformat'] != self.episodes[x+1]['videoformat']:
                videoformat_test = 0;
            if self.episodes[x]['geraudiocodec'] != self.episodes[x+1]['geraudiocodec']:
                geraudiocodec_test = 0;
            if self.episodes[x]['engaudiocodec'] != self.episodes[x+1]['engaudiocodec']:
                engaudiocodec_test = 0;
            if self.episodes[x]['engchannels'] != self.episodes[x+1]['engchannels']:
                engchannels_test = 0;
            if self.episodes[x]['gerchannels'] != self.episodes[x+1]['gerchannels']:
                gerchannels_test = 0;

        print("\nBildbreite:\t\t" + str(width_test))
        print("bildhoehe:\t\t" + str(height_test))
        print("Videocodec:\t\t" + str(videoformat_test))
        print("Deutscher Audiocodec:\t" + str(geraudiocodec_test))
        print("Deutsche Audiobitrate:\t" + str(geraudiobitrate_test))
        print("Deutsche Channels:\t" + str(gerchannels_test))
        print("Englischer Audiocodec:\t" + str(engaudiocodec_test))
        print("Englische Audiobitrate:\t" + str(engaudiobitrate_test))
        print("Englische Channels:\t" + str(engchannels_test) + "\n")

        raw_input("Weiter?\n")

    def submit(self, mode='season'):

        # Abfrage der Serienliste
        
        befehlSerienListe = "SELECT name,series_nr FROM Serien";
        self.database.instance.execute(befehlSerienListe);
        SerienListe = self.database.instance.fetchall();

        # Auswahl der richtigen Serie

        print("\n\nUm was für eine Serien handelt es sich?")
        print("Es stehen folgende Serien zur Auswahl:\n")

        for i in range(0,len(SerienListe)):
            print(str(i) + "   " + SerienListe[i][0].decode('iso-8859-1'))

        Serien_Input = str(raw_input("\nBitte gib die entsprechende NUMMER ein!\n\nSollte es sich um eine neue Serie handeln, so gib 'neu' ein!\n\n"));

        # neue Serie wird angelegt und neue Eingabe gefordert

        if Serien_Input == "neu":
            neueSerie = str(raw_input("\nBitte gibt den Namen der neuen Serie ein:\n"))
            SerieEnde = str(raw_input("\nIst die Serie abgeschlossen?\n\n0 - Serie läuft noch\n1 - Serie ist abgeschlossen\n"))
            befehl_neu = "INSERT INTO Serien VALUES('%s',%s,%d)" % (neueSerie, SerieEnde, int(SerienListe[-1][1]) + 1)
            self.database.instance.execute(befehl_neu);
            self.database.connection.commit();
            self.database.instance.execute(befehlSerienListe);
            SerienListe = self.database.instance.fetchall();

            print("\n\nUm was für eine Serien handelt es sich?")
            print("Es stehen folgende Serien zur Auswahl:\n")

            for i in range(0,len(SerienListe)):
                print(str(i) + "   " + SerienListe[i][0].decode('iso-8859-1'))

            Serien_Input = str(raw_input("Bitte gib die entsprechende NUMMER ein!\n"))

        # Berechnung der neuen Staffelnummer

        # Abfrage noch fehlender Werte
        if (mode == 'season'):
            views = raw_input("Wie oft hast du die Staffel bereits angesehen?\n")
            check = raw_input("Ist die Staffel fehlerfrei?\n\n0 - Staffel enthaelt Fehler\n1 - Staffel ist fehlerfrei\nnull - Staffel wurde noch nicht geprueft\n\n")
            hdd = raw_input("Auf welcher Festplatte befindet sich die Staffel?\n")
            comment = raw_input("Angabe von Kommentaren:\n")

            for x in self.episodes:

                if x['episodenumber'] == 999:
                    x['source'] = raw_input('Aus welche Quelle stammt das Special "%s"?' % x['name'])
                    #x['source'] = 'DVD'

            befehl_season_nr = "SELECT season_nr FROM Staffeln ORDER BY season_nr ASC";
            self.database.instance.execute(befehl_season_nr);
            all_season_nrs = self.database.instance.fetchall();
            season_nr = int(all_season_nrs[-1][0]) + 1

        series_nr = SerienListe[int(Serien_Input)][1]

        # Ermittlung restlicher Werte im Fall, dass eine Episode ersetzt werden soll

        if (mode == 'replaceEpisode'):

            check = "NULL"
            comment = raw_input("Angabe von Kommentaren:\n")

            befehl_fehlende_Werte = "Select Staffeln.season_nr, Episoden.views, Episoden.hdd from Serien, Staffeln, Episoden where Serien.series_nr = Staffeln.series_nr AND Staffeln.season_nr = Episoden.season_nr AND Staffeln.season = %s AND Serien.series_nr = %s AND Episoden.episodenumber = %d" % (self.seasonMetaData['season'], series_nr, self.episodes[0]['episodenumber'])
            self.database.instance.execute(befehl_fehlende_Werte)
            fehlende_Werte = self.database.instance.fetchall()

            hdd = fehlende_Werte[0][2]
            views = fehlende_Werte[0][1]
            season_nr = int(fehlende_Werte[0][0])

        # Prüfung auf Korrektheit

        print("\n\nViews:\t\t\t%s" % views)
        print("Checked:\t\t%s" % check)
        print("Speicherort\t\t%s" % hdd)
        print("Kommentar:\t\t%s" % comment)
        print("Staffel:\t\t%s" % self.seasonMetaData['season'])
        if (mode == 'season'):
            print("Auflösung:\t\t%s" % self.seasonMetaData['resolution'])
            print("Quelle:\t\t\t%s" % self.episodes[0]['source'])
            print("Sound:\t\t\t%s" % self.seasonMetaData['sound'])
        print("Serienname:\t\t%s" % SerienListe[int(Serien_Input)][0])

        raw_input("\nSind alle ermittelten Werte korrekt?\n")

        # Eintragen in Datenbank

        if (mode == 'season'):
            befehlStaffeln = "INSERT INTO Staffeln VALUES(%s,'%s','%s','%s',%s,'%s',%d,%s)" % (self.seasonMetaData['season'], self.seasonMetaData['resolution'], self.seasonMetaData['sound'], self.episodes[0]['source'], check, comment, season_nr, series_nr)
            befehlStaffeln = befehlStaffeln.replace("'NULL'","NULL")
            print(befehlStaffeln)
            self.database.instance.execute(befehlStaffeln);
            self.database.connection.commit();    

        elif (mode == 'replaceEpisode'):

            # Pruefe Anzahl Episoden vorher
            self.database.instance.execute("SELECT name FROM Episoden")
            number_begin = len(self.database.instance.fetchall())
 
            # Loesche
            delete_command = "DELETE FROM Episoden WHERE Episoden.series_nr = %s AND Episoden.season_nr = %d AND Episoden.episodenumber = %d" % (series_nr, season_nr, self.episodes[0]['episodenumber'])
            self.database.instance.execute(delete_command)
            self.database.connection.commit()

            # Pruefe Anzahl Episoden hinterher
            self.database.instance.execute("SELECT name FROM Episoden")
            number_end = len(self.database.instance.fetchall())

            if (number_begin - number_end != 1):
                print('Es wurden %d Episoden gelöscht !!!' % number_begin - number_end)
                sys.exit(0)
            else:
                print('Das Loeschen war erfolgreich !!!')


        for x in self.episodes:

            befehlEpisoden = "INSERT INTO Episoden VALUES(%d,'%s','%s',%d,%d,'%s','%s',%s,%s,%s,'%s',%s,%s,'%s',%s,%s,%s,'',%s,%s,%s,'%s',%d,%s)" % (x['episodenumber'], x['name'], x['source'], x['size'], x['duration'], x['md5'], x['videoformat'], x['width'], x['height'], x['totalbitrate'], x['geraudiocodec'], x['geraudiobitrate'], x['gerchannels'], x['engaudiocodec'], x['engaudiobitrate'], x['engchannels'], hdd, check, view, 'NULL',  x['added'], season_nr, series_nr,)
            befehlEpisoden = befehlEpisoden.replace("'NULL'","NULL")
            print(befehlEpisoden)
            self.database.instance.execute(befehlEpisoden)
            self.database.connection.commit()

        self.database.instance.close()

    def renameSeason(self):

        filemanager = FileManager()
        root = sys.argv[2]
        found = str(os.popen("find " + filemanager.escape(root)).read()).split("\n")

        season = raw_input("Um welche Staffel handelt es sich?\n")
        resolution = raw_input("Welche Auflösung hat die Staffel?\n")
        sound = raw_input("Wie viele Audiokanäle hat die Staffel?\n")
        source = raw_input("Aus welcher Quelle stammt die Staffel?\n")
        url = raw_input("Von welcher Wikipedia-Seite sollen die Informationen bezogen werden?\n")

        parser = WikipediaHTMLParser()
        parser.parse(url, season)

        folder = "Staffel " + str(season) + " (" + resolution + ") (" + sound + ") (" + source + ")"

        print(folder + "\n")

        episodeCount = 0

        '''
        zusätzliche Selektionskriterien der richtigen Folgen: !!! muss in beide IF Bedingungen eingefügt werden !
        (str(i).zfill(3) in x)      # Schema: 001, 002, ... , 125
        '''

        for x in found:
            try:
                size = os.path.getsize(x)
            except:
                size = 0

            if (len(str(x)) > 4):

                if ((x[-4:] == ".mkv") | (x[-4:] == ".avi") | (x[-4:] == ".mp4") | (x[-4:] == ".mpg")) & (size > (100*1024*1024)):

                    for i in range(1, len(parser.episodes)+1):

                        ''' nachfolgend die Selektionskriterien eintragen + in nächster Schleife '''

                        # i += 29 # aktivieren, wenn Episodennummern abweichend

                        if ( ((str(season) + "x" + str(i).zfill(2)) in x) | (("e" + str(i).zfill(2)) in x) | (("E" + str(i).zfill(2)) in x) | (((str(season) + str(i).zfill(2)) in x) & (int(season) != 1)) ):

                            # i -= 29 # aktivieren, wenn Episodennummern abweichend 

                            episodeFinal = "S" + str(season).zfill(2) + " E" + str(i).zfill(2) + " " + filemanager.convert(parser.episodes[i-1])  
                            episodeBefore = x[x.rfind("/")+1:]
                            print(episodeBefore + "  ->  " + episodeFinal + x[-4:])

                            episodeCount += 1

        print("\n" + str(episodeCount) + " Folgen gefunden")

        raw_input("\nSind alle Umwandlungen richtig?")

        os.popen("mkdir " + filemanager.escape(root) + filemanager.escape(folder))

        for x in found:
            try:
                size = os.path.getsize(x)
            except:
                size = 0

            if len(str(x)) > 4:

                if ((x[-4:] == ".mkv") | (x[-4:] == ".avi") | (x[-4:] == ".mp4") | (x[-4:] == ".mpg")) & (size > (100*1024*1024)):

                    for i in range(1, len(parser.episodes)+1):

                        # i += 29 # aktivieren, wenn Episodennummern abweichend

                        if ( ((str(season) + "x" + str(i).zfill(2)) in x) | (("e" + str(i).zfill(2)) in x) | (("E" + str(i).zfill(2)) in x) | (((str(season) + str(i).zfill(2)) in x) & (int(season) != 1)) ):

                            # i -= 29 # aktivieren, wenn Episodennummern abweichend

                            episode = "S" + str(season).zfill(2) + " E" + str(i).zfill(2) + " " + filemanager.convert(parser.episodes[i-1])  
                            os.popen("mv " + filemanager.escape(x) + " " + filemanager.escape(root) + filemanager.escape(folder) + "/" + filemanager.escape(episode) + x[-4:])




filemanager = FileManager()

def parseHTML():

    season = str(raw_input("Um welche Staffel handelt es sich?\n"))
    parser = WikipediaHTMLParser()
    url = str(raw_input("Bitte die Wikipedia-URL zur Episodenliste eingeben\n"))
    parser.parse(url, season)

    i=1

    for x in parser.episodes:

        episode = "S" + str(season).zfill(2) + " E" + str(i).zfill(2)   
        print(episode + " " + FileManager().convert(x))
        i+=1

def indexingFilme():

    parser = FilmParser()
    files = subprocess.Popen('find %s' % FileManager().escape(sys.argv[2]), shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE).communicate()[0]
    for x in files.split('\n'):
        if len(x) > 4:
            if x[-4] == '.':
                print(x)
                parser.getValues(x)
    parser.printOverview()
    parser.calcMd5()
    parser.submit()
    
def indexingSerien():
  
    parser = SerienParser()
    parser.getProperties(sys.argv[2])
    parser.printOverview()
    parser.checkEquality()
    parser.submit()
    #print(parser.name

def replaceEpisode():

    parser = SerienParser()
    parser.replaceEpisode(sys.argv[2])
    parser.submit('replaceEpisode')

helpText = \
'''
rename\t[path]\t\t\tbenennt Folgen einer Staffel um
serie\t[path]\t\t\ttraegt eine Staffel in die Datenbank ein
filme\t[path]\t\t\ttraegt alle Filme in die Datenbank ein
replace\t[file]\t\t\ttauscht eine Folge in der Datenbank aus
parse\t\t\t\tparst eine Serie auf Wikipedia
delete\t\t\t\tloescht Dupletten aus der Datenbank
update\t\t\t\tupdatet alle IMDB-Ratings
check\t[path]\t\t\tprueft alle Medien auf einer Festplatte auf Fehler
compare\t[file]\t\t\tvergleicht Filme in der Datenbank und der Watchlist
extract\t[path]\t\t\tentpackt alles im angegebenen Verzeichnis
cover\t[path]\t\t\tlädt die Cover aller Film in den angegebenen Ordner
copy\t[file] [destination]\tkopiert alle Filme anhand der IMDB-IDs im angegebenen File
website\t[destination]\t\terstellt die Website im Angegebenen Verzeichnis
'''

if (len(sys.argv) < 2):
    print(helpText)
elif (sys.argv[1] == 'help'):
    print(helpText)
elif (sys.argv[1] == 'serie'):
    indexingSerien()
elif (sys.argv[1] == 'filme'):
    indexingFilme()
elif (sys.argv[1] == 'replace'):
    replaceEpisode()
elif (sys.argv[1] == 'rename'):
    SerienParser().renameSeason()
elif (sys.argv[1] == 'parse'):
    parseHTML()
elif (sys.argv[1] == 'delete'):
    Database().deleteDuplicates()
elif (sys.argv[1] == 'update'):
    Database().updateRating()
elif (sys.argv[1] == 'check'):
    FileManager().checkHDD()
elif (sys.argv[1] == 'compare'):
    Database().compare()
elif (sys.argv[1] == 'extract'):
    FileManager().extractDownloads()
elif (sys.argv[1] == 'copy'):
    FileManager().copyMovies(sys.argv[2],sys.argv[3])
elif (sys.argv[1] == 'cover'):
    FilmParser().getCovers(sys.argv[2])
elif (sys.argv[1] == 'website'):
    Database().createWebsite(sys.argv[2])

