<?php
mb_internal_encoding("UTF-8");
class Media {
	private $Console;
	private $configfile;
	private $config;
	private $PfadzumEinlesen;
	private $PfadzumAusgeben;
	private $HDDID;
	private $FolderArray;
	public function __construct($configfile) {
		$this->Console = new Console();
		$this->configfile = $configfile;
		
		
		if(file_exists($configfile)){
			echo $this->Console->getColoredString("Hinweis:","black", "light_gray")." Configfile: ".$configfile." geladen!".PHP_EOL.PHP_EOL;
			$dateihandle = fopen($this->configfile,"r");
			$this->config = json_decode(fread($dateihandle, filesize($this->configfile)),true);
			
		}
		else{
			echo $this->Console->getColoredString("Hinweis:","black", "light_gray")." Configfile: ".$configfile." exisitiert nicht! Es werden defaults geladen!".PHP_EOL;
			echo "         Zum Anlegen der config bitte config save eingeben!".PHP_EOL.PHP_EOL;
			$this->config = array("configChangeTime" => time(),
							"ReadFromDir" => "/media/QNAP/FilmeZumEinlesen",
							"CoverDir" => null,
							"DB_Database" => "MediaDB_Nico",
							"DB_Username" => "MediaDB",
							"DB_Passwort" => "MediaDB",
							"DB_Server" => "192.168.0.32",
							"FolderIgnor" => array('.', '..', '.@__thumb', '@Recycle'),
							"HDD" => array(1 => array("HDDdir" => "/media/QNAP/",
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/"),
											2 => array("HDDdir" => NULL,
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/"),
											3 => array("HDDdir" => NULL,
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/"),
											4 => array("HDDdir" => NULL,
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/"),
											5 => array("HDDdir" => NULL,
														"Filme" => "Filme/",
														"3D" => "Filme3D/",
														"Serien" => "Serien/") 
			));
		}
	}
	public function config($Action){
		switch ($Action){
			case "show":
				echo $this->Console->error("Folgende Config ist geladen:","black").PHP_EOL.PHP_EOL;
				echo "Config erstellt: ".date("H:i:s d.m.Y ",$this->config["configChangeTime"])		.PHP_EOL;
				foreach ($this->config["HDD"] as $key => $value) {
					if($value["HDDdir"] != NULL){
						foreach ($value as $key2 => $value2) {
						echo "HDD ".$key.": ".$key2.": ".$value2.PHP_EOL;
						}
					}
				}
				echo PHP_EOL;
				break;
			case "save":
				echo $this->Console->error("Config gespeichert!", "green").PHP_EOL.PHP_EOL;
				$dateihandle = fopen($this->configfile,"w");
				fwrite($dateihandle, json_encode($this->config, JSON_PRETTY_PRINT));
				fclose($dateihandle);
				break;
			default:
				echo $this->Console->getColoredString("Kein Parameter für Config übergeben","red", "light_gray").PHP_EOL.PHP_EOL;
				
				break;
		}
	}
	public function filme($action = "einlesen"){
		$start = time();
		if($action == "einlesen"){
			//var_dump($this->config);
			echo $this->Console->getColoredString("Filme > einlesen", "black", "light_gray") .PHP_EOL;
			
			echo "In welchen Verzeichnis liegen die einzulesenden Dateien? ( nur Enter = ".$this->config["ReadFromDir"].")" .PHP_EOL;
			$Pfad = trim(fgets(STDIN));
			$this->PfadzumEinlesen = (strlen($Pfad)>0?$Pfad:$this->config["ReadFromDir"]);
			if(!is_dir($this->PfadzumEinlesen)){
				return $this->Console->error("Pfad Eingabe exisitiert nicht!").PHP_EOL;
			}else {
				echo "    Verzeichnis ".$this->PfadzumEinlesen." wird für Eingabe verwendet".PHP_EOL;
			}
			echo PHP_EOL;
			
			echo "Auf welche Festplatte sollen die Filme gespeichert werden? ( nur Enter = 1)" .PHP_EOL;
			$hddid = trim(fgets(STDIN));
			$this->HDDID = (strlen($hddid)>0?$hddid:1);
			$this->PfadzumAusgeben = $this->config["HDD"][$this->HDDID]["HDDdir"];
			foreach ($this->config["HDD"][$this->HDDID] as $key => $value) {
				if(!($key == "HDDdir")){
					if(!is_dir($this->PfadzumAusgeben.$value)){	return "   ".$this->Console->error("Pfad für Ausgabe exisitiert nicht!").PHP_EOL;        }
					else {									echo "    Verzeichnis ".$this->PfadzumAusgeben.$value." wird für ".$key." als Ausgabe verwendet".PHP_EOL;	}
				}
			}
			echo PHP_EOL;
			
			echo "Starte verarbeitung der Filme:".PHP_EOL.PHP_EOL;
			$FilmeArr = array();
			$this->FolderArray = array();
			$FilmeArr = $this->dirtoArray($this->PfadzumEinlesen);
			$fehlerArr = array("");
			$Counter=0;
			//var_dump($FilmeArr);
			foreach ($FilmeArr as $value) {
				//echo " ".$this->PfadzumEinlesen.'/'.(strlen($value[0])>0?$value[0].'/':'').$value[1].PHP_EOL;
				
				$ret = $this->parseMovie((strlen($value[0])>0?$value[0].'/':''), $value[1]);
				if($ret == false){
					echo $this->Console->getColoredString("       ","black", "red").PHP_EOL;
					$fehler = $this->Console->getColoredString("Fehler!","black", "red")." ".$this->PfadzumEinlesen.'/'.(strlen($value[0])>0?$value[0].'/':'').$value[1].PHP_EOL;
					echo $fehler;
					$fehlerArr[] = $fehler;
					echo $this->Console->getColoredString("       ","black", "red").PHP_EOL;
				}
				$end = time();
				$Counter++;
				$laufzeit = $end - $start;
					$H = floor($laufzeit / 3600);
					$i = ($laufzeit / 60) % 60;
					$s = $laufzeit % 60;
				$Durchschnitt = $laufzeit/$Counter;
					$Hd = floor($Durchschnitt / 3600);
					$id = ($Durchschnitt / 60) % 60;
					$sd = $Durchschnitt % 60;
				//echo ;
				
				$status =  "Laufzeit: ".sprintf("%02d:%02d:%02d", $H, $i, $s)."( Pro Film: ".sprintf("%02d:%02d:%02d", $Hd, $id, $sd).") (".$Counter.' von '.count($FilmeArr).") ";
				echo $status.PHP_EOL.PHP_EOL;
				file_put_contents("./phpTestout/default.txt", $status." ".$value[1].PHP_EOL.PHP_EOL, FILE_APPEND);
			}
			echo $this->Console->getColoredString("Alle Filme Verarbeitet!", "green", "light_gray") .PHP_EOL;
			echo "Folgende Filme konten nicht verarbeitet werden: ".PHP_EOL;
			foreach ($fehlerArr as $fehler) {
				echo $fehler.PHP_EOL;
			}
			$end = time();
			$laufzeit = $end - $start;
				$H = floor($laufzeit / 3600);
				$i = ($laufzeit / 60) % 60;
				$s = $laufzeit % 60;
			
			$status =  "Gesamtlaufzeit: ".sprintf("%02d:%02d:%02d", $H, $i, $s)."! ".$Counter.' von '.count($FilmeArr).PHP_EOL.PHP_EOL;
			echo $status;
			file_put_contents("./phpTestout/default.txt", $status.PHP_EOL, FILE_APPEND);
			
			//trim(fgets(STDIN));
			echo PHP_EOL;
			//return ;
		}
		else if($action == "update"){
			echo $this->Console->getColoredString("Filme > update", "black", "light_gray") .PHP_EOL;
			
			$mysqli = new mysqli($this->config["DB_Server"],$this->config["DB_Username"],$this->config["DB_Passwort"],$this->config["DB_Database"]);
			if($mysqli->connect_error != ""){		echo "Mysql-Fehler: ".$mysqli->connect_error.PHP_EOL; return false;}
			$Query = "SELECT * FROM Filme;";
			//echo $Query.PHP_EOL;
			$result = $mysqli->query($Query); //TODO 3D überprüfung!!!
			
			if($mysqli->error != ""){		echo "Mysql-Fehler: ".$mysqli->error.PHP_EOL; return false;}
			while ($Film = $result->fetch_assoc()){
				echo "Hole Daten von imdb... ";
				// Werte aus IMdb Auslesen...
				$imdb = new IMDB("http://www.imdb.com/title/tt".$Film["imdbID"]."/");
				if ($imdb->isReady) {
					//var_dump($imdb->getAll());
					//$array["year"] = $imdb->getYear();
					//$array["size"] = $this->getfileSize($Pfad.$FilenameOrg);
				
					//$array["md5"] = md5_file("/tmp/".$array["imdbID"].".xml");
					//$array["rating"] = $imdb->getRating();
					//$array["Genre"] = $imdb->getGenre();
					//$array["Schauspieler"] = $imdb->getCastAsOwn(0, false);
					
					$fsktemp = $imdb->getCertification();
					//var_dump($fsktemp);
					/*if(!(strpos( $fsk,"West Germany") == false)){
						$fsk = trim(substr($fsk,strpos( $fsk,"West Germany")+13,3));
					}else*/ 
					if(!(strrpos( $fsktemp,"Germany:") == false)){
						$fsk = trim(substr($fsktemp,strrpos( $fsk,"Germany:")+8,15));
					}else{
						$fsk = "";
						var_dump($fsktemp);
						echo $this->Console->error("keine fsk gefunden!").PHP_EOL; 
					}
					
					
				} else{
					echo $this->Console->error("imdbID nicht bei imdb gefunden!").PHP_EOL;
					//file_put_contents("./phpTestout/".$array["imdbID"].".txt", "Keine Infos auf imdbID gefunden: ".$Pfad.$FilenameOrg.PHP_EOL, FILE_APPEND);
					break;
				}
				echo " done!".PHP_EOL;
				
				echo ">".$fsk."<FSK =>".$Film["imdbID"].$Film["name"].PHP_EOL;
			}
			echo PHP_EOL;
			$end = time();
			$laufzeit = $end - $start;
			$H = floor($laufzeit / 3600);
			$i = ($laufzeit / 60) % 60;
			$s = $laufzeit % 60;
				
			$status =  "Gesamtlaufzeit: ".sprintf("%02d:%02d:%02d", $H, $i, $s)."!".PHP_EOL.PHP_EOL;
				
		}
	}
	private function parseMovie($Pfad, $Filename){
		$PfadOrg = $Pfad;
		$Pfad = $this->PfadzumEinlesen.'/'.$Pfad;
		if(is_file($Pfad.$Filename)){
			$array = array();
			$FilenameOrg = $Filename;
			echo $Pfad.$FilenameOrg.PHP_EOL;
			
			$array["hdd"] = $this->HDDID;
			if(strpos($Filename, "(3D)")>0){
				$Filename = str_replace("(3D)", "", $Filename);
				$array["3d"] = "ja";
			}
			else{ $array["3d"] = ""; }
			if(strpos($Filename, "(720p)")>0){
				$Filename = str_replace("(720p)", "", $Filename);
				$array["resolution"] = "720p";
			}
			else if(strpos($Filename, "(1080p)")>0){
				$Filename = str_replace("(1080p)", "", $Filename);
				$array["resolution"] = "1080p";
			}
			else if(strpos($Filename, "(SD)")>0){
				$Filename = str_replace("(SD)", "", $Filename);
				$array["resolution"] = "SD";
			}
			if(!(strripos( $Filename,"(") == false)){
				$array["imdbID"] = substr($Filename,strripos( $Filename,"(")+1,7);
			}
			//echo strlen($array["imdbID"])." ".$array["imdbID"].PHP_EOL;
			if(!isset($array["imdbID"])){  //strlen($array["imdbID"])<=2
				file_put_contents("./phpTestout/default.txt", "Keine imdbID in Dateinamen: ".$Pfad.$Filename." gefunden!".PHP_EOL, FILE_APPEND);
				return false;
			}
			$array["name"]   = trim(substr($Filename, 0, strripos( $Filename,"(")));
			$Endung = trim(substr($Filename,strripos( $Filename,".")+1));
			
			echo "Hole Daten von imdb... ";
		// Werte aus IMdb Auslesen...
			$imdb = new IMDB("http://www.imdb.com/title/tt".$array["imdbID"]."/");
			if ($imdb->isReady) {
				//var_dump($imdb->getAll());
				$array["year"] = $imdb->getYear();
				$array["size"] = $this->getfileSize($Pfad.$FilenameOrg);
				
				//$array["md5"] = md5_file("/tmp/".$array["imdbID"].".xml");
				$array["rating"] = $imdb->getRating();
				$array["Genre"] = $imdb->getGenre();
				$array["Schauspieler"] = $imdb->getCastAsOwn(0, false);
				// TODO Summery und fsk und Youtube hinzufügen
			} else{
				echo $this->Console->error("imdbID nicht bei imdb gefunden!").PHP_EOL;
				file_put_contents("./phpTestout/".$array["imdbID"].".txt", "Keine Infos auf imdbID gefunden: ".$Pfad.$FilenameOrg.PHP_EOL, FILE_APPEND);
				return false;
			}
			echo " done!".PHP_EOL;
		// werte von MediaInfo holen...
			echo "Hole Daten von mediainfo... ";
			$befehl = 'mediainfo --Output=XML "'.$Pfad.$FilenameOrg.'" > /tmp/'.$array["imdbID"].'.xml';
			exec($befehl);
			$xmlstring = file_get_contents('/tmp/'.$array["imdbID"].'.xml');
			$xml = simplexml_load_string($xmlstring);
			$json = json_encode($xml,JSON_PRETTY_PRINT);
			$array2 = json_decode($json,TRUE);
			foreach ($array2["File"]["track"] as $key => $value) {
				//echo " ".$key." ".$value["@attributes"]["type"].PHP_EOL;
				switch ($value["@attributes"]["type"]) {
					case "General":
						$array["vcodec"] = str_replace("Matroska", "mkv", $value["Format"]);
						$array["duration"] = $this->getRunTime($value["Duration"]);
						$array["totalbitrate"] = round(trim(str_replace(" ", "",str_replace("Mbps", "", $value["Overall_bit_rate"])))*1024,0);
						break;
					case "Video":
						$array["width"] = trim(str_replace(" ", "",str_replace("pixels", "",$value["Width"])));
						//TODO Resolution aus diesen werten neusetzen
						$array["height"] = trim(str_replace(" ", "",str_replace("pixels", "",$value["Height"])));
						break;					
					case "Audio":
						if(isset($value["Language"])){
							if(($value["Language"] == "Deutsch") OR ($value["Language"] == "German")){
								$array["acodecger"] = $value["Format"];
								$array["abitrateger"] = round(trim(str_replace(" ", "",str_replace("Kbps", "",$value["Bit_rate"]))),0);
								$array["channelsger"] = str_replace(" channels", "",$value["Channel_s_"]);
								if(!is_numeric($array["channelsger"])){
									$array["channelsger"] = substr($array["channelsger"],strripos( $array["channelsger"],"/")+1);
									if(!is_numeric($array["channelsger"])){
										echo $this->Console->error("channelsger ist nicht Numerisch!").PHP_EOL;
										file_put_contents("./phpTestout/".$array["imdbID"].".txt", "channelsger ist nicht Numerisch!".PHP_EOL, FILE_APPEND);
										return false;
									}
								}
							}
							else if(($value["Language"] == "Englisch") OR ($value["Language"] == "English")){
								$array["acodeceng"] = $value["Format"];
								$array["abitrateeng"] = round(trim(str_replace(" ", "",str_replace("Kbps", "",$value["Bit_rate"]))),0);
								$array["channelseng"] = str_replace(" channels", "",$value["Channel_s_"]);
								if(!is_numeric($array["channelseng"])){
									$array["channelseng"] = substr($array["channelseng"],strripos( $array["channelseng"],"/")+1);
									if(!is_numeric($array["channelseng"])){
										echo $this->Console->error("channelseng ist nicht Numerisch!").PHP_EOL;
										file_put_contents("./phpTestout/".$array["imdbID"].".txt", "channelseng ist nicht Numerisch!".PHP_EOL, FILE_APPEND);
										return false;
									}
								}
							}
						}
						break;
				}
			}
			echo " done!".PHP_EOL;
			if( $this->addMovie($array, $Pfad.$FilenameOrg)){
				if(($Pfad.$FilenameOrg) == ($this->PfadzumAusgeben.($array["3d"]==""?$this->config["HDD"][$this->HDDID]["Filme"]:$this->config["HDD"][$this->HDDID]["3D"]).$PfadOrg.$array["name"]." (".$array["resolution"].")".($array["3d"] != ""?" (3D)":"")." (".$array["imdbID"].").".$Endung)){
					echo "Datei liegt schon am ausgabe Ort!".PHP_EOL;
				}
				else{
					
					if(!is_dir($this->PfadzumAusgeben.($array["3d"]==""?$this->config["HDD"][$this->HDDID]["Filme"]:$this->config["HDD"][$this->HDDID]["3D"]).$PfadOrg)){
						shell_exec("mkdir '".$this->PfadzumAusgeben.($array["3d"]==""?$this->config["HDD"][$this->HDDID]["Filme"]:$this->config["HDD"][$this->HDDID]["3D"]).$PfadOrg."'");
					}
					echo "Verschiebe Datei...";
					
					$copy = 'mv "'.
						$Pfad.$FilenameOrg.'" "'.
						$this->PfadzumAusgeben.($array["3d"]==""?$this->config["HDD"][$this->HDDID]["Filme"]:$this->config["HDD"][$this->HDDID]["3D"]).$PfadOrg.$array["name"]." (".$array["resolution"].")".($array["3d"] != ""?" (3D)":"")." (".$array["imdbID"].").".$Endung.'"';
					file_put_contents("./phpTestout/".$array['imdbID'].".txt", $copy.PHP_EOL, FILE_APPEND);
					shell_exec($copy);
					echo "done!".PHP_EOL;
				}
				shell_exec("mv './phpTestout/".$array["imdbID"].".txt' './phpTestout/OK_".$array["imdbID"].".txt'");
				return true;
			}
			else{
				echo $this->Console->error("Fehler beim Eintragen in die DB!").PHP_EOL;
				file_put_contents("./phpTestout/".$array["imdbID"].".txt", "Fehler beim Eintragen in die DB".PHP_EOL, FILE_APPEND);
				return false;
			}
		}else{
			echo $this->Console->error("Datei Existiert nicht!").PHP_EOL;
			file_put_contents("./phpTestout/default.txt", "Datei existiert nicht: ".$Pfad.$Filename.PHP_EOL, FILE_APPEND);
			return false;
		}
	}
	private function addMovie($DataArr, $File){
		
		$mysqli = new mysqli($this->config["DB_Server"],$this->config["DB_Username"],$this->config["DB_Passwort"],$this->config["DB_Database"]);
		if($mysqli->connect_error != ""){		echo "Mysql-Fehler: ".$mysqli->connect_error.PHP_EOL; return false;}
		$Query = "SELECT imdbID FROM Filme WHERE imdbID = '".$DataArr['imdbID']."' AND ".
				'3d '.($DataArr['3d']?"!=":"=").'""';
		//echo $Query.PHP_EOL;
		$result = $mysqli->query($Query); //TODO 3D überprüfung!!!
		
		if($mysqli->error != ""){		echo "Mysql-Fehler: ".$mysqli->error.PHP_EOL; return false;}
		if($result->num_rows>0){
			echo "Film bereits in DB!".PHP_EOL;
			file_put_contents("./phpTestout/".$DataArr['imdbID'].".txt", "Film bereits in DB!".PHP_EOL, FILE_APPEND); 
			return false;
		}
		// Jetzt noch MD5 berechnen 
		echo "Berechne MD5... ";
		//$DataArr["md5"] = substr(shell_exec('md5sum -b "/tmp/'.$DataArr['imdbID'].'.xml"'),0,32); //TODO Einkommentieren für md5
		$DataArr["md5"] = substr(shell_exec('md5sum -b "'.$File.'"'),0,32);
		file_put_contents("./phpTestout/".$DataArr['imdbID'].".txt", "md5 = ".$DataArr["md5"].PHP_EOL, FILE_APPEND);
		//$array["md5"] = substr(shell_exec('md5sum -b "'."/tmp/".$DataArr["imdbID"].".xml".'"'),0,32);
		echo " done!".PHP_EOL;
		
		// und Jetzt Querys Ausführen...
		$Querys= array();
		$keys = array("views", "checked", "comment", "added");
		$values = array(0, "null", "''", "'".date("Y-m-d")."'");
		
		foreach ($DataArr as $key => $value) {
			if(in_array($key, array("Genre", "Schauspieler")) ){//TODO hier weiter!!
				//echo " ".$key." => '".implode("|", )."'".PHP_EOL;
				//var_dump($value);
				if ($key == "Genre"){
					$genreArr = explode(" / ", $value);
					echo "Genre anlegen... ";
					foreach ($genreArr as $value) {
						$Querys[] =  "INSERT INTO FilmGenre (imdbID, genreID) VALUES ('".$DataArr['imdbID']."', '".$this->getGenreID($mysqli, $value)."');";
					}
					echo "done".PHP_EOL;
				}
				else if ($key == "Schauspieler"){
					$Schauspielers = explode(" / ", $value);
					//var_dump($Schauspielers);
					echo "Schauspieler anlegen... ";
					foreach ($Schauspielers as $value) {
						$Schauspieler = explode(">", str_replace("nm", "", $value));
						$Querys[] = "INSERT INTO FilmSchauspieler (imdbID, schauspielerID) VALUES ('".$DataArr['imdbID']."', '".$this->getSchauspielerID($mysqli, $Schauspieler[1],$Schauspieler[0])."');";
					}
					echo "done".PHP_EOL;
				}
			}else{
				$keys[] = $key;
				$values[] = "'".mysql_escape_string(utf8_encode(value))."'";
			}
		}
		echo "Film eintragen... ";
		$Query = "INSERT INTO Filme (".implode(",", $keys).") VALUES (".implode(",", $values).");"; //TODO Query ausführen!!
				
		$result = $mysqli->query($Query);
		file_put_contents("./phpTestout/".$DataArr['imdbID'].".txt", $Query.PHP_EOL, FILE_APPEND);
		if($mysqli->error != ""){
			echo "Mysql-Fehler: ".$mysqli->error.PHP_EOL;
			file_put_contents("./phpTestout/".$DataArr['imdbID'].".txt", "Mysql-Fehler: ".$mysqli->error.PHP_EOL, FILE_APPEND);
			return false;
		}
		echo "done".PHP_EOL;
		//echo $this->Console->getColoredString("Query", "light_gray", "green")." ".$Query.PHP_EOL;
		
		echo "Lege FilmSchauspieler und FilmGenre Verküpfungen an...";
		foreach ($Querys as $Query) {
			//echo $this->Console->getColoredString("Query", "light_gray", "green")." ".$Query.PHP_EOL;
			
			$result = $mysqli->query($Query);
			file_put_contents("./phpTestout/".$DataArr['imdbID'].".txt", $Query.PHP_EOL, FILE_APPEND);
			if($mysqli->error != ""){		
				echo "Mysql-Fehler: ".$mysqli->error.PHP_EOL; 
				file_put_contents("./phpTestout/".$DataArr['imdbID'].".txt", "Mysql-Fehler: ".$mysqli->error.PHP_EOL, FILE_APPEND);
				return false;
			}
			
			//TODO Query ausführen!!
		}
		echo "done!".PHP_EOL;
		$mysqli->close();
		return true;
	}
	private function getGenreID($mysqli, $GenreName){ 
		$GenreName = $mysqli->real_escape_string($GenreName);
		$result = $mysqli->query("SELECT genreID FROM Genre WHERE engname = '".mysql_escape_string(utf8_encode($GenreName))."'");
		if($mysqli->error != ""){		echo "Mysql-Fehler: ".$mysqli->error.PHP_EOL; return false;}
		if($result->num_rows>0){
			$resultArr = $result->fetch_array();
			//echo PHP_EOL.$this->Console->getColoredString("Genre Existiert", "light_gray", "green")." ".$result->num_rows.PHP_EOL;
			return $resultArr["genreID"];
		}
		else{
			$Query = "INSERT INTO Genre (engname) VALUES('".mysql_escape_string(utf8_encode($GenreName))."')";
			$mysqli->query($Query);
			return $mysqli->insert_id; //TODO nicht getestet Ob das überhaupt geht?! 
		}
	}
	private function getSchauspielerID($mysqli, $SchauspielerName, $SchauspielerID){
		$SchauspielerName = $mysqli->real_escape_string($SchauspielerName);
		$result = $mysqli->query("SELECT schauspielerID FROM Schauspieler WHERE name = '".mysql_escape_string(utf8_encode($SchauspielerName))."'");
		//echo "SELECT schauspielerID FROM Schauspieler WHERE name = '".$SchauspielerName."'".PHP_EOL;
		if($mysqli->error != ""){		echo "Mysql-Fehler: ".$mysqli->error.PHP_EOL; return false;}
		if($result->num_rows > 0){
			$resultArr = $result->fetch_array();
			//echo PHP_EOL.$this->Console->getColoredString("Schauspieler Existiert", "light_gray", "green")." ".$SchauspielerName.PHP_EOL;
			return $resultArr["schauspielerID"];
		}
		else{
			$Query = "INSERT INTO Schauspieler (name, schauspielerID) VALUES('".mysql_escape_string(utf8_encode($SchauspielerName))."', '".$SchauspielerID."');";
			//echo PHP_EOL.$this->Console->getColoredString("Query", "light_gray", "green")." ".$Query.PHP_EOL;
			echo $SchauspielerName.", ";
			$mysqli->query($Query);
			return $SchauspielerID;
		}
	}
	private function getRunTime($laufzeit){
		$string = explode(" ", $laufzeit);
		return ((trim(str_replace("h", "", $string[0]))*3600)+(trim(str_replace("m", "", $string[1])*60)));
	}
	private function getfileSize($file){
		return trim(explode("/", exec('du -b "'.$file.'"'))[0]);
		
	}
	private function dirtoArray($dir, $root = ''){
		$Arr = scandir($dir);
		foreach ($this->config["FolderIgnor"] AS $value){
			unset($Arr[array_search($value, $Arr)]);
		}
		foreach ( $Arr AS $Key => $Value){
			if(is_dir ($dir.'/'.$Value) AND !in_array($Value, $this->config["FolderIgnor"])){
				$SubDir = $this->dirtoArray($dir.'/'.$Value, ($root==""?"":$root.'/').$Value);
				//echo PHP_EOL.$dir.'  /   '.$Value." ". ($root==""?"":$root.'/').$Value.PHP_EOL;
			}
			else{
				$this->FolderArray[] = array($root, $Value);
			}
		}
		return $this->FolderArray;
	}
}